<%--
  - FILE
  -  selUpdComponent.jsp
  -
  - DESCRIPTION
  -  The select update components step of the Patch Advisor Interview wizard.
  -  It captures the software update components.
  -
  - MODIFIED   (MM/DD/YY)
  -  vsubrahm   03/16/09 - Show instance names for RAC
  -  amroy      09/14/06   - 
  -  shgangul   07/18/06   - 11g GUI changes 
  -  tasingh    07/27/05   - Change the Patch Selection mechanism.
  -  tasingh    07/20/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<script>
function applySqlSelected()
   {

       if(document.pageForm.applySql.checked == true)
       {
          document.pageForm.applyDefaultSql.disabled = false;
          document.pageForm.sqlScriptLoc.disabled = false;
       }
      else
      {
        document.pageForm.applyDefaultSql.disabled = true;
        document.pageForm.sqlScriptLoc.disabled = true;
      }

    }


</script>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <%-- uix:stackLayout>
      <uix:styledText
        textBinding="SEL_UPD_COMP_TXT@patchAdvisorRB"
        styleClass="oraInstructionText">
      </uix:styledText>
      <uix:spacer height="10"/>
    </uix:stackLayout --%>

    <%--Target List--%>
    <uix:styledText textBinding="SEL_PAGE_TIP1@patchAdvisorRB" styleClass="OraTipText"/>
    <uix:header textBinding="TARGET_LIST@patchAdvisorRB">
    <uix:labeledFieldLayout width="50%">
       <uix:styledText
           styleClass="OraDataText"
           textBinding="DATABASE_NAME@patchAdvisorRB"
	   renderedBinding="racMode@servletRequest" />
       <uix:link
         destinationBinding="dbrevDisplayDBLink@servletRequest" 
         textBinding="dbrevDisplayDB@servletRequest"
         renderedBinding="racMode@servletRequest" />
      <uix:styledText
        styleClass="OraDataText"
        textBinding="INSTANCE_NAMES@patchAdvisorRB" />
      <uix:link
        destinationBinding="dbrevDisplayTargetsLink@servletRequest" 
        textBinding="dbrevDisplayTargets@servletRequest" />
      <uix:styledText
        styleClass="OraDataText"
        textBinding="TARGET_TYPE@patchAdvisorRB" />
      <uix:styledText
        styleClass="OraPromptText"
        textBinding="dbrevDisplayTargetType@servletRequest" />
      <uix:styledText
        styleClass="OraDataText"
        textBinding="RELEASE@patchAdvisorRB" />
      <uix:styledText
        styleClass="OraPromptText"
        textBinding="dbrevDisplayTargetVersion@servletRequest" />
      <uix:styledText
        styleClass="OraDataText"
        textBinding="HOST@patchAdvisorRB" />
      <uix:link
        destinationBinding="dbrevDisplayTargetHostLink@servletRequest" 
        textBinding="dbrevDisplayTargetHost@servletRequest" />

    <%--Stage Directory--%>
    <uix:messageTextInput
      name="stageDirLoc"
      text="%oracle_home%/EMStagedPatches"
      columns="35"
      textBinding="stageDirLoc@stepsData@servletRequest"
      promptBinding="STAGING_LOCATION@patchAdvisorRB"
      shortDescBinding="STAGING_LOCATION@patchAdvisorRB"
      tipBinding="STAGED_LOC_TIP_TXT@patchAdvisorRB"
      messageTypeBinding="stageDirMsgType@pageData@servletRequest"
      messageBinding="stageDirMsg@pageData@servletRequest">
    </uix:messageTextInput>
    </uix:labeledFieldLayout>
    </uix:header>

    <%
      String refIDs[] = ( String[]) request.getAttribute( "refIDs");
      String hdrTxts[] = ( String[]) request.getAttribute( "hdrTxts");
      String descTxts[] = ( String[]) request.getAttribute( "descTxts");

      String stageApplyTxts[] 
        = ( String[]) request.getAttribute( "stageApplyTxts");

      int noOfPageSegments = 0;

      if( refIDs != null)
      {
        noOfPageSegments = refIDs.length;
      }
      for( int i = 0; i < noOfPageSegments; i++)
      {
      %>
      <uix:spacer height="10"/>
      <uix:header text="<%=hdrTxts[i]%>">
        <uix:stackLayout>
          <uix:styledText 
            text="<%=descTxts[i]%>"
            styleClass="oraInstructionText">
          </uix:styledText>
          <uix:styledText
            text="<%=stageApplyTxts[i]%>"
            styleClass="oraInstructionText">
          </uix:styledText>
          <uix:spacer height="10"/>
          <uix:ref refID="<%=refIDs[i]%>"/>
        </uix:stackLayout>
        <uix:separator/>
      </uix:header>
      <%
      }
    %>
  </uix:dataScope> 
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
