<!---->
<%--
  - FILE
  -   softCompSeg.jsp
  -
  - DESCRIPTION
  -   PageSegment to display table for Oracle Software Component selection.
  -
  - MODIFIED   (MM/DD/YY)
  -   gmanglik  05/15/07 - ada fixes
  -   gmanglik  05/15/07 - ada fixes
  -   amroy     09/14/06  - 
  -   shgangul  06/27/06  - GUI changes for 11g DBCtrl 
  -   shgangul  06/27/06  - GUI changes for 11g DBCtrl 
  -   tasingh   03/14/06  - Do not show default sql check box as a check box 
  -                         on the review page. 
  -   tasingh   02/23/06  - Handle pagination problem 
  -   tasingh   12/30/05  - bug:4918810 Change popup to an embedded page. 
  -   tasingh   12/01/05  - Disabling the provision to add Software Update 
  -                         Component by name. 
  -   tasingh   08/04/05  - created
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<oem:pageSegment>
  <uix:dataScope>

    <%--Common UI messages --%>
    <uix:bundle
      name="sdkUIMsg"
      class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
      name="commonResourceBundle"
      class="oracle.sysman.resources.CommonResourceBundle"/>

    <%--ResourceBundle for labels/headers specific to Patch Advisor Project--%>
    <uix:bundle
      name="patchAdvisorRB"
      class="oracle.sysman.db.pa.ui.rb.PatchAdvisorRB"/>
    <uix:bundle
      name="PPpatchAdvisorRB"
      class="oracle.sysman.pp.pa.ui.rb.PatchAdvisorRB"/>

    <uix:document>
      <uix:styledText
        textBinding="STAGE_APPLY_CHK_BX_TXT@patchAdvisorRB"
        renderedBinding="stageApplyChkBoxesTxtRendered@pageSegmentBean@"
        styleClass="oraInstructionText">
      </uix:styledText>
      <uix:inlineMessage
        renderedBinding="stageApplyChkBoxesRendered@pageSegmentBean@"
        messageTypeBinding="msgType@stageApplyErrMsg@pageSegmentBean@"
        messageBinding="msg@stageApplyErrMsg@pageSegmentBean@">
        <uix:tableLayout>
          <uix:rowLayout>
            <uix:messageCheckBox
              nameBinding="stageChkBxName@pageSegmentBean@"
              textBinding="STAGE@patchAdvisorRB"
              checkedBinding="stageChkBxVal@pageSegmentBean@"
              disabledBinding="viewOnlyModeBool@pageSegmentBean@">
            </uix:messageCheckBox>
            <uix:spacer width="5"/>
            <uix:checkBox
              nameBinding="applyChkBxName@pageSegmentBean@"
              textBinding="APPLY@patchAdvisorRB"
              checkedBinding="applyChkBxVal@pageSegmentBean@"
              disabledBinding="viewOnlyModeBool@pageSegmentBean@">
            </uix:checkBox>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:inlineMessage>

      <%-- For the time being disable the provision to add Software Update
           Component by its name. --%>
      <%--<uix:stackLayout 
        renderedBinding="oraUpdtCompInputBoxRendered@pageSegmentBean@"--%>
      <uix:stackLayout 
        rendered="false">
        <uix:messageTextInput
          nameBinding="oraUpdtCompInputBxName@pageSegmentBean@"
          textBinding="oraUpdtCompInputBxTxt@pageSegmentBean@"
          promptBinding="SEARCH_SOFT_UPDT_BY_NAME@patchAdvisorRB"
          shortDescBinding="SEARCH_SOFT_UPDT_BY_NAM@patchAdvisorRB"
          messageTypeBinding="msgType@searchSoftUpdtMsgInfo@pageSegmentBean@"
          messageBinding="msg@searchSoftUpdtMsgInfo@pageSegmentBean@">
          <uix:end>
            <uix:flowLayout>
              <uix:submitButton
                name="event"
                valueBinding="addCompFrmInputBxEventVal@pageSegmentBean@"
                textBinding="ADD_PATCHES_REV@patchAdvisorRB">
              </uix:submitButton>
            </uix:flowLayout>
          </uix:end>
        </uix:messageTextInput>
        <uix:spacer height="5"/>
      </uix:stackLayout>


      <%--oracle software update component table--%>
      <uix:inlineMessage
        renderedBinding="softCompTableRendered@pageSegmentBean@"
        messageTypeBinding="msgType@softUpdtMsgInfo@pageSegmentBean@"
        messageBinding="msg@softUpdtMsgInfo@pageSegmentBean@">
        
        <%-- This is a hack to get the tableID. Since idBindingis not supported
           - I will get the pageSegmentBean from the pageSegmentContext and
           - get the tableID. The importance of tableID is, it is required for
           - partialPageRenderring. Since a page could use this pageSegment
           - many times, so the table ID should be unique for partial page
           - rendering to work.
           --%>
        <%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
        <%@ page import='oracle.sysman.db.pa.ui.beans.SoftCompSegBean' %>
        <%
          PageSegmentContext psContext
            = ( PageSegmentContext) request.getAttribute( "pageSegmentContext");

          SoftCompSegBean pageSegBean
            = ( SoftCompSegBean) psContext.getPageSegmentBean( );

          String tableID = pageSegBean.getTableID( );
         %>

         <%-- The following line creats an anchor.--%>
         <uix:link nameBinding="tableName@pageSegmentBean@"/>

        <uix:table
          width="100%"
          nameBinding="tableName@pageSegmentBean@"
          id="<%=tableID%>"
          partialRenderMode="self"
          summaryBinding="SOFT_COMP_TABLE_SUMMARY@patchAdvisorRB"
          formSubmitted="true"
          alternateTextBinding="SOFT_COMP_TABLE_ALT_TEXT@patchAdvisorRB"
          tableDataBinding="rows@pageSegmentBean@"
          valueBinding="currentValue@pageSegmentBean@"
          minValueBinding="minValue@pageSegmentBean@"
          blockSizeBinding="blockSize@pageSegmentBean@"
          maxValueBinding="maxValue@pageSegmentBean@"
          summary="Patches"
          columnHeaderDataBinding="columnHeaders@pageSegmentBean@">

          <%-- Bug: 4918810: Change popup to embedded page --%>
          <%--
          <uix:tableActions>
            <uix:button
              renderedBinding="addBtnRendered@pageSegmentBean@"
              onClickBinding="addBtnOnClickStr@pageSegmentBean@"
              textBinding="ADD@commonResourceBundle"/>
          </uix:tableActions>
          --%>
          <uix:tableActions>
              <uix:submitButton
                renderedBinding="addBtnRendered@pageSegmentBean@"
                name="event"
                valueBinding="addBtnEvent@pageSegmentBean@"
                textBinding="ADD_PATCHES_REV@patchAdvisorRB"/>
          </uix:tableActions>
          <%-- end bug: 4918810--%>

          <uix:tableSelection>
            <uix:multipleSelection
              renderedBinding="mulSelRendered@pageSegmentBean@"
              selectedBinding="rowSelected"
              shortDescBinding="SELECT@commonResourceBundle">

              <uix:submitButton
                name="event"
                valueBinding="remSoftCompEventVal@pageSegmentBean@"
                renderedBinding="remBtnRendered@pageSegmentBean@"
                textBinding="REMOVE@commonResourceBundle"/>

            </uix:multipleSelection>
          </uix:tableSelection>

          <uix:tableFormat tableBanding="rowBanding"/>

          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"
              sortableBinding="sortable">
            </uix:sortableHeader>
          </uix:columnHeaderStamp>

          <uix:styledText textBinding="compName"/>
          <uix:styledText textBinding="patchID"/>
          <uix:styledText textBinding="createdOn"/>
          <uix:styledText textBinding="type"/>
          <uix:styledText textBinding="product"/>
          <uix:styledText textBinding="platform"/>
          <uix:styledText textBinding="release"/>
          <uix:styledText textBinding="interimPatchAppOn"/>
          <uix:styledText textBinding="description"/>
          <uix:button
             textBinding="README_BTN@PPpatchAdvisorRB"
             rendered="true"
             renderedBinding="readMeColRendered@pageSegmentBean@"
             onClickBinding="readme"
           />
          <uix:image
               source="/em/images/deleteicon_enabled.gif" 
               renderedBinding="deleteIconRendered@pageSegmentBean@"
               primaryClientActionBinding="REMOVE_DEST"
               shortDesc="Remove patch selection"
               textBinding="Remove"/>
        </uix:table>
           <%-- uix:tableLayout width="100%">
              <uix:rowLayout width="100%" hAlign="right" >
                <uix:button 
                renderedBinding="removeAllBtn@pageSegmentBean@"
                   primaryClientActionBinding="removeAll@servletRequest"
                   textBinding="REMOVE_ALL_BTN_TEXT@PPpatchAdvisorRB"
                      />
              </uix:rowLayout>
           </uix:tableLayout --%>
    
      </uix:inlineMessage>

      <uix:spacer height="20"/>
      <uix:header renderedBinding="sqlStepRendered@pageSegmentBean@"
               textBinding="POST_PATCH_SQL@patchAdvisorRB"/>


     <%--Test Code for checkbox --%>
     
        <%-- uix:spacer width="25"/>
        <uix:checkBox
          textBinding="APPLY_SQL@patchAdvisorRB"
          name="applySql"
          id="applySql"
          renderedBinding="sqlStepRendered@pageSegmentBean@"
          checkedBinding="applySql@pageSegmentBean@"
          primaryClientActionBinding="onApplySql@servletRequest"/ --%>
<%--          onClick="javascript:applySqlSelected();" /> --%>

     <%--End here checkbox --%>
          <uix:tableLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:flowLayout>
          <uix:spacer width="35"/>
          <uix:radioButton
            renderedBinding="sqlStepRendered@pageSegmentBean@"
            textBinding="APPLY_SQL_SECTION_DEFAULT@patchAdvisorRB"
            name="applyDefaultSql"
            id="applyDefaultSql"
            value="on"
            disabled="false"           
            selectedBinding="defaultSql@pageSegmentBean@"/>
          </uix:flowLayout>
          </uix:rowLayout>
          </uix:tableLayout>
        
          <uix:tableLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:flowLayout>
          <uix:spacer width="35"/>
          <uix:contents>
          <uix:radioButton
            renderedBinding="sqlStepRendered@pageSegmentBean@"
            textBinding="CUSTOM_SQL@patchAdvisorRB"
            name="applyDefaultSql"
            id="applyUserSql"
            value="off"
            disabled="false"           
            selectedBinding="negDefaultSql@pageSegmentBean@"/>
           
          <uix:textInput
            renderedBinding="sqlStepRendered@pageSegmentBean@"
            name="sqlScriptLoc"
            id="sqlScriptLoc"
            required="uiOnly"
        
            disabled="false"
            textBinding="sqlScriptLoc@pageSegmentBean@"
            shortDescBinding="CUSTOM_SQL@patchAdvisorRB">
          </uix:textInput>
           <uix:spacer width="5"/>
           <uix:styledText textBinding="APPLY_SQL_SECTION_EXAMPLE@patchAdvisorRB" styleClass="OraTipText"/>
          </uix:contents>
          </uix:flowLayout>
          </uix:rowLayout>
          </uix:tableLayout>
          <uix:tableLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:rowLayout renderedBinding="sqlStepRendered@pageSegmentBean@">
          <uix:flowLayout>
          <uix:spacer width="35"/>
          <uix:radioButton
            renderedBinding="sqlStepRendered@pageSegmentBean@"
            textBinding="NONE_SQL@patchAdvisorRB"
            name="applyDefaultSql"
            id="applyNoneSql"
            value="none"
            disabled="false"           
            selectedBinding="negApplySql@pageSegmentBean@"/>
          </uix:flowLayout>
          </uix:rowLayout>
          </uix:tableLayout>

    </uix:document>
  </uix:dataScope>
</oem:pageSegment>
