<%--
  - FILE
  -   targetList.jsp
  -
  - DESCRIPTION
  -  The target selection step of the Patch Advisor Interview wizard.
  -
  - MODIFIED   (MM/DD/YY)
  -  amroy      09/14/06 - 
  -  shgangul   09/14/06   - 
  -  tasingh    10/24/05   - Use new Target Selector page segment. 
  -  tasingh    07/27/05   - tasingh_patch_ad_ui
  -  tasingh    07/12/05   - Created
  -
  - SINCE
  -  10.2+
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText
          textBinding="SEL_TARGET_LIST_TXT@patchAdvisorRB"
          styleClass="oraInstructionText"/>
      </uix:rowLayout>
    </uix:tableLayout>
    <uix:spacer height="10"/>

    <%
      String refIDs[] = ( String[]) request.getAttribute( "refIDs");
      String hdrTxts[] = ( String[]) request.getAttribute( "hdrTxts");

      int noOfPageSegments = 0;

      if( refIDs != null)
      {
        noOfPageSegments = refIDs.length;
      }
      for( int i = 0; i < noOfPageSegments; i++)
      {
      %>
      <uix:header text="<%=hdrTxts[i]%>">
        <uix:ref refID="<%=refIDs[i]%>"/>
        <uix:separator/>
      </uix:header>
      <%
      }
    %>

  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
