<%-- 
    vmaddali	07/24/03 - Created
    this renders the generic options page which includes listener port and instance prefix
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@rconfigBean@servletRequest" method="post" copyParams="target,type">
      <uix:formValue name="source"/>
      <uix:formValue name="value"/>
      <uix:pageLayout titleBinding="OPTIONS_CONVERT@rconfigBundle@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rconfig/trainMessages.jspf" %>
                
        <uix:spacer height="10"/>
        <uix:pageStatus>
        <uix:flowLayout>
        <uix:contents>

        <uix:header textBinding="LISTENER_PORT@rconfigBundle@servletRequest" size="1">           
          <uix:stackLayout>            
           <uix:spacer height="10"/>
            <uix:styledText textBinding="LISTENER_CONFIG_INTRO@rconfigBundle@servletRequest" styleClass="OraInstructionText"/>
            <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2">
                  <uix:messageRadioButton name="lsnrType" value="existing"
                     selectedValueBinding="lsnrType@defaultBean@servletRequest"
                     textBinding="LSNR_EXISTING@rconfigBundle@servletRequest"
                     tipBinding="lsnrExistTip@defaultBean@servletRequest"
                     disabledBinding="isListenerNotExisting@defaultBean@servletRequest"
                     styleClass="OraInstructionText" />
                </uix:cellFormat>
            </uix:rowLayout>    
            <uix:rowLayout>            
              <uix:cellFormat hAlign="left" columnSpan="2">
                  <uix:messageRadioButton name="lsnrType" value="new"
                     selectedValueBinding="lsnrType@defaultBean@servletRequest"
                     textBinding="LSNR_NEW@rconfigBundle@servletRequest"
                     tipBinding="LSNR_NEW_TIP@rconfigBundle@servletRequest"
                     styleClass="OraInstructionText" />
              </uix:cellFormat>              
            </uix:rowLayout>
            <uix:spacer height="5"/>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
              <uix:messageTextInput promptBinding="LISTENER_PORT@rconfigBundle@servletRequest" 
                                 name="listenerPort"
                                 textBinding="listenerPort@defaultBean@servletRequest"
                                 columns="8"/> 
              </uix:cellFormat>               
            </uix:rowLayout>
          </uix:stackLayout>
        </uix:header>
        
        <uix:spacer height="10"/>
         
          <uix:header textBinding="INSTANCE_PREFIX@rconfigBundle@servletRequest" size="1">
            <uix:stackLayout>
             <uix:spacer height="10"/> 
              <uix:styledText textBinding="INSTANCE_PREFIX_INTRO@rconfigBundle@servletRequest" styleClass="OraInstructionText"/>
               <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:messageTextInput name="instancePrefix" 
                   textBinding="instancePrefix@defaultBean@servletRequest"
                   promptBinding="INSTANCE_PREFIX@rconfigBundle@servletRequest"
                   maximumLength="5"
                   required="uiOnly"/>
               </uix:rowLayout>
             </uix:stackLayout>
           </uix:header>
  
        </uix:contents>
        </uix:flowLayout>
      </uix:pageStatus>
 
         <uix:spacer height="10"/>
           
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@rconfigBundle@servletRequest" formName="foo" name="event" value="cancel"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

