<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destination="/console/database/rec/backup" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_ARCHIVELOGS@backupBundle@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

            <uix:styledText styleClass="OraInstructionText" textBinding="DELETE_AL_INTRO@backupBundle@servletRequest" />

            <uix:tableLayout cellSpacing="5" summary="tl"> 
              <uix:switcher childNameBinding="DB92orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" columnSpan="2"  headers="">
                        <oem:radioButton name="alDelType" value="delete_old"
                             selectedValueBinding="alDelType@defaultBean@servletRequest"
                             textBinding="AFTER_DAYS@backupBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="DB92orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left"  headers="">
                      <uix:spacer width="20"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left"  headers="">
                      <uix:messageTextInput name="alDays" 
                           promptBinding="DAYS@backupBundle@servletRequest" 
                           textBinding="alDays@defaultBean@servletRequest" 
                           columns="2">
                        <uix:onBlurValidater>
                          <uix:decimal/>
                        </uix:onBlurValidater>
                      </uix:messageTextInput>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>

              <uix:rowLayout> 
                <uix:cellFormat hAlign="left" columnSpan="2"  headers="">
                    <oem:radioButton name="alDelType" value="delete_all"
                         selectedValueBinding="alDelType@defaultBean@servletRequest"
                         textBinding="IMMEDIATELY@backupBundle@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2"  headers="">
                    <oem:radioButton name="alDelType" value="none"
                                     selectedValueBinding="alDelType@defaultBean@servletRequest"
                                     textBinding="NEVER@backupBundle@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>


         <uix:switcher childNameBinding="DB92orHigher@defaultBean@servletRequest">
         <uix:case name="true">
            <uix:stackLayout>
            <uix:spacer width="20"/>
            <uix:styledText styleClass="OraInstructionText" textBinding="AL_BACKUPS@backupBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left"  headers="">
                  <uix:spacer width="20"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left"  headers="">
                  <uix:messageTextInput name="alBackups" 
                       promptBinding="NUM_BACKUPS@backupBundle@servletRequest" 
                       textBinding="alBackups@defaultBean@servletRequest" 
                       columns="2">
                    <uix:onBlurValidater>
                      <uix:decimal/>
                    </uix:onBlurValidater>
                  </uix:messageTextInput>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            </uix:stackLayout>
        </uix:case>
        </uix:switcher>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel"  shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


