<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSource" value="availableTS"/>

      <uix:pageLayout titleBinding="BACKUP_AVAILABLE_TS@backupBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:location>
          <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
            <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
        </uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
       </uix:messages> 
          <uix:header textBinding="SEARCH@commonBundle@servletRequest">

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:flowLayout>
                          <uix:styledText
                             styleClass="OraPromptText"
                             labeledNodeId="searchFilter"
                            textBinding="TABLESPACE_NAME@commonBundle@servletRequest"/>
                          <uix:textInput name="searchFilter"
                            id="searchFilter"
                            textBinding="searchFilter@defaultBean@servletRequest"/>
                          <uix:submitButton
                            textBinding="GO@commonBundle@servletRequest"
                            onFocus="true"
                            selected="true" name="event" value="addTablespaces" shortDescBinding="GO@commonBundle@servletRequest"/>
                        </uix:flowLayout>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

        <uix:header textBinding="SEARCH_RESULTS@commonBundle@servletRequest">
          <oem:table
            width="80%"
            blockSize="10"
            formSubmitted="true"
            name="tablespacesUI"
            dataSourceProp="tablespacesUI"
            beanKey="tablespacesDataSourceBean"
            copyParams="target,type"
            alternateTextBinding="NO_ITEMS_SELECTED@commonBundle@servletRequest"
            summaryBinding="BACKUP_AVAILABLE_TS@backupBundle@servletRequest">
            <uix:tableSelection>
              <uix:multipleSelection 
                   shortDescBinding="SELECT@commonBundle@servletRequest"
                   selectedBinding="selected"
                   selectionBinding="selection@tablespacesDataSourceBean@servletRequest">
              </uix:multipleSelection>
            </uix:tableSelection>
          </oem:table>
        </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancelSelect" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:submitButton textBinding="SELECT@commonBundle@servletRequest" formName="foo" name="event" value="selectTablespaces" shortDescBinding="SELECT@commonBundle@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

