<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_SETUP@backupBundle@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

          <uix:switcher childNameBinding="incrementalSupported@defaultBean@servletRequest">
            <uix:case name="true">

              <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                <uix:case name="true">

                  <uix:switcher childNameBinding="deviceType@defaultBean@servletRequest">
                    <uix:case name="disk">
                      <uix:stackLayout>
                        <uix:header textBinding="DAILY_BACKUP@backupBundle@servletRequest">
                          <uix:styledText textBinding="DAILY_10_DISK@backupBundle@servletRequest" styleClass="OraInstructionText" />
                        </uix:header>
                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="sbt">
                      <uix:stackLayout>
                        <uix:header textBinding="DAILY_BACKUP@backupBundle@servletRequest">
                          <uix:switcher childNameBinding="alMode@defaultBean@servletRequest">
                            <uix:case name="ARCHIVELOG">
                              <uix:styledText textBinding="DAILY_10_TAPE@backupBundle@servletRequest" styleClass="OraInstructionText" />
                            </uix:case>
                            <uix:case name="NOARCHIVELOG">
                              <uix:styledText textBinding="DAILY_10_TAPE_NOAL@backupBundle@servletRequest" styleClass="OraInstructionText" />
                            </uix:case>
                          </uix:switcher>
                        </uix:header>
                        <uix:header textBinding="WEEKLY_BACKUP@backupBundle@servletRequest">
                          <uix:styledText textBinding="WEEKLY_10_TAPE@backupBundle@servletRequest" styleClass="OraInstructionText" />
                        </uix:header>
                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="both">
                      <uix:stackLayout>
                        <uix:switcher childNameBinding="alMode@defaultBean@servletRequest">
                          <uix:case name="ARCHIVELOG">
                            <uix:header textBinding="DAILY_BACKUP@backupBundle@servletRequest">
                              <uix:styledText textBinding="DAILY_10_BOTH@backupBundle@servletRequest" styleClass="OraInstructionText" />
                              <uix:spacer height="10"/>
                              <uix:rowLayout>
                                <uix:styledText textBinding="DAILY_10_TAPE_OPTIONS@backupBundle@servletRequest" styleClass="OraInstructionText" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="dailyTapeOption" value="none"
                                     textBinding="NONE@backupBundle@servletRequest"
                                     selectedValueBinding="dailyTapeOption@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="dailyTapeOption" value="archivelogs"
                                     textBinding="ARCHIVELOGS@backupBundle@servletRequest"
                                     selectedValueBinding="dailyTapeOption@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="dailyTapeOption" value="al_inc"
                                     textBinding="AL_INC@backupBundle@servletRequest"
                                     selectedValueBinding="dailyTapeOption@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="dailyTapeOption" value="al_full"
                                     textBinding="AL_FULL@backupBundle@servletRequest"
                                     selectedValueBinding="dailyTapeOption@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                            </uix:header>
                          </uix:case>
                          <uix:case name="NOARCHIVELOG">
                            <uix:header textBinding="DAILY_BACKUP@backupBundle@servletRequest">
                              <uix:styledText textBinding="DAILY_10_BOTH_NOAL@backupBundle@servletRequest" styleClass="OraInstructionText" />
                              <uix:rowLayout>
                              <uix:styledText textBinding="DAILY_10_TAPE_OPTIONS@backupBundle@servletRequest" styleClass="OraInstructionText" />
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="dailyTapeOption" value="none"
                                     textBinding="NONE@backupBundle@servletRequest"
                                     selectedValueBinding="dailyTapeOption@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="dailyTapeOption" value="inc1"
                                     textBinding="INC@backupBundle@servletRequest"
                                     selectedValueBinding="dailyTapeOption@defaultBean@servletRequest"/>
                              </uix:rowLayout>
                            </uix:header>
                          </uix:case>
                        </uix:switcher>

                        <uix:header textBinding="WEEKLY_BACKUP@backupBundle@servletRequest">
                          <uix:styledText textBinding="WEEKLY_10_BOTH@backupBundle@servletRequest" styleClass="OraInstructionText" />
                        </uix:header>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
                <uix:case name="false">
                  <uix:stackLayout>
                    <uix:rowLayout>
                      <oem:radioButton name="backupType" value="full"
                           selectedValueBinding="backupType@defaultBean@servletRequest"
                           textBinding="DAILY_PRE10@backupBundle@servletRequest" />
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <oem:radioButton name="backupType" value="inc1"
                           selectedValueBinding="backupType@defaultBean@servletRequest"
                           textBinding="WEEKLY_PRE10@backupBundle@servletRequest" />
                    </uix:rowLayout>
                  </uix:stackLayout>

                </uix:case>
              </db:switcher>

            </uix:case>
            <uix:case name="false">

              <uix:switcher childNameBinding="deviceType@defaultBean@servletRequest">
                <uix:case name="disk">
                  <uix:styledText textBinding="NOINC_DISK@backupBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:case>
                <uix:case name="tape">
                  <uix:styledText textBinding="NOINC_TAPE@backupBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:case>
                <uix:case name="both">
                  <uix:styledText textBinding="NOINC_BOTH@backupBundle@servletRequest" styleClass="OraInstructionText" />
                </uix:case>
              </uix:switcher>

            </uix:case>
          </uix:switcher>






        <uix:switcher childNameBinding="diskShown@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:header textBinding="DISK_OPTIONS@backupBundle@servletRequest">
              <uix:labeledFieldLayout labelWidth="10%" width="100%">

                <uix:switcher childNameBinding="recoveryAreaConfigured@defaultBean@servletRequest">
                  <uix:case name="true">
                        <uix:messageTextInput name="recoveryArea"
                             promptBinding="RECOVERY_AREA@backupBundle@servletRequest"
                             textBinding="recoveryArea@defaultBean@servletRequest" 
                             columns="60"
                             styleClass="OraDataText"
                             readOnly="true"/>

                  </uix:case>
                  <uix:case name="false">
                          <uix:messageTextInput name="backupLocation" 
                               promptBinding="DISK_LOCATION@backupBundle@servletRequest" 
                               id="backupLocation" 
                               textBinding="backupLocation@defaultBean@servletRequest" 
                               columns="60" />
                  </uix:case>
                </uix:switcher>
              </uix:labeledFieldLayout>

                <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.0">
                  <uix:case name="true">
                    <uix:tip>
                      <uix:styledText textBinding="REC_WINDOW_DISK_TIP@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:tip>
                  </uix:case>
                  <uix:case name="false">
                    <uix:tip>
                      <uix:styledText textBinding="MANUAL_DELETE_DISK_TIP@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:tip>
                  </uix:case>
                </db:switcher>

            </uix:header>
          </uix:case>
        </uix:switcher>

        <uix:switcher childNameBinding="tapeShown@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:header textBinding="TAPE_OPTIONS@backupBundle@servletRequest">
              <uix:labeledFieldLayout labelWidth="30%" width="100%">
                    <uix:messageTextInput name="tapeParallelism"
                         promptBinding="NUM_TAPES@backupBundle@servletRequest"
                         textBinding="tapeParallelism@defaultBean@servletRequest"
                         tipBinding="NUM_TAPES_TIP@defaultBundle@servletRequest" 
                         columns="2"
                         shortDescBinding="NUM_TAPES@backupBundle@servletRequest">
                      <uix:onBlurValidater>
                        <uix:decimal/>
                      </uix:onBlurValidater>
                    </uix:messageTextInput>

                <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.0">
                  <uix:case name="true">
                        <uix:messageTextInput name="recoveryWindow" 
                             promptBinding="REC_WINDOW@backupBundle@servletRequest"
                             textBinding="recoveryWindow@defaultBean@servletRequest" 
                             tipBinding="REC_WINDOW_TAPE_TIP@backupBundle@servletRequest" 
                             columns="2"
                             shortDescBinding="REC_WINDOW@backupBundle@servletRequest">
                      <uix:onBlurValidater>
                        <uix:decimal/>
                      </uix:onBlurValidater>
                        </uix:messageTextInput>
                  </uix:case>
                  <uix:case name="false">
                    <uix:tip>
                      <uix:styledText textBinding="MANUAL_DELETE_TAPE_TIP@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:tip>
                  </uix:case>
                </db:switcher>

                    <uix:messageTextInput name="tapeParms" 
                                          textBinding="tapeParms@defaultBean@servletRequest"  promptBinding="MMV_PARMS@backupBundle@servletRequest"
                                          tipBinding="MMV_HINT@backupBundle@servletRequest" 
                                          rows="4" columns="80" shortDescBinding="MMV_PARMS@backupBundle@servletRequest"/>

              </uix:labeledFieldLayout>

              <uix:tip>
                <uix:styledText textBinding="MOUNT_TIP@backupBundle@servletRequest" />
              </uix:tip>
            </uix:header>

          </uix:case>
        </uix:switcher>

        <!-- Encryption -->
        <uix:switcher childNameBinding="showEncryption@defaultBean@servletRequest">
          <uix:case name="true">
            <%@ include file="backupEncrypt.jspf" %>
          </uix:case>
        </uix:switcher>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel"  shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>

          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

