<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_BASIC_SCHEDULE@backupBundle@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

        <uix:header textBinding="BACKUP_TIME@backupBundle@servletRequest">
          <uix:dataScope>
            <uix:bundle name="ScheduleBundle"
                 class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
           <uix:tableLayout cellSpacing="5" summary="tl">

              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:messagePrompt promptBinding="BACKUP_START_DATE_10@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:messagePrompt promptBinding="BACKUP_START_DATE@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:case>
                  </db:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:spacer width="10"/>
                  <uix:messagePrompt labeledNodeId="startDateSB" promptBinding="BACKUP_DATE@backupBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageDateField
                    name="startDateSB"
                    id="startDateSB"
                    valueBinding="startDateSB@scheduleBean@servletRequest"
                    tipBinding="dateTip@scheduleBean@servletRequest"
                    columns="10">
                    <uix:onSubmitValidater>
                      <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
                  </uix:messageDateField>

                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <uix:messagePrompt promptBinding="BACKUP_TIME_INTRO@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                </uix:cellFormat>
              </uix:rowLayout>
<
<%--  4903703 bug fix start --%> 
               <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                 <uix:spacer width="10"/>
                  <uix:messagePrompt labeledNodeId="startTimeZoneSB" promptBinding="TIME_ZONE@ScheduleBundle" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                 <uix:choice name="startTimeZoneRegionSB" id="startTimeZoneRegionSB" renderedBinding="showMultipleTimeZones@servletRequest" shortDescBinding="TIME_ZONE@ScheduleBundle" selectedValueBinding="selectedTimeZoneSB@servletRequest" disabledBinding="readOnlyMode@servletRequest">
                  <uix:contents childDataBinding="timeZoneVector@servletRequest">
                   <uix:option textBinding="text" valueBinding="value"/>
                  </uix:contents>
                 </uix:choice>
               </uix:cellFormat>
              </uix:rowLayout>
<%--  4903703 bug fix end --%>                                      
        
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:spacer width="10"/>
                  <uix:messagePrompt promptBinding="BACKUP_TIME@backupBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <oem:choice
                      name="startHourSB"
                      shortDescBinding="BACKUP_TIME@backupBundle@servletRequest"
                      optionsBinding="hoursSB@scheduleBean@servletRequest"
                      selectedValueBinding="startHourSB@scheduleBean@servletRequest"/>
                 <oem:choice
                      name="startMinuteSB"
                      shortDescBinding="BACKUP_TIME@backupBundle@servletRequest"
                      optionsBinding="minutesSB@scheduleBean@servletRequest"
                      selectedValueBinding="startMinuteSB@scheduleBean@servletRequest"/>
                 <oem:radioButton
                      name="startAmPmSB"
                      value="AM_VALUE"
                      selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
                      textBinding="AM_LABEL@ScheduleBundle"
                      styleClass="OraInstructionText"/>
                 <oem:radioButton
                      name="startAmPmSB"
                      value="PM_VALUE"
                      selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
                      textBinding="PM_LABEL@ScheduleBundle"
                      styleClass="OraInstructionText"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:dataScope>

        </uix:header>

          <uix:switcher childNameBinding="incrementalSupported@defaultBean@servletRequest">
            <uix:case name="true">
 
              <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                <uix:case name="true">
                  <uix:switcher childNameBinding="deviceType@defaultBean@servletRequest">
                    <uix:case name="sbt">
                      <%@ include file="/database/rec/backup/weekday.jspf" %>
                    </uix:case>
                    <uix:case name="both">
                      <%@ include file="/database/rec/backup/weekday.jspf" %>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
                <uix:case name="false"> <!-- 9i databases -->
                  <uix:switcher childNameBinding="backupType@defaultBean@servletRequest">
                    <uix:case name="inc1">
                      <%@ include file="/database/rec/backup/weekday.jspf" %>
                    </uix:case>
                   </uix:switcher>
                </uix:case>
              </db:switcher>

            </uix:case>
            <uix:case name="false">

              <uix:switcher childNameBinding="deviceType@defaultBean@servletRequest">
                <uix:case name="both">
                  <%@ include file="/database/rec/backup/weekday.jspf" %>
                </uix:case>
              </uix:switcher>

            </uix:case>
          </uix:switcher>


        <uix:switcher childNameBinding="alMode@defaultBean@servletRequest">
          <uix:case name="NOARCHIVELOG">            
            <uix:header textBinding="BACKUP_MODE@backupBundle@servletRequest" size="1">
            <uix:styledText textBinding="DATABASE_NOAL_TIP@backupBundle@servletRequest" styleClass="OraInstructionText"/>
            </uix:header>
          </uix:case>
        </uix:switcher>


          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>

          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

