<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_SETTINGS@backupBundle@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

            <uix:styledText styleClass="OraInstructionText" textBinding="CONFIG_INTRO@backupBundle@servletRequest" />

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <oem:radioButton name="deviceType" value="disk"
                                   selectedValueBinding="deviceType@defaultBean@servletRequest"
                                   disabledBinding="diskDisabled@defaultBean@servletRequest"
                                   textBinding="TO_DISK@backupBundle@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" headers="">
                  <uix:messagePrompt promptBinding="DISK_LOCATION@backupBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="useRecoveryArea@defaultBean@servletRequest">
                        <uix:case name="true">
                            <uix:textInput name="diskLocation"
                               textBinding="recoveryArea@defaultBean@servletRequest"
                               columns="60"
                               readOnly="true"
                               styleClass="OraDataText" />
                        </uix:case>
                        <uix:case name="false">
                            <uix:textInput name="diskLocation"
                               textBinding="diskLocationDisplay@defaultBean@servletRequest"
                               columns="60"
                               readOnly="true"
                               styleClass="OraDataText" />
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                    <uix:case name="false">
                      <uix:textInput name="diskLocation"
                           textBinding="diskLocationDisplay@defaultBean@servletRequest"
                           columns="60"
                           readOnly="true"
                           styleClass="OraDataText" />
                    </uix:case>
                  </db:switcher>
                 </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" summary="tl">

              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <oem:radioButton name="deviceType" value="sbt"
                                   selectedValueBinding="deviceType@defaultBean@servletRequest"
                                   textBinding="TO_TAPE@backupBundle@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:switcher childNameBinding="showTapeSetting@defaultBean@servletRequest">
              <%-- Default --%>
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top" headers="">
                    <uix:messagePrompt promptBinding="MMV_PARMS@backupBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" headers="">
                    <uix:textInput name="tapeParms" 
                         textBinding="tapeParmsDisplay@defaultBean@servletRequest" 
                         readOnly="true" 
                         styleClass="OraDataText" 
                         columns="80" />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
              <%-- Oracle Backup --%>
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top" headers="">
                    <uix:styledText styleClass="OraInlineInfoText"
                           textBinding="ORACLE_BACKUP@backupBundle@servletRequest"/>                    
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
            </uix:tableLayout>

            <uix:spacer height="25"/>

            <uix:tableLayout summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="VIEW_SETTINGS@backupBundle@servletRequest" name="event" value="viewConfig" shortDescBinding="VIEW_SETTINGS@backupBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:submitButton textBinding="OVERRIDE_SETTINGS@backupBundle@servletRequest" name="event" value="overrideConfig"  shortDescBinding="OVERRIDE_SETTINGS@backupBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:styledText textBinding="OVERRIDE_TIP@backupBundle@servletRequest" styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


