<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/backup" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_DATAFILES@backupBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

            <uix:styledText textBinding="DATAFILES_INTRO@backupBundle@servletRequest" styleClass="OraInstructionText" />

            <uix:tableLayout cellSpacing="5" width="80%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:contents>
                    <uix:submitButton
                         textBinding="ADD@commonBundle@servletRequest"
                         name="event"
                         value="addDatafiles"
                         formName="foo"
						 shortDescBinding="ADD@commonBundle@servletRequest"	
                    />
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          <oem:table
            width="80%"
            blockSize="10"
            formSubmitted="true"
            name="datafilesUI"
            dataSourceProp="datafilesUI"
            beanKey="datafilesDataSourceBean"
            copyParams="target,type"
            alternateTextBinding="NO_ITEMS_SELECTED@commonBundle@servletRequest"
            summaryBinding="BACKUP_DATAFILES@backupBundle@servletRequest">
            <uix:tableSelection>
              <uix:multipleSelection 
                   shortDescBinding="SELECT@commonBundle@servletRequest"
                   selectionBinding="selection@datafilesDataSourceBean@servletRequest">
                <uix:submitButton
                     textBinding="REMOVE@commonBundle@servletRequest"
                     name="event"
                     value="removeDatafiles"
                     formName="foo"  shortDescBinding="REMOVE@commonBundle@servletRequest"/>
              </uix:multipleSelection>
            </uix:tableSelection>
          </oem:table>


          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

