<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_OPTIONS@backupBundle@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

          <uix:switcher childNameBinding="incrementalShown@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:header textBinding="BACKUP_TYPE@backupBundle@servletRequest">
                <uix:tableLayout width="100%" summary="tl">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageRadioButton name="backupType" value="full"
                                     selectedValueBinding="backupType@defaultBean@servletRequest"
                                     textBinding="FULL_OPTION@backupBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:spacer width="20"/>
                          <uix:checkBox name="inc0" 
                               textBinding="INCREMENTAL_OPTION_0@backupBundle@servletRequest"
                               checkedBinding="inc0@defaultBean@servletRequest" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageRadioButton name="backupType" value="inc1"
                           selectedValueBinding="backupType@defaultBean@servletRequest"
                           textBinding="INCREMENTAL_OPTION_1@backupBundle@servletRequest"
                           tipBinding="INCREMENTAL_OPTION_1_TIP@backupBundle@servletRequest"
                           styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:spacer width="20"/>
                          <uix:checkBox name="rollForward"
                                    textBinding="ROLL_FORWARD@backupBundle@servletRequest"
                                    disabledBinding="incrementalDisabled@defaultBean@servletRequest"
                                    checkedBinding="rollForward@defaultBean@servletRequest" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="offlineShown@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:header textBinding="BACKUP_MODE@backupBundle@servletRequest">
                <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageRadioButton name="backupMode" value="ONLINE"
                           selectedValueBinding="backupMode@defaultBean@servletRequest"
                           textBinding="ONLINE@backupBundle@servletRequest"
                           tipBinding="ONLINE_INTRO@backupBundle@servletRequest"
                           styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageRadioButton name="backupMode" value="OFFLINE"
                           selectedValueBinding="backupMode@defaultBean@servletRequest"
                           textBinding="OFFLINE@backupBundle@servletRequest"
                           tipBinding="OFFLINE_INTRO@backupBundle@servletRequest"
                           styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
            </uix:case>
          </uix:switcher>

          <uix:header textBinding="ADVANCED_HEADER@backupBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" width="100%" summary="tl">

              <uix:rowLayout renderedBinding="archivelogShown@defaultBean@servletRequest">
                <uix:cellFormat hAlign="left" headers="">
                  <uix:checkBox name="backupAL"
                       textBinding="BACKUP_ALL@backupBundle@servletRequest"
                       checkedBinding="backupAL@defaultBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="archivelogShown@defaultBean@servletRequest">
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="20"/>
                  <uix:checkBox name="deleteAL"
                       textBinding="DELETE_ALL@backupBundle@servletRequest"
                       checkedBinding="deleteAL@defaultBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout renderedBinding="deleteObsoleteShown@defaultBean@servletRequest">
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageCheckBox name="deleteObsolete"
                                textBinding="DELETE_OBSOLETE@backupBundle@servletRequest"
                                tipBinding="DELETE_OBSOLETE_TIP@backupBundle@servletRequest"
                                checkedBinding="deleteObsolete@defaultBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="proxyShown@defaultBean@servletRequest">
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageCheckBox name="useProxyCopy"
                                textBinding="PROXY_YES@backupBundle@servletRequest"
                                tipBinding="PROXY_ONLY_NO@backupBundle@servletRequest"
                                checkedBinding="useProxyCopy@defaultBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="filesPerSetShown@defaultBean@servletRequest">
                <uix:cellFormat hAlign="left" headers="">
                  <%--
                  <uix:messageTextInput name="filesPerSet"
                       promptBinding="FILES_PER_SET@backupBundle@servletRequest"
                       tipBinding="FILES_PER_SET_TIP@backupBundle@servletRequest"
                       textBinding="filesPerSet@defaultBean@servletRequest"
                       columns="1">
                  </uix:messageTextInput>
                   --%>
                   <uix:messageTextInput name="filesPerSet"
                       promptBinding="FILES_PER_SET@backupBundle@servletRequest"
                       textBinding="filesPerSet@defaultBean@servletRequest"
                       columns="1">
                  </uix:messageTextInput>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout renderedBinding="maxCorruptShown@defaultBean@servletRequest">
                <uix:cellFormat hAlign="left" headers="">
                  
                  <uix:messageTextInput name="maxCorrupt"
                       promptBinding="MAX_CORRUPT@backupBundle@servletRequest"
                       tipBinding="MAX_CORRUPT_TIP@backupBundle@servletRequest"
                       textBinding="maxCorrupt@defaultBean@servletRequest"
                       columns="1">
                  </uix:messageTextInput>
                </uix:cellFormat>
              </uix:rowLayout>
	     <uix:rowLayout renderedBinding="isShowSectionSize@defaultBean@servletRequest" >
	     <uix:cellFormat hAlign="left" headers="">
             <%-- <uix:labeledFieldLayout width="30%"> 
              <uix:contents>--%>
              <uix:rowLayout>
	      
		<uix:messageTextInput name="sectionSize" promptBinding="SECTION_SIZE@backupBundle@servletRequest" 
		   shortDescBinding="SECTION_SIZE@backupBundle@servletRequest" disabledBinding="isDisableSectionSize@defaultBean@servletRequest"
		   textBinding="sectionSize@defaultBean@servletRequest" columns="10"/>
                <uix:choice name="sectionSizeUnit" 
                     id="sectionSizeUnit"
                     disabledBinding="isDisableSectionSize@defaultBean@servletRequest" 
                     selectedValueBinding="sectionSizeUnit@defaultBean@servletRequest">
                      <uix:option textBinding="KBYTES@backupBundle@servletRequest" value="K"/>
		      <uix:option textBinding="MBYTES@backupBundle@servletRequest" value="M"/>
		      <uix:option textBinding="GBYTES@backupBundle@servletRequest" value="G"/>
                </uix:choice>
              <%-- </uix:contents> --%>
	      </uix:rowLayout>
             <uix:styledText styleClass="OraInlineInfoText" text=""/>
             <uix:styledText labeledNodeId="sectionSizeUnit" styleClass="OraInlineInfoText" textBinding="SECTION_SIZE_TIP@backupBundle@servletRequest" />
              <%-- </uix:contents>
            </uix:labeledFieldLayout> --%>
	    </uix:cellFormat>
	  </uix:rowLayout>  
	   <!-- Encryption -->
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <%@ include file="backupEncrypt.jspf" %>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>
          </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

