<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="RMAN_SCRIPT@backupBundle@servletRequest"/> 
      <uix:styleSheet/>
    </uix:metaContainer> 

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/backup" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_REVIEW_RMAN_SCRIPT@backupBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:location>
          <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
            <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
        </uix:location>

            <uix:styledText labeledNodeId="rmanScriptCopy" textBinding="SHOW_SCRIPT_INTRO@commonBundle@servletRequest" styleClass="OraInstructionText"/>

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rmanScriptCopy" id="rmanScriptCopy" textBinding="rmanScriptCopy@defaultBean@servletRequest" columns="120" rows="15"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" name="event" value="revertScript"  shortDescBinding="CANCEL@commonBundle@servletRequest"/>
              <uix:submitButton textBinding="SUBMIT_JOB@commonBundle@servletRequest" name="event" value="submitJob"  shortDescBinding="SUBMIT_JOB@commonBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

