<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="event"/>
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="BACKUP_STRATEGY@backupBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

<uix:messages>
          <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

					  
      <uix:tableLayout summary="tl">
       <uix:contents>
           <uix:spacer height="20"/>
           <uix:styledText textBinding="STRATEGY_INTRO@backupBundle@servletRequest" styleClass="OraInstructionText"/>
       <uix:rowLayout>
        <uix:contents>

         <uix:cellFormat vAlign="center" width="60%" headers="">
          <uix:contents>


            <uix:stackLayout>
              <uix:contents>

                <uix:header textBinding="SUGGESTED@backupBundle@servletRequest">
                    <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:styledText styleClass="OraInstructionText" textBinding="SUGGESTED_INTRO@backupBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right" headers="">
                          <uix:submitButton textBinding="SCHEDULE_SUGGESTED@backupBundle@servletRequest" formName="foo" name="event" value="scheduleSuggested" shortDescBinding="SCHEDULE_SUGGESTED@backupBundle@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:styledText styleClass="OraInstructionText" textBinding="SUGGESTED_CONTENT@backupBundle@servletRequest" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                </uix:header>
                <uix:header textBinding="CUSTOMIZE@backupBundle@servletRequest">
                    <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:styledText textBinding="OBJECT_INTRO_AL@backupBundle@servletRequest" styleClass="OraInstructionText"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right" headers="">
                          <uix:submitButton textBinding="SCHEDULE_CUSTOMIZE@backupBundle@servletRequest" formName="foo" name="event" value="scheduleCustomized" shortDescBinding="SCHEDULE_CUSTOMIZE@backupBundle@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" rowSpan="5" headers="">
                          <uix:spacer width="10"/>
                          <uix:stackLayout>
                              <uix:contents childDataBinding="allObjectTypes@defaultBean@servletRequest">
                                <uix:messageRadioButton name="objectType"
                                     textBinding="text"
                                     valueBinding="value"
                                     tipBinding="tip"
                                     selectedValueBinding="objectType@defaultBean@servletRequest"/>
                              </uix:contents>
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:header>
              </uix:contents>
            </uix:stackLayout>

            </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat vAlign="bottom"  headers="" >
          <uix:contents>
         <uix:contentContainer textBinding="STRATEGY_OVERVIEW@backupBundle@servletRequest" width="100%" icon="/em/images/infoicon_active.gif">
            <uix:contents>
             <uix:stackLayout>
              <uix:contents>
               <uix:styledText styleClass="OraInstructionText"
                    textBinding="STRATEGY_OVERVIEW_OSS@backupBundle@servletRequest"/>
                <uix:bulletedList>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_OSS_B1@backupBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_OSS_B2@backupBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_OSS_B4@backupBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_OSS_B3@backupBundle@servletRequest"/>    
                 </uix:bulletedList>

               <uix:styledText styleClass="OraInstructionText"
                    textBinding="STRATEGY_OVERVIEW_CUS@backupBundle@servletRequest"/>
                <uix:bulletedList>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_CUS_B1@backupBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_CUS_B2@backupBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_CUS_B3@backupBundle@servletRequest"/>
                 <uix:styledText styleClass="OraInstructionText"
                      textBinding="STRATEGY_OVERVIEW_CUS_B4@backupBundle@servletRequest"/>
                 </uix:bulletedList>
                </uix:contents>
               </uix:stackLayout>
              </uix:contents>
         </uix:contentContainer> 
            </uix:contents>
         </uix:cellFormat>

          </uix:contents>
         </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>

          <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest">
            <uix:styledText styleClass="OraInstructionText" textBinding="OS_CREDENTIALS_BACKUP@commonBundle@servletRequest" />
                <uix:contents>
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
          </uix:header>

      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

