<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="bkpMgmtBundle"
            class="oracle.sysman.db.rsc.rec.BkpMgmtMsg"/>

<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  
  <uix:body>      
      <db:form name="foo" method="POST" destination="/console/database/rec/bkpMgmt" copyParams="target,type,objType,ignoreRelogin">
      <uix:formValue name="pageName" value="/database/rec/bkpmgt/backupDet.jsp"/> 

     <uix:switcher childNameBinding="showPage@servletRequest">
      <uix:case name="false">
      <uix:pageLayout>
         <%@ include file="/database/global.jspf" %>
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:pageLayout>   
      </uix:case>
      
      <uix:default>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>    
        
      <uix:contentFooter>
            <uix:pageButtonBar>
          <uix:contents>
              <uix:button textBinding="OK@bkpMgmtBundle"
                           destinationBinding="returnUrl@defaultBean@servletRequest" shortDescBinding="OK@bkpMgmtBundle" />
            </uix:contents>
           </uix:pageButtonBar>
      </uix:contentFooter>

        <uix:header textBinding="pageTitle@servletRequest">

        <uix:switcher childNameBinding="useRCView@defaultBean@servletRequest">
        <uix:case name="false">
              <uix:styledText styleClass="OraPromptText" textBinding="JOB_DET_PAGE_DESC_CF@bkpMgmtBundle"/> 
        </uix:case> 
        <uix:case name="true">
              <uix:styledText styleClass="OraPromptText" textBinding="JOB_DET_PAGE_DESC_RC@bkpMgmtBundle"/>
          </uix:case> 
        </uix:switcher>
        
        <uix:header textBinding="GENERAL@bkpMgmtBundle">
            <uix:tableLayout width="80%" cellSpacing="5" summary="tl">
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="STATUS@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="status@defaultBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="DEVICES@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:link styleClass="OraDataText" textBinding="devices@defaultBean@servletRequest" destinationBinding="devicesLink@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="TYPE@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="type@defaultBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="INPUT_SIZE@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="inputSize@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>     
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="START_TIME@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="startTime@defaultBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="OUTPUT_SIZE@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="outputSize@defaultBean@servletRequest"/>
                    </uix:cellFormat>

                </uix:rowLayout>     
                
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="TIME_TAKEN@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="timeTaken@defaultBean@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="OUTPUT_RATE@bkpMgmtBundle"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:styledText styleClass="OraDataText" textBinding="outputRate@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>     
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left" columnSpan="4" headers="">
                    <uix:tip textBinding="OUTPUT_DEVICES_TIP@bkpMgmtBundle"/>
                    <uix:tip textBinding="OUTPUT_LOG_TIP@bkpMgmtBundle"/>
                  </uix:cellFormat>
                </uix:rowLayout>

            </uix:tableLayout>
          </uix:header>
          
          <uix:header textBinding="OUTPUT_LOG@bkpMgmtBundle">      
             <uix:textInput name="output"
               textBinding="output@defaultBean@servletRequest"
               shortDescBinding="OUTPUT_LOG@bkpMgmtBundle"
               readOnly="true" columns="120" rows="15"/>
        </uix:header>
      </uix:header>

     </uix:pageLayout>       
     </uix:default>
     </uix:switcher>
     
   </db:form>
  </uix:body> 
</uix:document> 

</uix:renderingContext>	     	     


