<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="bkpMgmtBundle" class="oracle.sysman.db.rsc.rec.BkpMgmtMsg"/>

<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  
  <uix:body>      
      <db:form name="foo" method="POST" destination="/console/database/rec/bkpMgmt" copyParams="type,target,objType,ignoreRelogin">
      <uix:formValue name="pageName" value="/database/rec/bkpmgt/backupJobs.jsp"/> 
        
     <uix:switcher childNameBinding="showPage@servletRequest">
      <uix:case name="false">
      <uix:pageLayout>
         <%@ include file="/database/global.jspf" %>
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:pageLayout>   
      </uix:case>
      
      <uix:default>
      <uix:pageLayout titleBinding="pageTitle@servletRequest">
        <%@ include file="/database/global.jspf" %>    
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
                        
            <uix:tableLayout summary="tl">
                <uix:switcher childNameBinding="useRCView@defaultBean@servletRequest">
                <uix:case name="false">
                <uix:rowLayout>
                    <uix:cellFormat columnSpan="2" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="JOB_PAGE_DESC_CF@bkpMgmtBundle"/> 
                    </uix:cellFormat>
                </uix:rowLayout>     
               </uix:case> 
                <uix:case name="true">
                <uix:rowLayout>
                    <uix:cellFormat columnSpan="2" headers="">
                      <uix:styledText styleClass="OraPromptText" textBinding="JOB_PAGE_DESC_RC@bkpMgmtBundle"/>
                      <uix:link textBinding="VIEW_BKPMGMT@bkpMgmtBundle" destinationBinding="bkpMgmtUrl@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>     
               </uix:case> 
               </uix:switcher>
             </uix:tableLayout>
              
              
              <uix:spacer height="5"/>
              
              <uix:header textBinding="SEARCH@bkpMgmtBundle">
                    <uix:tableLayout cellSpacing="5" summary="tl">
                        <uix:rowLayout>
                        <uix:switcher childNameBinding="dbSwitchEnabled@servletRequest">
                        <uix:case name="true">
                        <uix:flowLayout>
                            <uix:cellFormat headers="">
                                <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_DATABASE@bkpMgmtBundle"/>
                             </uix:cellFormat>
                             
                              <uix:cellFormat headers="">
                              <uix:choice name="newTarget" 
                                    shortDescBinding="CURRENT_DATABASE@bkpMgmtBundle"
                                    selectedValueBinding="currentDatabaseNType@defaultBean@servletRequest"
                                    >
                                    <uix:contents
                                         childDataBinding="availableDBs@servletRequest">
                                        <uix:option textBinding="text" valueBinding="value"/>
                                    </uix:contents>
                              </uix:choice>
                              
                             </uix:cellFormat>
                             </uix:flowLayout>
                         </uix:case>
                         </uix:switcher>    
                        
                            <uix:cellFormat headers="">
                                <uix:styledText styleClass="OraPromptText" textBinding="STATUS@bkpMgmtBundle"/>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                              <uix:choice name="filterStatus" 
                                    selectedValueBinding="filterStatus@defaultBean@servletRequest"
                                    shortDescBinding="STATUS@bkpMgmtBundle"
                                    >
                                    <uix:option textBinding="OPT_ALL@bkpMgmtBundle" value="all"/>
                                    <uix:option textBinding="COMPLETED_N@bkpMgmtBundle" value="COMPLETED"/>
                                    <uix:option textBinding="COMPLETED_WITH_ERRORS@bkpMgmtBundle" value="COMPLETED WITH ERRORS"/>
                                    <uix:option textBinding="COMPLETED_WITH_WARNINGS@bkpMgmtBundle" value="COMPLETED WITH WARNINGS"/>
                                    <uix:option textBinding="FAILED@bkpMgmtBundle" value="FAILED"/>
                                    <uix:option textBinding="RUNNING@bkpMgmtBundle" value="RUNNING"/>
                                    <uix:option textBinding="RUNNING_WITH_ERRORS@bkpMgmtBundle" value="RUNNING WITH ERRORS"/>
                                    <uix:option textBinding="RUNNING_WITH_WARNINGS@bkpMgmtBundle" value="RUNNING WITH WARNINGS"/>
                              </uix:choice>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                                <uix:styledText styleClass="OraPromptText" textBinding="START_TIME@bkpMgmtBundle"/>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                              <uix:choice name="filterStartTime" 
                                    selectedValueBinding="filterStartTime@defaultBean@servletRequest"
                                    shortDescBinding="START_TIME@bkpMgmtBundle"
                                    >
                                    <uix:option textBinding="OPT_ALL@bkpMgmtBundle" value="all"/>
                                    <uix:option textBinding="OPT_8_HR@bkpMgmtBundle" value="eightHours"/>
                                    <uix:option textBinding="OPT_1_DAY@bkpMgmtBundle" value="oneDay"/>
                                    <uix:option textBinding="OPT_2_DAY@bkpMgmtBundle" value="twoDays"/>
                                    <uix:option textBinding="OPT_1_WK@bkpMgmtBundle" value="oneWeek"/>
                                    <uix:option textBinding="OPT_1_MON@bkpMgmtBundle" value="oneMonth"/>
                              </uix:choice>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                                <uix:styledText styleClass="OraPromptText" textBinding="TYPE@bkpMgmtBundle"/>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                              <uix:choice name="filterType" 
                                    selectedValueBinding="filterType@defaultBean@servletRequest"
                                    shortDescBinding="TYPE@bkpMgmtBundle"
                                    >
                                    <uix:option textBinding="OPT_ALL@bkpMgmtBundle" value="all"/>
                                    <uix:option textBinding="ARCHIVE_LOG@bkpMgmtBundle" value="ARCHIVELOG"/>
                                    <uix:option textBinding="CONTROL_FILE@bkpMgmtBundle" value="CONTROLFILE"/>
                                    <uix:option textBinding="DATAFILE_FULL@bkpMgmtBundle" value="DATAFILE FULL"/>
                                    <uix:option textBinding="DATAFILE_INCR@bkpMgmtBundle" value="DATAFILE INCR"/>
                                    <uix:option textBinding="DB_FULL@bkpMgmtBundle" value="DB FULL"/>
                                    <uix:option textBinding="DB_INCR@bkpMgmtBundle" value="DB INCR"/>
                                    <uix:option textBinding="RECVR_AREA@bkpMgmtBundle" value="RECVR AREA"/>
                                    <uix:option textBinding="SPFILE@bkpMgmtBundle" value="SPFILE"/>
                              </uix:choice>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                                <uix:submitButton textBinding="GO@bkpMgmtBundle" name="event" value="searchJob" shortDescBinding="GO@bkpMgmtBundle"/>
                            </uix:cellFormat>

                        </uix:rowLayout>
                     </uix:tableLayout>
              </uix:header>
              
              <uix:header textBinding="RESULT@bkpMgmtBundle">
              <uix:stackLayout>

              <uix:tableLayout renderedBinding="hasTotal@defaultBean@servletRequest" summary="tl">
              <uix:rowLayout hAlign="left">
              <uix:cellFormat renderedBinding="hasTotal@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_N@bkpMgmtBundle"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraDataText" textBinding="totalC@defaultBean@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraDataText" text="("/>
                    <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasComp@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_N@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/okind_status.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="compC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasCompE@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_WITH_ERRORS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="compEC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasCompW@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_WITH_WARNINGS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/warning.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="compWC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasRun@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="RUNNING@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/okind_status.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="runC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasRunE@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="RUNNING_WITH_ERRORS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="runEC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasRunW@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="RUNNING_WITH_WARNINGS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/warning.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="runWC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasFail@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="FAILED@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="failC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasUnknown@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="UNKNOWN@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="unknownC@defaultBean@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat headers="">
                <uix:styledText styleClass="OraDataText" text=" )"/>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>

              <oem:table name="jobDataSource" 
                    summaryBinding="RESULT@bkpMgmtBundle"
                    width="100%" blockSize="25"
                    dataSourceBinding="jobDataSource@defaultBean@servletRequest"
                    alternateTextBinding="NO_JOB_FOUND@bkpMgmtBundle"
                    formSubmitted="true"/>
              </uix:stackLayout>
              </uix:header>    
                                                                                            
              <uix:spacer height="5"/>
            <uix:tableLayout summary="tl">
              <uix:rowLayout>
              <uix:spacer width="20"/>
              <uix:tip textBinding="OUTPUT_DEVICES_TIP@bkpMgmtBundle"/>
              </uix:rowLayout>
            </uix:tableLayout>
                                                                                            
          <uix:header textBinding="RELATED_LINKS@bkpMgmtBundle">
            <uix:tableLayout width="80%" cellSpacing="2" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat vAlign="left" headers="">
                  <db:link textBinding="MANAGE_BACKUP_JOBS@bkpMgmtBundle"
                       destination="/console/database/rec/mnt?event=start" copyParams="target,type"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

     </uix:pageLayout>
     </uix:default>
     </uix:switcher>
    </db:form> 
  </uix:body> 
</uix:document> 

</uix:renderingContext>
