<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<db:script src="/database/LOV.js"/>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="bkpMgmtBundle" class="oracle.sysman.db.rsc.rec.BkpMgmtMsg"/>
<uix:document>   
  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %> 
  
  <uix:body>      
    <db:form name="foo" method="POST" destination="/console/database/rec/bkpMgmt" copyParams="target,type,objType,ignoreRelogin">
    <uix:formValue name="pageName" value="/database/rec/bkpmgt/backupRep.jsp"/> 

     <uix:switcher childNameBinding="showPage@servletRequest">
      <uix:case name="false">
      <uix:pageLayout>
         <%@ include file="/database/global.jspf" %>
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:pageLayout>   
      </uix:case>
      
      <uix:default>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>    
        
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:header textBinding="pageTitle@servletRequest">  
        
        <uix:switcher childNameBinding="useRCView@defaultBean@servletRequest">
        <uix:case name="false">
        <uix:rowLayout>  
            <uix:cellFormat headers="">
              <uix:styledText styleClass="OraPromptText" textBinding="JOB_REP_PAGE_DESC_CF@bkpMgmtBundle"/> 
            </uix:cellFormat>
        </uix:rowLayout>     
        </uix:case> 
        <uix:case name="true">
            <uix:rowLayout>  
            <uix:cellFormat headers="">
              <uix:styledText styleClass="OraPromptText" textBinding="JOB_REP_PAGE_DESC_RC@bkpMgmtBundle"/>
            </uix:cellFormat>
            </uix:rowLayout>  
          </uix:case> 
        </uix:switcher>
        
          <uix:header textBinding="SEARCH@bkpMgmtBundle">
          <uix:stackLayout>
            <uix:switcher childNameBinding="dbSwitchEnabled@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraPromptText" textBinding="REP_SEARCH_TIP@bkpMgmtBundle"/>
              </uix:case>
             </uix:switcher>
           <uix:spacer height="10"/>
                    <uix:tableLayout cellSpacing="5" summary="tl">
                    <uix:rowLayout>
                       <uix:cellFormat headers="">
                        <uix:switcher childNameBinding="dbSwitchEnabled@servletRequest">
                        <uix:case name="true">
                              <uix:rowLayout>
                              <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_DATABASE@bkpMgmtBundle"/>
                                <uix:spacer width="3"/>
                                <uix:choice name="newTarget" 
                                   selectedValueBinding="currentDatabaseNType@defaultBean@servletRequest" 
                                   onChange="submitForm('foo', true, {'event':'redisplay'})">
                                    <uix:contents childDataBinding="availableDBs@servletRequest">
                                        <uix:option textBinding="text" valueBinding="value"/>
                                    </uix:contents>
                              </uix:choice>
                             </uix:rowLayout>
                         </uix:case>
                         </uix:switcher>  
                       </uix:cellFormat>  
                      </uix:rowLayout>
                        
                        <uix:rowLayout>
                            <uix:cellFormat headers="">
                            <uix:header textBinding="BY_JOB@bkpMgmtBundle">
                            <uix:rowLayout>
                            <uix:cellFormat headers="">
                               <uix:styledText styleClass="OraPromptText" textBinding="BACKUP_JOB@bkpMgmtBundle" labeledNodeId="backupJobId"/>
                               <uix:spacer width="3"/>
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                              <uix:switcher childNameBinding="useRCView@defaultBean@servletRequest">
                                <uix:case name="true">
                                  <uix:messageLovField name="backupJobDesc"
                                       textBinding="backupJobDesc@defaultBean@servletRequest"
                                       searchDescBinding="BACKUP_JOB@bkpMgmtBundle"
                                       onClick="startLov('backupJobDesc', 'ListBackupRC')" id="backupJobId"/>
                                </uix:case>
                                <uix:case name="false">
                                  <uix:messageLovField name="backupJobDesc"
                                       textBinding="backupJobDesc@defaultBean@servletRequest"
                                       searchDescBinding="BACKUP_JOB@bkpMgmtBundle"
                                       onClick="startLov('backupJobDesc', 'ListBackup')" id="backupJobId"/>
                                </uix:case>
                              </uix:switcher>  
                            </uix:cellFormat>

                            <uix:cellFormat headers="">
                                <uix:spacer width="3"/>
                                <uix:submitButton textBinding="GO@bkpMgmtBundle" name="event" value="reportByJob" shortDescBinding="GO@bkpMgmtBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          </uix:header>
                          </uix:cellFormat>

                          <uix:cellFormat columnSpan="3" headers="">
                          <uix:header textBinding="BY_DATE@bkpMgmtBundle">
                          <uix:stackLayout>
                          <uix:rowLayout>

                
                            <uix:cellFormat headers="">
                                <uix:styledText styleClass="OraPromptText" textBinding="START_DATE@bkpMgmtBundle"/>
                                <uix:spacer width="3"/>    
                            </uix:cellFormat>

                            <uix:messageDateField name="filterStartDate" 
                                    shortDescBinding="START_DATE@bkpMgmtBundle"
                                    columns="10" 
                                    valueBinding="filterStartDate@defaultBean@servletRequest" 
                            >
                                <uix:onSubmitValidater>
                                  <uix:date dateStyle="medium"/>
                                </uix:onSubmitValidater>
                           </uix:messageDateField>
                            
                            <uix:cellFormat headers="">
                                <uix:spacer width="10"/>
                            </uix:cellFormat>
                            
                            <uix:cellFormat headers="">
                                <uix:styledText styleClass="OraPromptText" textBinding="END_DATE@bkpMgmtBundle"/>
                                <uix:spacer width="3"/>
                            </uix:cellFormat>

                            <uix:messageDateField name="filterEndDate" 
                                    shortDescBinding="END_DATE@bkpMgmtBundle"
                                    columns="10" 
                                    valueBinding="filterEndDate@defaultBean@servletRequest" 
                            >
                                <uix:onSubmitValidater>
                                  <uix:date dateStyle="medium"/>
                                </uix:onSubmitValidater>
                           </uix:messageDateField>

                            <uix:cellFormat headers="">
                                <uix:spacer width="10"/>
                                <uix:submitButton textBinding="GO@bkpMgmtBundle" name="event" value="reportByTime" shortDescBinding="GO@bkpMgmtBundle"/>
                            </uix:cellFormat>

                        </uix:rowLayout>
                        </uix:stackLayout>

                        </uix:header>
                        </uix:cellFormat>
                        </uix:rowLayout>
                                                  
                     </uix:tableLayout>
            </uix:stackLayout>         
          </uix:header>    
          
          <uix:header textBinding="RESULT@bkpMgmtBundle" renderedBinding="filterSet@defaultBean@servletRequest">
          <uix:switcher childNameBinding="hasResultData@defaultBean@servletRequest">
          <uix:case name="true">
          <uix:stackLayout>
          <uix:include node="inputSummary.jsp" />
          </uix:stackLayout>
          </uix:case>
          <uix:case name="false">
          <uix:stackLayout>
            <uix:styledText styleClass="OraPromptText" 
                textBinding="NO_DATA_FOUND_JOB@bkpMgmtBundle" 
                renderedBinding="filterByJob@defaultBean@servletRequest"/>
            <uix:styledText styleClass="OraPromptText" 
                textBinding="NO_DATA_FOUND_TIME@bkpMgmtBundle" 
                renderedBinding="filterByTime@defaultBean@servletRequest"/>
          </uix:stackLayout>  
          </uix:case>
          </uix:switcher>

          </uix:header>

            <uix:spacer height="5"/>
                                                                                            
          <uix:header textBinding="RELATED_LINKS@bkpMgmtBundle">
            <uix:tableLayout width="80%" cellSpacing="2" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat vAlign="left" headers="">
                  <db:link textBinding="MANAGE_BACKUP_JOBS@bkpMgmtBundle"
                       destination="/console/database/rec/mnt?event=start" copyParams="target,type"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

        </uix:header>
      </uix:pageLayout>       
      </uix:default>
      </uix:switcher>
    </db:form> 
  </uix:body> 
</uix:document> 

</uix:renderingContext>	     	     

