<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
request.setAttribute("dbMsgBundle", new BundleDataObject(NLSUtil.getBundle(DBMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="functionHeader@defaultBean@servletRequest">

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:stackLayout>
            <uix:rowLayout hAlign="right">
            </uix:rowLayout>
          </uix:stackLayout>

          <uix:tableLayout cellSpacing="5" width="75%" summary="tl">

            <%-- Intro --%>
            <uix:rowLayout>
              <uix:cellFormat columnSpan="2" headers="">
                <uix:styledText textBinding="functionIntro@defaultBean@servletRequest" styleClass="OraInstructionText" />
              </uix:cellFormat>
            </uix:rowLayout>

            <%-- List of recovery catalogs--%>
            <uix:rowLayout>
              <uix:labeledFieldLayout labelWidth="30%" >
                <uix:contents>
                  <uix:messagePrompt 
                  promptBinding="RECOVERY_CATALOG_LABEL@catalogBundle@servletRequest" />
                  <oem:choice name="selectedRecoveryCatalog"
                     shortDescBinding="RECOVERY_CATALOG_LABEL@catalogBundle@servletRequest"
                     optionsBinding="configuredRecoveryCatalogs@defaultBean@servletRequest"
                     selectedValueBinding="selectedRecoveryCatalog@defaultBean@servletRequest">
                  </oem:choice>
              </uix:contents>
              </uix:labeledFieldLayout>
            </uix:rowLayout>

          <uix:contents>
            <%@ include file="/database/rec/catalog/catalogCreds.jspf"%>
          </uix:contents>

          <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest" size="1">
                <uix:contents>
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
          </uix:header>

          </uix:tableLayout>

          <%--  Related Links --%>
          <uix:tableLayout width="100%" summary="tl">
           <uix:contents>
  
              <uix:cellFormat vAlign="top" width="50%" headers="">
               <uix:contents>             
                <uix:header textBinding="RELATED_LINKS@dbMsgBundle@servletRequest">
                <uix:stackLayout>
                 <uix:contents>
                 <uix:styledText textBinding="CATALOG_LIST@catalogBundle@servletRequest" destinationBinding="recoveryCatalogsLink@servletRequest" />
                 </uix:contents>
                </uix:stackLayout>
               </uix:header>
              </uix:contents>
             </uix:cellFormat>
  
           </uix:contents>
          </uix:tableLayout>

        </uix:header>

        <uix:contentFooter> 
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" name="event" value="cancelFunction"  shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:submitButton textBinding="OK@commonBundle@servletRequest" name="event" value="okFunction"  shortDescBinding="OK@commonBundle@servletRequest"/>
              </uix:pageButtonBar>
        </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

