<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="RECOVERY_CATALOG@catalogBundle@servletRequest">

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:stackLayout>
            <uix:rowLayout hAlign="right">
            </uix:rowLayout>
          </uix:stackLayout>

          <uix:tableLayout cellSpacing="5" width="80%" summary="tl">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" headers="">
                <uix:messagePrompt promptBinding="RC_USERNAME@commonBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" headers="">
                <uix:switcher childNameBinding="useRC@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="rcUsername@defaultBean@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="NOT_SPECIFIED@commonBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right" headers="">
                <uix:messagePrompt promptBinding="RC_DB@commonBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" headers="">
                <uix:switcher childNameBinding="useRC@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="rcDatabase@defaultBean@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="NOT_SPECIFIED@commonBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest" size="1">
                <uix:contents>
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
          </uix:header>

          </uix:header>

        <uix:pageButtons>
          <uix:switcher childNameBinding="targetRegistered@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="CLEAR_SETTINGS@catalogBundle@servletRequest" name="event" value="clearSettings"  shortDescBinding="CLEAR_SETTINGS@catalogBundle@servletRequest"/>
                <uix:submitButton formName="foo" textBinding="EDIT_RC@commonBundle@servletRequest" name="event" value="editRC"  shortDescBinding="EDIT_RC@commonBundle@servletRequest"/>
                <uix:submitButton formName="foo" textBinding="REGISTER@catalogBundle@servletRequest" name="event" value="registerDatabase" shortDescBinding="REGISTER@catalogBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:case>
            <uix:case name="true">
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="CLEAR_SETTINGS@catalogBundle@servletRequest" name="event" value="clearSettings"  shortDescBinding="CLEAR_SETTINGS@catalogBundle@servletRequest"/>
                <uix:submitButton formName="foo" textBinding="UNREGISTER@catalogBundle@servletRequest" name="event" value="unregisterDatabase" shortDescBinding="UNREGISTER@catalogBundle@servletRequest"/>
                <uix:submitButton formName="foo" textBinding="RESYNC@catalogBundle@servletRequest" name="event" value="resyncDatabase" shortDescBinding="RESYNC@catalogBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:case>
          </uix:switcher>

        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

