<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.resources.eml.creds.PrefCredsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
request.setAttribute("credsMsgBundle", new BundleDataObject(NLSUtil.getBundle(PrefCredsMsg.class.getName(), request)));
%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" 
        copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

        <uix:header textBinding="credentialsTitle@defaultBean@servletRequest">

        <uix:tableLayout cellSpacing="5" width="75%" summary="tl">

          <%-- Intro --%>
          <uix:rowLayout>
            <uix:cellFormat headers="">
              <uix:styledText textBinding="ADD_CREDS_INTRO@catalogBundle@servletRequest" 
                styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- Host credentials --%>
          <uix:rowLayout>
            <uix:cellFormat headers="">
              <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest">
                <uix:styledText styleClass="OraInstructionText" 
                    textBinding="ADD_CREDS_HOST_INTRO@catalogBundle@servletRequest" />
                <uix:stackLayout>                   
                <uix:contents>
                 <uix:labeledFieldLayout labelWidth="25%">
                  <uix:contents>
                   <uix:messageTextInput name="hostUserName" 
                                         promptBinding="USERNAME@credsMsgBundle@servletRequest"
                                         textBinding="hostUserName@defaultBean@servletRequest" 
                                         messageBinding="hostUserNameError@defaultBean@servletRequest" 
                                         messageTypeBinding="hostUserNameErrorType@defaultBean@servletRequest" 
                                         columns="40"
                                         required="uiOnly"
                                         noAutoComplete="true"/>
                
                   <uix:messageTextInput name="hostSecretPassword" 
                                         promptBinding="PASSWORD@credsMsgBundle@servletRequest" 
                                         textBinding="hostSecretPassword@defaultBean@servletRequest" 
                                         messageBinding="hostPasswordError@defaultBean@servletRequest" 
                                         messageTypeBinding="hostPasswordErrorType@defaultBean@servletRequest" 
                                         secret="true"           
                                         columns="40"
                                         required="uiOnly"
                                         noAutoComplete="true"/>
                
                  </uix:contents>
                 </uix:labeledFieldLayout>
                
                </uix:contents>
                </uix:stackLayout>                   
              </uix:header>
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- Database credentials --%>
          <uix:rowLayout>
            <uix:cellFormat headers="">
              <uix:header textBinding="DB_CREDENTIALS@commonBundle@servletRequest">
                <uix:styledText styleClass="OraInstructionText" 
                    textBinding="ADD_CREDS_DB_INTRO@catalogBundle@servletRequest" />
                    <uix:contents>
                   <uix:labeledFieldLayout labelWidth="25%">
                    <uix:contents>
                     <uix:messageTextInput name="targetUserName" 
                                           promptBinding="USERNAME@credsMsgBundle@servletRequest"
                                           textBinding="targetUserName@defaultBean@servletRequest" 
                                           disabledBinding="targetUserNameDisabled@defaultBean@servletRequest"
                                           messageBinding="targetUserNameError@defaultBean@servletRequest" 
                                           messageTypeBinding="targetUserNameErrorType@defaultBean@servletRequest" 
                                           columns="40"
                                           required="uiOnly"
                                           noAutoComplete="true"/>
                  
                     <uix:messageTextInput name="targetSecretPassword" 
                                           promptBinding="PASSWORD@credsMsgBundle@servletRequest" 
                                           textBinding="targetSecretPassword@defaultBean@servletRequest" 
                                           messageBinding="targetPasswordError@defaultBean@servletRequest" 
                                           messageTypeBinding="targetPasswordErrorType@defaultBean@servletRequest" 
                                           secret="true"           
                                           columns="40"
                                           required="uiOnly"
                                           noAutoComplete="true"/>
                  
                     <uix:messagePrompt promptBinding="DB_TARGET@credsMsgBundle@servletRequest" />
                  
                     <uix:styledText styleClass="OraDataText"
                                     textBinding="credTarget@defaultBean@servletRequest" />
                  
                     <uix:messagePrompt required="uiOnly" labeledNodeId="targetRole"
                                        promptBinding="ROLE@credsMsgBundle@servletRequest" />
                  
                     <uix:choice name="targetRole" id="targetRole"
                          selectedValueBinding="targetRole@defaultBean@servletRequest">
                      <uix:option text="Normal" value="normal"/>
                      <uix:option text="SYSOPER" value="sysoper"/>
                      <uix:option text="SYSDBA" value="sysdba"/>
                     </uix:choice>
                    </uix:contents>
                   </uix:labeledFieldLayout>
                    </uix:contents>
              </uix:header>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>        

        </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="addCancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

