<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if(destField == "selectedDatabase")
  {
    if ((i=data.indexOf('"."')) > 0)
    {
      if ((j=data.lastIndexOf('"')) > 0)
      {
        document.forms[0].selectedDatabase.value=data.substring(1,i) + ' (' + data.substring(i+3,j) + ')';
      }
    }
  }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <db:script src="/database/LOV.js"/>
  <db:script src="/database/utils.js"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" 
        copyParams="target,type">


        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="databaseTitle@defaultBean@servletRequest">

        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                       errorTableBinding="msgBox@servletRequest"
                       destTableBinding="msgUrls@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:switcher childNameBinding="embeddedDBConsoleMode@defaultBean@servletRequest">
          <%-- DB Control --%>
          <uix:case name="true">
            <uix:tableLayout cellSpacing="5" width="75%" summary="tl">

              <%-- Intro --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="2" headers="">
                  <uix:styledText textBinding="databaseIntro@defaultBean@servletRequest" styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat headers="">
                  <uix:spacer height="15" />
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Host --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcHost" required="yes" promptBinding="HOST@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcHost" id="rcHost" textBinding="rcHost@defaultBean@servletRequest" columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>
        
              <%-- Port --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcPort" required="yes" promptBinding="PORT@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcPort" id="rcPort" textBinding="rcPort@defaultBean@servletRequest" columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>
        
              <%-- SID --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcSID" required="yes" promptBinding="SID@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcSID" id="rcSID" textBinding="rcSID@defaultBean@servletRequest" columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Recovery Catalog Username --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt required="yes" labeledNodeId="rcUsername" 
                      promptBinding="RC_USERNAME@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcUsername" id="rcUsername" 
                      textBinding="rcUsername@defaultBean@servletRequest" columns="30" noAutoComplete="true"/>
                </uix:cellFormat>
              </uix:rowLayout>
            
              <%-- Recovery Catalog Password --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcSecretPassword" required="yes" 
                      promptBinding="RC_PASSWORD@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcSecretPassword" id="rcSecretPassword" 
                      textBinding="rcSecretPassword@defaultBean@servletRequest" columns="30" secret="true" noAutoComplete="true"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:case>

          <%-- Grid Control --%>
          <uix:case name="false">
<uix:stackLayout>
  <uix:contents>
           <uix:tableLayout cellSpacing="5" width="75%" summary="tl">

              <%-- Intro --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="2" headers="">
                  <uix:styledText textBinding="databaseIntro@defaultBean@servletRequest" 
                    styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat headers="">
                  <uix:spacer height="15" />
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Option 1 - Discovered databases --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <oem:radioButton name="rcDiscovered" value="true"
                       selectedValueBinding="rcDiscovered@defaultBean@servletRequest"
                       textBinding="ADD_DATABASE_SEL_TARGET@catalogBundle@servletRequest"
                       styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- List of discovered databases --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt 
                    promptBinding="ADD_DATABASE_TARGET@catalogBundle@servletRequest"
                    labeledNodeId="selectedDatabase"
                    required="yes" />
                </uix:cellFormat>
                <uix:messageLovField columns="30" searchDescBinding="ADD_DATABASE_TARGET@catalogBundle@servletRequest"
                    name="selectedDatabase" id="selectedDatabase"
                    textBinding="selectedDatabase@defaultBean@servletRequest" 
                    onClick = "setWindowSize(800,700); useCallBack();
                    startLov('selectedDatabase', 'ListManagedDBDisplayName')"/>
               </uix:rowLayout>

              <%-- Option 2 - Non-discovered databases --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <oem:radioButton name="rcDiscovered" value="false"
                       selectedValueBinding="rcDiscovered@defaultBean@servletRequest"
                       textBinding="ADD_DATABASE_SEL_NONTARGET@catalogBundle@servletRequest"
                       styleClass="OraInstructionText" />        
                </uix:cellFormat>
              </uix:rowLayout>
        
              <%-- Host --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcHost" promptBinding="HOST@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcHost" id="rcHost" textBinding="rcHost@defaultBean@servletRequest" columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>
        
              <%-- Port --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcPort" promptBinding="PORT@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcPort" id="rcPort" textBinding="rcPort@defaultBean@servletRequest" columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>
        
              <%-- SID --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcSID" promptBinding="SID@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcSID" id="rcSID" textBinding="rcSID@defaultBean@servletRequest" columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Recovery Catalog Username --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcUsername" 
                      promptBinding="RC_USERNAME@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcUsername" id="rcUsername" 
                      textBinding="rcUsername@defaultBean@servletRequest" columns="30" noAutoComplete="true"/>
                </uix:cellFormat>
              </uix:rowLayout>
            
              <%-- Recovery Catalog Password --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messagePrompt labeledNodeId="rcSecretPassword"
                      promptBinding="RC_PASSWORD@commonBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="rcSecretPassword" id="rcSecretPassword" 
                      textBinding="rcSecretPassword@defaultBean@servletRequest" columns="30" secret="true" noAutoComplete="true"/>
                </uix:cellFormat>
              </uix:rowLayout>

              </uix:tableLayout>        
  </uix:contents>
</uix:stackLayout>

          </uix:case>
        </uix:switcher>
        
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" name="event" value="addCancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
            <uix:submitButton textBinding="NEXT@commonBundle@servletRequest" name="event" value="addNext" shortDescBinding="NEXT@commonBundle@servletRequest"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

