<%@ page import="oracle.sysman.emo.util.rec.RmanConstants" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" 
        copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

        <uix:header textBinding="userTitle@defaultBean@servletRequest">

        <uix:tableLayout cellSpacing="5" width="75%" summary="tl">

          <%-- Intro --%>
          <uix:rowLayout>
            <uix:cellFormat columnSpan="3" headers="">
              <uix:styledText textBinding="ADD_USER_INTRO@catalogBundle@servletRequest" 
                styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- Recovery Catalog Username --%>
          <uix:rowLayout>
            <uix:cellFormat headers="">
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" headers="">
              <uix:messagePrompt required="yes" labeledNodeId="rcUsername" 
                  promptBinding="RC_USERNAME@commonBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" headers="">
              <uix:lovInput name="rcUsername" id="rcUsername" 
                  textBinding="rcUsername@defaultBean@servletRequest" columns="20" 
                  shortDescBinding="RC_USERNAME@commonBundle@servletRequest"
                  destinationBinding="fullDestination@defaultBean@servletRequest"
                  searchDescBinding="RC_USERNAME@commonBundle@servletRequest" noAutoComplete="true"/>
            </uix:cellFormat>
          </uix:rowLayout>
        
          <%-- Recovery Catalog Password --%>
          <uix:rowLayout>
            <uix:cellFormat headers="">
              <uix:styledText styleClass="OraInlineInfoText" text=""/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right" headers="">
              <uix:messagePrompt labeledNodeId="rcSecretPassword" required="yes" 
                  promptBinding="RC_PASSWORD@commonBundle@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" headers="">
              <uix:textInput name="rcSecretPassword" id="rcSecretPassword" 
                  textBinding="rcSecretPassword@defaultBean@servletRequest" columns="20" secret="true" noAutoComplete="true"/>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>        

        </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="addCancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

