<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.resources.eml.creds.PrefCredsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
request.setAttribute("credsMsgBundle", new BundleDataObject(NLSUtil.getBundle(PrefCredsMsg.class.getName(), request)));
%>

<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if ((i=data.indexOf('".')) > 0)
  {
    if(destField == "selectedHostOH")
    {
      document.forms[0].selectedHostOH.value=data.substring(1,i);
      s = data.substring(i+3, data.length-1);
      document.forms[0].hostOH.value=s;
    }
  }
}

function disableOrEnableHostCredFields()
{
  if (removeRC.dropCatalog.checked)
  {
    removeRC.selectedHostOH.disabled = false;
    removeRC.hostOH.disabled = false;
    removeRC.hostUserName.disabled = false;
    removeRC.hostSecretPassword.disabled = false;
    removeRC.rcUsername.disabled = false;
    removeRC.rcSecretPassword.disabled = false;
  }
  else 
  {
    removeRC.selectedHostOH.disabled = true;
    removeRC.hostOH.disabled = true;
    removeRC.hostUserName.disabled = true;
    removeRC.hostSecretPassword.disabled = true;
    removeRC.rcUsername.disabled = true;
    removeRC.rcSecretPassword.disabled = true;
  }
}

</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="removeRC" destinationBinding="destination@defaultBean@servletRequest" method="post" 
        copyParams="target,type">
        <uix:formValue name="pageName" value="/database/rec/catalogItem/remove"/>
        <uix:formValue name="lovDatabaseVersion" valueBinding="lovDatabaseVersion@defaultBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="REMOVE_TITLE@catalogBundle@servletRequest">

        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                       errorTableBinding="msgBox@servletRequest"
                       destTableBinding="msgUrls@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout cellSpacing="5" width="75%" summary="t1" >

          <%-- Intro --%>
          <uix:rowLayout>
            <uix:cellFormat headers="" >
              <uix:styledText textBinding="REMOVE_INTRO@catalogBundle@servletRequest" 
                styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat headers="" >
              <uix:spacer height="10" />
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- Drop catalog --%>
          <uix:rowLayout>
            <uix:cellFormat headers="" >
             <uix:messageCheckBox name="dropCatalog"
               textBinding="REMOVE_DROP_CATALOG_CHECK@catalogBundle@servletRequest"
               tipBinding="REMOVE_DROP_CATALOG_TIP@catalogBundle@servletRequest"
               checked="true" onClick="disableOrEnableHostCredFields()"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- Host credentials --%>
          <uix:rowLayout>
            <uix:cellFormat headers="" >

              <%-- LOV Host and Oracle Home --%>
              <uix:header textBinding="SELECT_ORACLE_HOME_HEADER@catalogBundle@servletRequest">
                <uix:contents>
                  <uix:tableLayout width="100%" summary="t1" >
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraInstructionText"
               textBinding="SELECT_DESTINATION_INSTRUCTION_FOR_REMOVE@catalogBundle@servletRequest"/>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <%-- Start of included section --%>
                  <uix:stackLayout>
                    <uix:contents>
                      <%@ include file="/database/rec/catalogItem/selectDest.jspf" %>
                    </uix:contents>
                  </uix:stackLayout>
                  <%-- End of included section --%>
                </uix:contents>
              </uix:header>

              <%-- Host credentials --%>
              <uix:header textBinding="ADD_CREDS_FUNC@catalogBundle@servletRequest">
                <uix:styledText styleClass="OraInstructionText" 
                  textBinding="REMOVE_CREDS_HOST_INTRO@catalogBundle@servletRequest" />

                <uix:stackLayout>                   
                <uix:contents>
                 <uix:labeledFieldLayout labelWidth="25%">
                  <uix:contents>
                   <uix:messageTextInput name="hostUserName" 
                                         promptBinding="USERNAME@credsMsgBundle@servletRequest"
                                         textBinding="hostUserName@defaultBean@servletRequest" 
                                         messageBinding="hostUserNameError@defaultBean@servletRequest" 
                                         messageTypeBinding="hostUserNameErrorType@defaultBean@servletRequest" 
                                         columns="40"
                                         noAutoComplete="true"/>
                
                   <uix:messageTextInput name="hostSecretPassword" 
                                         promptBinding="PASSWORD@credsMsgBundle@servletRequest" 
                                         textBinding="hostSecretPassword@defaultBean@servletRequest" 
                                         messageBinding="hostPasswordError@defaultBean@servletRequest" 
                                         messageTypeBinding="hostPasswordErrorType@defaultBean@servletRequest" 
                                         secret="true"           
                                         columns="40"
                                         noAutoComplete="true"/>

                   <%-- Recovery Catalog Username --%>
                   <uix:messageTextInput name="rcUsername" 
                                         promptBinding="RC_USERNAME@commonBundle@servletRequest" 
                                         textBinding="rcUsername@defaultBean@servletRequest" 
                                         columns="40"
                                         noAutoComplete="true"/>
        
                   <%-- Recovery Catalog Password --%>
                   <uix:messageTextInput name="rcSecretPassword" 
                                         promptBinding="RC_PASSWORD@commonBundle@servletRequest" 
                                         textBinding="rcSecretPassword@defaultBean@servletRequest" 
                                         secret="true"           
                                         columns="40"
                                         noAutoComplete="true"/>
 
                  </uix:contents>
                 </uix:labeledFieldLayout>
                </uix:contents>
                </uix:stackLayout>                   
              </uix:header>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>        
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" name="event" value="removeCancel" shortDescBinding="CANCEL@commonBundle@servletRequest" />
            <uix:submitButton textBinding="OK@commonBundle@servletRequest" name="event" value="removeFinish" shortDescBinding="OK@commonBundle@servletRequest" />
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

