<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.resources.eml.creds.PrefCredsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
request.setAttribute("credsMsgBundle", new BundleDataObject(NLSUtil.getBundle(PrefCredsMsg.class.getName(), request)));
%>
<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if ((i=data.indexOf('".')) > 0)
  {
    if(destField == "selectedHostOH")
    {
      document.forms[0].selectedHostOH.value=data.substring(1,i);
      s = data.substring(i+3, data.length-1);
      document.forms[0].hostOH.value=s;
    }
  }
}
</script>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="upgradeRC" destinationBinding="destination@defaultBean@servletRequest" method="post" 
        copyParams="target,type">
      <uix:formValue name="pageName" value="/database/rec/catalogItem/upgrade"/>
        <uix:formValue name="lovDatabaseVersion" valueBinding="lovDatabaseVersion@defaultBean@servletRequest"/>
      
        <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="UPGRADE_TITLE@catalogBundle@servletRequest">

        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                       errorTableBinding="msgBox@servletRequest"
                       destTableBinding="msgUrls@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout cellSpacing="5" width="75%" summary="t1" >

          <%-- Intro --%>
          <uix:rowLayout>
            <uix:cellFormat  headers="" >
              <uix:styledText textBinding="UPGRADE_INTRO@catalogBundle@servletRequest" 
                styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat  headers="" >
              
              <%-- LOV Host and Oracle Home --%>
              <uix:header textBinding="SELECT_ORACLE_HOME_HEADER@catalogBundle@servletRequest">
                <uix:contents>
                  <uix:tableLayout width="100%" summary="t1" >
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraInstructionText"
                textBinding="SELECT_DESTINATION_INSTRUCTION_FOR_UPGRADE@catalogBundle@servletRequest"/>
                    </uix:rowLayout>
                  </uix:tableLayout>

              <%-- Start of included section --%>
                  <uix:stackLayout>
                    <uix:contents>
                      <%@ include file="/database/rec/catalogItem/selectDest.jspf" %>
                    </uix:contents>
                  </uix:stackLayout>
                 <%-- End of included section --%>

                </uix:contents>
              </uix:header>

              <%-- Host credentials --%>
              <uix:header textBinding="ADD_CREDS_FUNC@catalogBundle@servletRequest">
                <uix:styledText styleClass="OraInstructionText" 
                  textBinding="UPGRADE_CREDS_HOST_INTRO@catalogBundle@servletRequest" />

                <uix:stackLayout>                   
                <uix:contents>
                 <uix:labeledFieldLayout labelWidth="25%">
                  <uix:contents>
                   <uix:messageTextInput name="hostUserName" 
                                         promptBinding="USERNAME@credsMsgBundle@servletRequest"
                                         textBinding="hostUserName@defaultBean@servletRequest" 
                                         messageBinding="hostUserNameError@defaultBean@servletRequest" 
                                         messageTypeBinding="hostUserNameErrorType@defaultBean@servletRequest" 
                                         columns="40"
                                         required="uiOnly"
                                         noAutoComplete="true"/>
                
                   <uix:messageTextInput name="hostSecretPassword" 
                                         promptBinding="PASSWORD@credsMsgBundle@servletRequest" 
                                         textBinding="hostSecretPassword@defaultBean@servletRequest" 
                                         messageBinding="hostPasswordError@defaultBean@servletRequest" 
                                         messageTypeBinding="hostPasswordErrorType@defaultBean@servletRequest" 
                                         secret="true"           
                                         columns="40"
                                         required="uiOnly"
                                         noAutoComplete="true"/>
                
                   <%-- Recovery Catalog Username --%>
                   <uix:messageTextInput name="rcUsername" 
                                         promptBinding="RC_USERNAME@commonBundle@servletRequest" 
                                         textBinding="rcUsername@defaultBean@servletRequest" 
                                         columns="40"
                                         required="uiOnly"
                                         noAutoComplete="true"/>
        
                   <%-- Recovery Catalog Password --%>
                   <uix:messageTextInput name="rcSecretPassword" 
                                         promptBinding="RC_PASSWORD@commonBundle@servletRequest" 
                                         textBinding="rcSecretPassword@defaultBean@servletRequest" 
                                         secret="true"           
                                         columns="40"
                                         required="uiOnly"
                                         noAutoComplete="true"/>
                  </uix:contents>
                 </uix:labeledFieldLayout>
                </uix:contents>
                </uix:stackLayout>                   
              </uix:header>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>        
        </uix:header>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" name="event" value="upgradeCancel" shortDescBinding="CANCEL@commonBundle@servletRequest" />
            <uix:submitButton textBinding="OK@commonBundle@servletRequest" name="event" value="upgradeFinish" shortDescBinding="OK@commonBundle@servletRequest" />
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

