<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:bundle name="commonBundle" class="oracle.sysman.db.rsc.rec.CommonMsg"/>
  <uix:document> 

  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
      
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="CATALOG_LIST@catalogBundle@servletRequest">

        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                       errorTableBinding="msgBox@servletRequest"
                       destTableBinding="msgUrls@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:stackLayout>
          <uix:contents>
          
      <%--uix:switcher childNameBinding="embeddedDBConsoleMode@defaultBean@servletRequest">
      <uix:case name="true">

          <uix:tableLayout width="100%" cellSpacing="2" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat columnSpan="3" headers="">
                  <uix:styledText textBinding="LIST_INTRO@catalogBundle@servletRequest" 
                    styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout hAlign="right">
                <uix:cellFormat headers="">
                  <uix:contents>
                      <uix:submitButton textBinding="TABLE_ACTION_ADD@catalogBundle@servletRequest" 
                        name="event" value="add"  shortDesc="image" />
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
              <oem:table name="catalogListTable"
                   width="100%" blockSize="10"
                   dataSourceProp="catalogListTable"
                   beanKey="defaultBean"
                   alternateTextBinding="NO_CATALOGS_ITEMS@catalogBundle@servletRequest"
                   formSubmitted="true"
		   summaryBinding="CATALOG_LIST@catalogBundle@servletRequest">
                   <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@commonBundle@servletRequest">
                          <uix:submitButton textBinding="TABLE_ACTION_REMOVE@catalogBundle@servletRequest" name="event" value="remove"  shortDesc="image" />
                          <uix:submitButton textBinding="TABLE_ACTION_UPGRADE@catalogBundle@servletRequest" name="event" value="upgrade"  shortDesc="image" />
                          <uix:submitButton textBinding="TABLE_ACTION_EDIT@catalogBundle@servletRequest" name="event" value="edit"  shortDesc="image" />
                     </uix:singleSelection>
                  </uix:tableSelection>
              </oem:table>
              </uix:rowLayout>
            </uix:tableLayout>
      </uix:case>
      <uix:case name="false"--%>
      <%-- new table --%>
          <uix:tableLayout width="100%" cellSpacing="2" summary="tl">
              <%-- Intro --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="3" headers="">
                  <uix:styledText textBinding="LIST_INTRO@catalogBundle@servletRequest" 
                    styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout hAlign="right">
                <uix:cellFormat headers="">
                  <uix:contents>
                      <uix:submitButton name="event" value="add" textBinding="TABLE_ACTION_ADD@catalogBundle@servletRequest" shortDescBinding="TABLE_ACTION_ADD@catalogBundle@servletRequest" />
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>              
              
              <uix:rowLayout>              
              
                <uix:hGrid id="catalogListTable"
                       width="100%"
                       alternateTextBinding="NO_OBJ_FOUND@recoveryBundle"
                       destination="/em/console/database/rec/catalogList"
                       formSubmitted="true"
                       columnFormatsBinding="columnFormats@catalogListTable@servletRequest"
                       columnHeaderDataBinding="columnHeaderData@catalogListTable@servletRequest"
                       treeDataBinding="treeData@catalogListTable@servletRequest"
                       proxyBinding="proxy@servletRequest"
                       summaryBinding="CATALOGS_TABLE_SUMMARY@catalogBundle@servletRequest">

                  <uix:nodeStamp>
                      <uix:column>
                          <uix:columnHeader>
                              <uix:styledText textBinding="COL_CATALOG_USERNAME@catalogBundle@servletRequest"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="user"/>
                      </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                      <uix:text textBinding="headerName"/>
                  </uix:columnHeaderStamp>

                  <uix:styledText textBinding="type"/>
		  <uix:switcher childNameBinding="avail" defaultCase="default">
		  <uix:case name="default">
                  <uix:image sourceBinding="avail" shortDescBinding="COL_AVAILABILITY@catalogBundle@servletRequest"/>
		  </uix:case>
		  <uix:case name="n/a">
		  <uix:styledText textBinding="NOT_AVAILABLE@catalogBundle@servletRequest"/>
		  </uix:case>
		  </uix:switcher>
                  <uix:styledText textBinding="host"/>
                  <uix:styledText textBinding="db"/>
                  <uix:styledText textBinding="version"/>

                  <uix:tableSelection>
                  <uix:singleSelection selectedIndexBinding="selectedCataTableIndex@defaultBean@servletRequest" 
                                       shortDescBinding="SELECT@commonBundle@servletRequest"
                                       onClick="submitForm('foo', true, {'event':'changeSelection'})">
                      <uix:switcher childNameBinding="vpc@defaultBean@servletRequest">
                      <uix:case name="false">
                        <uix:rowLayout>
                        <uix:submitButton name="event" value="edit" textBinding="TABLE_ACTION_EDIT@catalogBundle@servletRequest" shortDescBinding="TABLE_ACTION_EDIT@catalogBundle@servletRequest" />
                        <uix:submitButton name="event" value="upgrade" textBinding="TABLE_ACTION_UPGRADE@catalogBundle@servletRequest"  shortDescBinding="TABLE_ACTION_UPGRADE@catalogBundle@servletRequest" />                    
                        <uix:submitButton name="event" value="remove" textBinding="TABLE_ACTION_REMOVE@catalogBundle@servletRequest" shortDescBinding="TABLE_ACTION_REMOVE@catalogBundle@servletRequest" />                    
                        <uix:submitButton name="event" value="addVpc" textBinding="BUT_ADD_VPC@catalogBundle@servletRequest" shortDescBinding="BUT_ADD_VPC@catalogBundle@servletRequest" />
                        </uix:rowLayout>
                      </uix:case>
                      <uix:case name="true">
                        <uix:rowLayout>
                        <uix:submitButton name="event" value="manageVpc" textBinding="BUT_MANAGE_VPC@catalogBundle@servletRequest" shortDescBinding="BUT_MANAGE_VPC@catalogBundle@servletRequest" />
                        <uix:submitButton name="event" value="remove" textBinding="TABLE_ACTION_REMOVE@catalogBundle@servletRequest" shortDescBinding="TABLE_ACTION_REMOVE@catalogBundle@servletRequest" />    
                        </uix:rowLayout>
                      </uix:case>
                      </uix:switcher>
                  </uix:singleSelection>
                </uix:tableSelection>
             
                 </uix:hGrid>
                 </uix:rowLayout>
              </uix:tableLayout>   
         <%--/uix:case>
         </uix:switcher--%>             
                                                                            
          </uix:contents>
        </uix:stackLayout>

        </uix:header> 
                
      <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@commonBundle" name="event" value="cancel"  shortDescBinding="CANCEL@commonBundle" />
            </uix:pageButtonBar>
      </uix:contentFooter>
        
      </uix:pageLayout>
       
    </db:form>

  </uix:body>
  </uix:document>
</uix:renderingContext>
