<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destination="/console/database/rec/config" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="1"/>
        <uix:formValue name="currentPage" value="1"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:location>
          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:breadCrumbs>
                <uix:contents childDataBinding=
                    "oracle_sysman_emSDK_eml_nav_PageBreadCrumbs@servletRequest">
                  <uix:link textBinding="text"
                      renderedBinding="rendered"
                      destinationBinding="destination" targetFrame="_top"/>
                </uix:contents>
              </uix:breadCrumbs>
            </uix:case>
            <uix:case name="true">
              <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:case>
          </uix:switcher>
        </uix:location>


      <uix:header textBinding="BACKUP_SETTINGS@configBundle@servletRequest">
        <uix:contents>
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="1">
              <uix:link textBinding="DEVICE@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'0',currentPage:'1'})" />
              <uix:link textBinding="BACKUP_SET@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'1',currentPage:'1'})"/>
              <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.0">
                <uix:case name="true">
                  <uix:link textBinding="POLICY@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'2',currentPage:'1'})"/>
                </uix:case>
              </db:switcher>

            </uix:subTabBar>
          </uix:subTabs>

          <oem:messageBox messageType="info"
                               errorTableBinding="info@servletRequest"
                               destTableBinding="infoUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                               errorTableBinding="errors@servletRequest"
                               destTableBinding="errorUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
          <uix:stackLayout>
            <uix:contents>

            <!-- Disk & Tape Settings -->
            <uix:labeledFieldLayout labelWidth="20%">
              <uix:contents>

              <uix:messagePrompt labeledNodeId="maxPieceSize" promptBinding="LIMIT_PIECE_SIZE@configBundle@servletRequest" />

              <uix:rowLayout>
              <uix:contents>
                <uix:textInput name="maxPieceSize"
                     id="maxPieceSize"
                     textBinding="maxPieceSize@configBean@servletRequest"
                     disabledBinding="isDisableMaxPiece@defaultBean@servletRequest"
                     columns="4">
                  <uix:onBlurValidater>
                    <uix:decimal/>
                  </uix:onBlurValidater>
                </uix:textInput>

                <uix:choice name="pieceSizeUnit" 
                     id="pieceSizeUnit"
                     disabledBinding="isDisableMaxPiece@defaultBean@servletRequest" 
                     selectedValueBinding="pieceSizeUnit@configBean@servletRequest">
                  <uix:option textBinding="KBYTES@configBundle@servletRequest" value="K"/>
                  <uix:option textBinding="MBYTES@configBundle@servletRequest" value="M"/>
                  <uix:option textBinding="GBYTES@configBundle@servletRequest" value="G"/>
                </uix:choice>
              </uix:contents>
              </uix:rowLayout>

             <uix:styledText styleClass="OraInlineInfoText" text=""/>
             <uix:styledText labeledNodeId="pieceSizeUnit" styleClass="OraInlineInfoText" textBinding="LIMIT_PIECE_SIZE_TIP@configBundle@servletRequest" />

              </uix:contents>
            </uix:labeledFieldLayout>

            <!-- Compression Algorithm -->
            <uix:header renderedBinding="DB111orHigher@defaultBean@servletRequest" textBinding="COMPRESS_ALGORITHM@configBundle@servletRequest" size="1">

            <!-- Intro text -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" columnSpan="2">
               <uix:styledText styleClass="OraInstructionText" textBinding="COMPRESS_ALGORITHM_INTRO@configBundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>

            <!-- Compression Algorithm Name -->
            <uix:labeledFieldLayout labelWidth="20%">
              <uix:messagePrompt labeledNodeId="defaultCompressionAlgorithm" 
                promptBinding="COMPRESS_NAME@configBundle@servletRequest"/>

              <%-- Dropdown list of Compression Algorithm Name --%>
              <oem:choice name="defaultCompressionAlgorithm" 
                    id="defaultCompressionAlgorithm"
                    optionsBinding="availableCompressionAlgorithms@configBean@servletRequest"
                    selectedValueBinding="defaultCompressionAlgorithm@configBean@servletRequest"
                    disabledBinding="configReadOnly@defaultBean@servletRequest"
                    shortDescBinding="COMPRESS_NAME@configBundle@servletRequest"/>

              <uix:styledText styleClass="OraInlineInfoText" text=""/>
              <uix:switcher childNameBinding="defaultCompressionMatch@configBean@servletRequest">
                <uix:case name="true">
                  <uix:styledText labeledNodeId="defaultCompressionAlgorithm" styleClass="OraInlineInfoText" 
                    textBinding="COMPRESS_NAME_DESC1@configBundle@servletRequest" />
                </uix:case>
                <uix:case name="false">
                  <uix:styledText labeledNodeId="defaultCompressionAlgorithm" styleClass="OraInlineInfoText" 
                    textBinding="COMPRESS_NAME_DESC2@configBundle@servletRequest" />
                </uix:case>
              </uix:switcher>
            </uix:labeledFieldLayout>

            <uix:labeledFieldLayout labelWidth="20%" renderedBinding="DB112orHigher@defaultBean@servletRequest">
              <!-- Compression Algorithm Release -->
              <uix:messagePrompt labeledNodeId="defaultCompressionRelease" 
                promptBinding="COMPRESS_RELEASE@configBundle@servletRequest"/>

              <%-- Dropdown list of 'AS OF RELEASE' values --%>
              <oem:choice name="defaultCompressionRelease"
                id="defaultCompressionRelease"
                optionsBinding="availableCompressionReleases@configBean@servletRequest"
                selectedValueBinding="defaultCompressionRelease@configBean@servletRequest"
                disabledBinding="configReadOnly@defaultBean@servletRequest"
                shortDescBinding="COMPRESS_RELEASE@configBundle@servletRequest"/>

              <uix:styledText styleClass="OraInlineInfoText" text=""/>
              <uix:styledText labeledNodeId="defaultCompressionRelease" styleClass="OraInlineInfoText" 
                textBinding="COMPRESS_RELEASE_DESC@configBundle@servletRequest"/>
            </uix:labeledFieldLayout>

            <%-- 'OPTIMIZE FOR LOAD' checkbox --%>
            <uix:rowLayout renderedBinding="DB112orHigher@defaultBean@servletRequest">
              <uix:spacer width="30"/> <%-- indent to the right --%>
              <uix:stackLayout>
                <uix:checkBox name="compressionOptimizeForLoad"
                  textBinding="COMPRESS_OPTIMIZE@configBundle@servletRequest"
                  disabledBinding="configReadOnly@defaultBean@servletRequest"
                  checkedBinding="compressionOptimizeForLoad@configBean@servletRequest" />
                <uix:styledText labeledNodeId="compressionOptimizeForLoad" styleClass="OraInlineInfoText" 
                  textBinding="COMPRESS_OPTIMIZE_DESC@configBundle@servletRequest"/>
              </uix:stackLayout>
            </uix:rowLayout>      
            </uix:header>

            <!-- Tape Settings -->
            <uix:header textBinding="TAPE_CONFIG@configBundle@servletRequest" size="1">
                <uix:styledText styleClass="OraInstructionText" textBinding="COPY_TIP@configBundle@servletRequest" />
            <uix:labeledFieldLayout labelWidth="20%">
                  <uix:contents>
                  <uix:messageTextInput name="tapeDFCopies" 
                       shortDescBinding="NUM_DF_COPY_TIP@configBundle@servletRequest"
                       promptBinding="NUM_DF_COPY@configBundle@servletRequest"
                       textBinding="tapeDFCopies@configBean@servletRequest" 
                       disabledBinding="configReadOnly@defaultBean@servletRequest" 
                       tipBinding="NUM_DF_COPY_TIP@configBundle@servletRequest"
                       columns="1">
                  </uix:messageTextInput> 

                  <uix:messageTextInput name="tapeALCopies" 
                       promptBinding="NUM_AL_COPY@configBundle@servletRequest"
                       shortDescBinding="NUM_AL_COPY_TIP@configBundle@servletRequest"
                       textBinding="tapeALCopies@configBean@servletRequest" 
                       disabledBinding="configReadOnly@defaultBean@servletRequest" 
                       tipBinding="NUM_AL_COPY_TIP@configBundle@servletRequest"
                       columns="1">
                  </uix:messageTextInput> 


                  </uix:contents>
                </uix:labeledFieldLayout>
            </uix:header>

            </uix:contents>
          </uix:stackLayout>

          <!-- Host Credentials -->
          <%@ include file="/database/rec/config/configCredentials.jspf" %>

        </uix:subTabLayout>
        </uix:contents>
      </uix:header>

      <uix:contentFooter>
        <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">
          <uix:case name="false">
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" name="event" value="cancel"  shortDescBinding="CANCEL@configBundle@servletRequest" />
              <uix:submitButton textBinding="OK@configBundle@servletRequest" name="event" value="apply" shortDescBinding="OK@configBundle@servletRequest" />
            </uix:pageButtonBar>
          </uix:case>
          <uix:case name="true">
            <uix:pageButtonBar>
              <uix:submitButton textBinding="OK@configBundle@servletRequest" name="event" value="cancel"  shortDescBinding="OK@configBundle@servletRequest" />
            </uix:pageButtonBar>
          </uix:case>
        </uix:switcher>
      </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
