<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/config" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="0"/>

      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %>
        
        <uix:location>
          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:breadCrumbs>
                <uix:contents childDataBinding=
                    "oracle_sysman_emSDK_eml_nav_PageBreadCrumbs@servletRequest">
                  <uix:link textBinding="text"
                      renderedBinding="rendered"
                      destinationBinding="destination" targetFrame="_top"/>
                </uix:contents>
              </uix:breadCrumbs>
            </uix:case>
            <uix:case name="true">
              <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:case>
          </uix:switcher>
        </uix:location>


      <uix:header textBinding="BACKUP_SETTINGS@configBundle@servletRequest">
        <uix:contents>
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
              <uix:link textBinding="DEVICE@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'0'})"/>
              <uix:link textBinding="BACKUP_SET@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'1'})"/>
              <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="9.0">
                <uix:case name="true">
                  <uix:link textBinding="POLICY@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'2'})"/>
                </uix:case>
              </db:switcher>
            </uix:subTabBar>
          </uix:subTabs>

          <oem:messageBox messageType="info"
                               errorTableBinding="info@servletRequest"
                               destTableBinding="infoUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                               errorTableBinding="errors@servletRequest"
                               destTableBinding="errorUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>

              <!-- Disk Settings -->
              <uix:header textBinding="DISK_CONFIG@configBundle@servletRequest" size="1">
                <uix:stackLayout>
                  <uix:rowLayout hAlign="right">
                      <uix:submitButton textBinding="TEST_DISK@configBundle@servletRequest" shortDescBinding="TEST_DISK@configBundle@servletRequest" name="event" value="testDiskConnection" />
                  </uix:rowLayout>
                </uix:stackLayout>

                <uix:tableLayout cellSpacing="5" summary="tl">

                  <!-- Parallelism -->
                  <uix:switcher childNameBinding="parallelismSupported@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" headers="" >
                          <uix:messagePrompt labeledNodeId="diskParallelism" promptBinding="PARALLELISM@configBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="" >
                          <uix:textInput 
                               name="diskParallelism"
                               id="diskParallelism"
                               textBinding="diskParallelism@configBean@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               columns="2" required="yes">
                            <uix:onBlurValidater>
                              <uix:decimal/>
                            </uix:onBlurValidater>
                          </uix:textInput>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="parallelismSupported@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" headers="" >
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left"  width="75%" headers="" >
                          <uix:styledText textBinding="PARALLELISM_TIP@configBundle@servletRequest" styleClass="OraInlineInfoText"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>

                  <!-- Disk Backup Location -->
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="" >
                      <uix:messagePrompt labeledNodeId="diskLocation" promptBinding="DISK_FORMAT@configBundle@servletRequest"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="left" width="75%" headers="" >
                      <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">

                        <uix:case name="true">
                          <uix:switcher childNameBinding="useRecoveryArea@configBean@servletRequest">
                            <uix:case name="true">
                              <uix:messagePrompt 
                                   styleClass="OraInstructionTextStrong"
                                   promptBinding="RECOVERY_AREA@configBundle@servletRequest"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:textInput name="diskLocation"
                                   id="diskLocation" 
                                   textBinding="diskLocationDisplay@defaultBean@servletRequest"
                                   columns="60"
                                   styleClass="OraDataText"
                                   readOnly="true"/>
                            </uix:case>

                          </uix:switcher>
                        </uix:case>

                        <uix:case name="false">
                          <uix:textInput name="diskLocation" 
                               id="diskLocation" 
                               textBinding="diskLocation@configBean@servletRequest"
                               columns="60" 
                               disabledBinding="configReadOnly@defaultBean@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>

                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="" >
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="left" width="75%" headers="" >
                     <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">

                        <uix:case name="true">
                          <uix:switcher childNameBinding="useRecoveryArea@configBean@servletRequest">
                            <uix:case name="true">
                                <uix:styledText textBinding="DISK_LOCATION_TIP_RO_RA@configBundle@servletRequest"
                                  styleClass="OraInlineInfoText"/>
                            </uix:case>
                            <uix:case name="false">
                                <uix:styledText textBinding="diskLocationTip@defaultBean@servletRequest"
                                  styleClass="OraInlineInfoText"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>

                      <uix:case name="false">
                        <uix:switcher childNameBinding="recoveryAreaConfigured@defaultBean@servletRequest">
                          <uix:case name="true">
                            <uix:styledText textBinding="DISK_LOCATION_TIP_RA@configBundle@servletRequest"
                              styleClass="OraInlineInfoText"/>
                          </uix:case>

                          <uix:case name="false">
                            <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
                              <uix:case name="true">
                                <uix:styledText textBinding="DISK_LOCATION_TIP_NORA@configBundle@servletRequest"
                                  styleClass="OraInlineInfoText"/>
                              </uix:case>
                              <uix:case name="false">
                                <uix:styledText textBinding="DISK_LOCATION_TIP_NORA_PRE10@configBundle@servletRequest"
                                  styleClass="OraInlineInfoText"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:case>
                        </uix:switcher>

                    </uix:case>
                  </uix:switcher>
                  </uix:cellFormat>
                 </uix:rowLayout>

                  <!-- Related Links -->
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="" >
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" width="75%" headers="" >
                      <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">
                        <uix:case name="false">
                          <uix:switcher childNameBinding="recoveryAreaConfigured@defaultBean@servletRequest">
                            <uix:case name="false">
                              <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
                                <uix:case name="true">
                                 <db:link textBinding="CONFIGURE_FRA@configBundle@servletRequest"
                                          destination="/console/database/instance/recovery?setFocus=FRA" copyParams="target,type"/>

                                </uix:case>
                              </uix:switcher>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <!-- Disk Backup Type -->
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top" headers="" >
                          <uix:messagePrompt promptBinding="DISK_BACKUP_TYPE@configBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="" >
                          <uix:messageRadioButton name="diskBackupType" value="BACKUPSET"
                               shortDescBinding="BACKUP_SET@configBundle@servletRequest"
                               selectedValueBinding="diskBackupType@configBean@servletRequest"
                               textBinding="BACKUP_SET@configBundle@servletRequest"
                               tipBinding="BACKUP_SET_TIP@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               styleClass="OraInstructionText" />

                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top" headers="" >
                          <uix:spacer/> 
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="" >
                          <uix:messageRadioButton name="diskBackupType" value="COMPRESSED BACKUPSET"
                               selectedValueBinding="diskBackupType@configBean@servletRequest"
                               shortDescBinding="COMPRESSED_BACKUP_SET@configBundle@servletRequest"
                               textBinding="COMPRESSED_BACKUP_SET@configBundle@servletRequest"
                               tipBinding="COMPRESSED_BACKUP_SET_TIP@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               styleClass="OraInstructionText" />

                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top" headers="" >
                          <uix:spacer/> 
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="" >
                          <uix:messageRadioButton name="diskBackupType" value="COPY"
                               selectedValueBinding="diskBackupType@configBean@servletRequest"
                               textBinding="IMAGE_COPY@configBundle@servletRequest"
                               shortDescBinding="IMAGE_COPY@configBundle@servletRequest"
                               tipBinding="IMAGE_COPY_TIP@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               styleClass="OraInstructionText" />

                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>
                </uix:tableLayout>
              </uix:header>

              <!-- Tape Settings -->
              <uix:header textBinding="TAPE_CONFIG@configBundle@servletRequest" size="1">
                <uix:stackLayout>
                  <uix:rowLayout hAlign="right">
                    <uix:stackLayout>
                      <uix:submitButton textBinding="TEST_TAPE@configBundle@servletRequest" shortDescBinding="TEST_TAPE@configBundle@servletRequest" name="event" value="testTapeConnection" />
                      <uix:spacer height="10"/>
                      <uix:submitButton textBinding="CLEAR_TAPE_CONFIG@configBundle@servletRequest" 
                                        name="event" shortDescBinding="CLEAR_TAPE_CONFIG@configBundle@servletRequest" 
                                        value="clearTapeConfig" />
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:stackLayout>
                <uix:tableLayout cellSpacing="5" summary="tl">

                  <!-- Intro text -->
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" columnSpan="2" headers="" >
                      <uix:styledText styleClass="OraInstructionText" textBinding="MOUNT_TIP@configBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <!-- Tape Drives -->
                  <uix:switcher childNameBinding="parallelismSupported@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" headers="" >
                          <uix:messagePrompt labeledNodeId="tapeParallelism" promptBinding="NUM_TAPES@configBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="" >
                          <uix:textInput 
                               name="tapeParallelism"
                               id="tapeParallelism"
                               textBinding="tapeParallelism@configBean@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               columns="2">
                          </uix:textInput>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="parallelismSupported@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" headers="" >
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="" >
                          <uix:styledText textBinding="NUM_TAPES_TIP@configBundle@servletRequest" styleClass="OraInlineInfoText"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>

                  <!-- Tape Backup Type -->
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top" headers="">
                          <uix:messagePrompt promptBinding="TAPE_BACKUP_TYPE@configBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="">
                          <uix:messageRadioButton name="tapeBackupType" value="BACKUPSET"
                               selectedValueBinding="tapeBackupType@configBean@servletRequest"
                               shortDescBinding="BACKUP_SET@configBundle@servletRequest"
                               textBinding="BACKUP_SET@configBundle@servletRequest"
                               tipBinding="BACKUP_SET_TIP@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               styleClass="OraInstructionText" />

                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>
                  <db:switcher connectionBinding="emConnection@servletRequest" versionAtLeast="10.0">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top" headers="">
                          <uix:spacer/> 
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" width="75%" headers="">
                          <uix:messageRadioButton name="tapeBackupType" value="COMPRESSED BACKUPSET"
                               selectedValueBinding="tapeBackupType@configBean@servletRequest"
                               shortDescBinding="COMPRESSED_BACKUP_SET@configBundle@servletRequest"
                               textBinding="COMPRESSED_BACKUP_SET@configBundle@servletRequest"
                               tipBinding="COMPRESSED_BACKUP_SET_TIP@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               styleClass="OraInstructionText" />

                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </db:switcher>

                </uix:tableLayout>

                <!-- Oracle Backup section -->
                <uix:header textBinding="OB_TITLE@obBundle@servletRequest" size="1">
                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
                    <!-- Version -->
                    <uix:styledText 
                         textBinding="VERSION@obBundle@servletRequest" 
                         styleClass="OraInstructionText"/>
                    <uix:styledText textBinding="oracleBackupVersionDisplay@defaultBean@servletRequest" 
                      styleClass="OraDataText"/>
                    <!-- Administrative Host -->
                    <uix:styledText 
                         textBinding="AH_SELECTOR@obBundle@servletRequest" 
                         styleClass="OraInstructionText"/>
                    <uix:styledText textBinding="adminNameDisplay@obBean@servletRequest" 
                      styleClass="OraDataText"/>
                    <!-- Database Configurations -->
                    <uix:styledText 
                         textBinding="ORACLE_CONFS@obBundle@servletRequest" 
                         styleClass="OraInstructionText"/>
                    <!-- Configure/Overide button -->
                    <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
                      <uix:case name="false">
                        <uix:submitButton textBinding="CONFIGURE@obBundle@servletRequest"  shortDescBinding="CONFIGURE@obBundle@servletRequest" 
                                          name="event" value="oconfSettings"/>
                      </uix:case>
                      <uix:case name="true">
                        <uix:submitButton textBinding="OVERRIDE@obBundle@servletRequest" 
                                          name="event" value="overrideOconf" shortDescBinding="OVERRIDE@obBundle@servletRequest" 
                                          disabledBinding="configReadOnly@defaultBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    <!-- Tip -->
                    <uix:styledText text=""
                                    styleClass="OraInstructionText"/>
                    <uix:styledText textBinding="OB_MMV_TIP@obBundle@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
                </uix:header>

                <!-- Media Management Settings -->
                <uix:header textBinding="MM_SETTINGS@obBundle@servletRequest" size="1"
                    renderedBinding="showTapeParms@defaultBean@servletRequest">
                  <!-- Intro text -->
                    <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                      <uix:styledText styleClass="OraInstructionText" textBinding="MMS_INTRO@configBundle@servletRequest" />
                    </uix:cellFormat>
                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
                    <!-- MMV Library Parameters -->
                    <uix:messagePrompt labeledNodeId="tapeParms" promptBinding="MMV_LIBRARY@configBundle@servletRequest" />
                    <uix:textInput 
                         name="tapeParms" 
                         id="tapeParms" 
                         textBinding="tapeParms@configBean@servletRequest" 
                         disabledBinding="launchedFromWizard@defaultBean@servletRequest"
                         columns="80" 
                         rows="4" />
                  </uix:contents>
                </uix:labeledFieldLayout>
                </uix:header>
              </uix:header>

          <!-- Host Credentials -->
          <%@ include file="/database/rec/config/configCredentials.jspf" %>

          </uix:subTabLayout>
        </uix:contents>

        </uix:header>

      <uix:contentFooter> 
        <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">
          <uix:case name="false">
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" shortDescBinding="CANCEL@configBundle@servletRequest"  name="event" value="cancel" />
              <uix:submitButton textBinding="OK@configBundle@servletRequest" shortDescBinding="OK@configBundle@servletRequest"  name="event" value="apply" />
            </uix:pageButtonBar>
          </uix:case>
          <uix:case name="true">
            <uix:pageButtonBar>
              <uix:submitButton textBinding="OK@configBundle@servletRequest"  shortDescBinding="OK@configBundle@servletRequest" name="event" value="cancel" />
            </uix:pageButtonBar>
          </uix:case>
        </uix:switcher>
      </uix:contentFooter>
 
      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
