<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/config" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="7"/>

      <uix:pageLayout> 
        <%@ include file="/database/global.jspf" %>
        
        <uix:location>
          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:breadCrumbs>
                <uix:contents childDataBinding=
                    "oracle_sysman_emSDK_eml_nav_PageBreadCrumbs@servletRequest">
                  <uix:link textBinding="text"
                      renderedBinding="rendered"
                      destinationBinding="destination" targetFrame="_top"/>
                </uix:contents>
              </uix:breadCrumbs>
            </uix:case>
            <uix:case name="true">
              <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:case>
          </uix:switcher>
        </uix:location>


      <uix:header textBinding="adminLoginTitle@obBean@servletRequest">

          <oem:messageBox messageType="info"
                               errorTableBinding="info@servletRequest"
                               destTableBinding="infoUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                               errorTableBinding="errors@servletRequest"
                               destTableBinding="errorUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout cellSpacing="5" width="75%">

          <%-- Intro text --%>
          <uix:rowLayout>
          <uix:cellFormat columnSpan="4">
            <uix:styledText textBinding="adminLoginIntro@obBean@servletRequest" 
              styleClass="OraInstructionText"/>
          </uix:cellFormat>
          </uix:rowLayout>

          <%-- List of administrative hosts--%>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="40%">
              <uix:messagePrompt 
                promptBinding="AH_SELECTOR@obBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" width="5%">
              <oem:choice name="adminNameWrapper"
                   shortDescBinding="AH_SELECTOR@obBundle@servletRequest"
                   optionsBinding="obAdminHostsDisplay@obBean@servletRequest"
                   disabledBinding="obConf@obBean@servletRequest"
                   selectedValueBinding="adminName@obBean@servletRequest">
              </oem:choice>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:submitButton textBinding="ADD@obBundle@servletRequest" 
                                disabledBinding="obConf@obBean@servletRequest"
                                name="event" 
                                value="addAdminHost"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

      <!-- OSB Credentials -->
      <uix:header textBinding="OSB_CREDENTIALS@obBundle@servletRequest">
        <uix:styledText styleClass="OraInstructionText" textBinding="OSB_CREDENTIALS_TEXT@obBundle@servletRequest" />
        <uix:labeledFieldLayout labelWidthBinding="credsLabelWidth@credsBean@servletRequest">
          <uix:contents>
            <uix:messageTextInput name="adminUserName"
                                  textBinding="settingsUser@obBean@servletRequest"
                                  promptBinding="OB_USER_NAME@obBundle@servletRequest"
                                  shortDescBinding="OB_USER_NAME@obBundle@servletRequest"
                                  tipBinding="OB_USER_NAME_TIP@obBundle@servletRequest"
                                  required="uiOnly"
                                  noAutoComplete="true"
                                  columns="30"/>
            <uix:messageTextInput name="adminUserPassword"
                                  promptBinding="OB_USER_PASSWORD@obBundle@servletRequest"
                                  textBinding="settingsPass@obBean@servletRequest"
                                  secret="true"
                                  shortDescBinding="OB_USER_PASSWORD@obBundle@servletRequest"
                                  required="uiOnly"
                                  noAutoComplete="true"
                                  columns="30" />
          </uix:contents>
        </uix:labeledFieldLayout>
      </uix:header>

      <uix:spacer height="10"/>

        <%-- Host Credentials --%>
        <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest" size="1">
            <uix:styledText textBinding="adminHostCredsIntro@obBean@servletRequest" 
              styleClass="OraInstructionText"/>

          <uix:contents>
             <%@ include file="/credentials.jspf"%>
           </uix:contents>
        </uix:header>

        </uix:header>

      <uix:contentFooter> 
        <uix:pageButtonBar>
          <uix:submitButton 
               textBinding="CANCEL@configBundle@servletRequest" 
               name="event" 
               value="cancelObCred" />

          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:submitButton 
                   textBinding="OK@configBundle@servletRequest" 
                   name="event" 
                   value="oconfSettings" />
            </uix:case>
            <uix:case name="true">
              <uix:submitButton 
                   textBinding="OK@configBundle@servletRequest" 
                   name="event" 
                   value="overrideOconf" />
            </uix:case>
          </uix:switcher>
        </uix:pageButtonBar>
      </uix:contentFooter>
 
      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

