<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/rec/config" copyParams="target,type">
    <uix:formValue name="pageNum" value="4"/>
    <uix:formValue name="adminName" valueBinding="adminName@obBean@servletRequest"/>
    <uix:formValue name="pageSource" value="oconf"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info"
               errorTableBinding="info@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
               errorTableBinding="errors@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>
         <oem:messageBox messageType="warning"
               errorTableBinding="warnings@servletRequest"
               titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:header textBinding="CONF_OB_OCONF@obBundle@servletRequest">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
               <uix:styledText styleClass="OraInstructionText" 
                              textBinding="HEADING_OC@obBundle@servletRequest" />
             </uix:cellFormat>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:rowLayout>
                <%@ include file="/database/ob/refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:cellFormat>
         </uix:rowLayout>

         <%@ include file="/database/ob/storage_selectors.jspf" %>
       </uix:header>
                
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:flowLayout>
              <uix:submitButton textBinding="RETURN@obBundle@servletRequest"
                                name="event"
                                value="cancelObCred"
                                formName="foo"/>
            </uix:flowLayout>
          </uix:pageButtonBar>
        </uix:pageButtons>

       <uix:spacer height="10"/>
       <uix:header textBinding="RELATED_LINKS@obBundle@servletRequest" size="1">
         <uix:tableLayout cellSpacing="5" width="70%">
           <uix:rowLayout>
             <uix:cellFormat hAlign="left">
               <uix:link textBinding="CONF_OB@obBundle@servletRequest"
                         destinationBinding="osbLink@obBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
         </uix:tableLayout>
         <uix:spacer height="10"/>
       </uix:header>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
