<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/rec/config" copyParams="target,type"> 

    <uix:formValue name="pageNum" value="8"/>
    <uix:formValue name="pageOp" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="oldEvent" valueBinding="oldEvent@obBean@servletRequest"/>
    <uix:formValue name="ocn" valueBinding="ocn@oconfBean@obBean@servletRequest"/>
    <uix:formValue name="pageSource" value="configObAddOconf"/>

     <uix:pageLayout>
       <%@ include file="/database/global.jspf" %>

        <uix:location>
          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:breadCrumbs>
                <uix:contents childDataBinding=
                    "oracle_sysman_emSDK_eml_nav_PageBreadCrumbs@servletRequest">
                  <uix:link textBinding="text"
                      renderedBinding="rendered"
                      destinationBinding="destination" targetFrame="_top"/>
                </uix:contents>
              </uix:breadCrumbs>
            </uix:case>
            <uix:case name="true">
              <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:case>
          </uix:switcher>
        </uix:location>

       <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="warning"
                      errorTableBinding="warnings@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:header textBinding="OVERRIDE_OC@obBundle@servletRequest">
        <uix:tableLayout cellSpacing="5">
         <uix:rowLayout width="100%">
            <uix:cellFormat hAlign="left" vAlign="top" width="100%" columnSpan="2">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="HEADING_OC_OVERRIDE@obBundle@servletRequest" />
            </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>

   <%-- Secondary Storage Characteristics --%>
   <uix:header textBinding="OUTPUT_TITLE@obBundle@servletRequest" size="1">
   <uix:tableLayout cellSpacing="5" width="80%">

      <%-- Media Families --%>
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
          <uix:messagePrompt labeledNodeId="mf" promptBinding="MF@obBundle@servletRequest" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left" width="75%">
          <oem:choice name="mfn" 
                      id="mf" 
                      optionsBinding="mediaFamilies@mediafamilyBean@obBean@servletRequest"
                      selectedIndex="0"
                      selectedValueBinding="mfn@mediafamilyBean@obBean@servletRequest">
          </oem:choice>
        </uix:cellFormat>
      </uix:rowLayout>
   </uix:tableLayout>
   </uix:header>

    <%-- Device Restrictions --%>      
    <uix:header textBinding="DEVICE_RES@obBundle@servletRequest" size="1">
      <uix:styledText styleClass="OraInstructionText" textBinding="TIP_DEV_RES@obBundle@servletRequest" />

      <uix:tableLayout cellSpacing="5" width="80%">
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:submitButton
                   textBinding="ADD@commonBundle@servletRequest"
                   name="event"
                   value="addRestrictions"
                   formName="foo"/>
            </uix:contents>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <oem:table
        width="80%"
        blockSize="10"
        formSubmitted="true"
        name="restrictionsDS"
        dataSourceProp="restrictionsDS"
        beanKey="obBean"
        copyParams="target,type"
        summaryBinding="SELECT@commonBundle@servletRequest"
        alternateTextBinding="NO_ITEMS_SELECTED@commonBundle@servletRequest">
        <uix:tableSelection>
          <uix:multipleSelection 
           shortDescBinding="SELECT@commonBundle@servletRequest"
           selectedBinding="selected"
           selectionBinding="selection@restrictionsDS@obBean@servletRequest">
            <uix:submitButton
                 textBinding="REMOVE@commonBundle@servletRequest"
                 name="event"
                 value="removeRestrictions"
                 formName="foo" />
          </uix:multipleSelection>
        </uix:tableSelection>
      </oem:table>
    </uix:header>
      
  </uix:header>

      <uix:contentFooter> 
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@obBundle@servletRequest" name="event" value="cancelOverrideOconf" />
              <uix:submitButton textBinding="OK@obBundle@servletRequest" name="event" value="submitOverrideOconf" />
            </uix:pageButtonBar>
      </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
