<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="CREATE_OC@obBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/config" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="6"/>
        <uix:formValue name="pageSource" value="restrictedDevices"/>

      <uix:pageLayout titleBinding="DEVICE_RES@obBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:location>
          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:breadCrumbs>
                <uix:contents childDataBinding=
                    "oracle_sysman_emSDK_eml_nav_PageBreadCrumbs@servletRequest">
                  <uix:link textBinding="text"
                      renderedBinding="rendered"
                      destinationBinding="destination" targetFrame="_top"/>
                </uix:contents>
              </uix:breadCrumbs>
            </uix:case>
            <uix:case name="true">
              <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:case>
          </uix:switcher>
        </uix:location>
        
      <oem:messageBox messageType="info"
                           errorTableBinding="info@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                           errorTableBinding="errors@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>

         <%@ include file="/database/ob/restrictions_storage_selectors.jspf" %> 
          <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancelSelectRestrictions"/>
                <uix:submitButton textBinding="SELECT@commonBundle@servletRequest" formName="foo" name="event" value="selectRestrictions"/>

            </uix:pageButtonBar>
          </uix:pageButtons>
      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>


