<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/config" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="2"/>
        <uix:formValue name="currentPage" value="2"/>
        <uix:formValue name="pageSource" value="configPolicy"/>


      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:location>
          <uix:switcher childNameBinding="launchedFromWizard@defaultBean@servletRequest">
            <uix:case name="false">
              <uix:breadCrumbs>
                <uix:contents childDataBinding=
                    "oracle_sysman_emSDK_eml_nav_PageBreadCrumbs@servletRequest">
                  <uix:link textBinding="text"
                      renderedBinding="rendered"
                      destinationBinding="destination" targetFrame="_top"/>
                </uix:contents>
              </uix:breadCrumbs>
            </uix:case>
            <uix:case name="true">
              <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
                <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                  <uix:link textBinding="." disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:case>
          </uix:switcher>
        </uix:location>

      <uix:header textBinding="BACKUP_SETTINGS@configBundle@servletRequest">
        <uix:contents>
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="2">
              <uix:link textBinding="DEVICE@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'0',currentPage:'2'})"/>
              <uix:link textBinding="BACKUP_SET@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'1',currentPage:'2'})"/>
              <uix:link textBinding="POLICY@configBundle@servletRequest" onClick="submitForm('foo', true, {event:'doLoad',pageNum:'2',currentPage:'2'})"/>
            </uix:subTabBar>
          </uix:subTabs>

          <oem:messageBox messageType="info"
                               errorTableBinding="info@servletRequest"
                               destTableBinding="infoUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                               errorTableBinding="errors@servletRequest"
                               destTableBinding="errorUrls@servletRequest"
                               titleTextKey="titleText" mainTextKey="mainText"/>

              <uix:header textBinding="BACKUP_POLICY@configBundle@servletRequest" size="1">
                <uix:tableLayout cellSpacing="5" summary="tl" >
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left"  headers="" >
                      <uix:checkBox name="autoBackup"
                                    textBinding="AUTOBACKUP@configBundle@servletRequest"
                                    disabledBinding="configReadOnly@defaultBean@servletRequest"
                                    checkedBinding="autoBackup@configBean@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="center" headers="" >
                      <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">
                        <uix:case name="true">
                          <uix:switcher childNameBinding="useRAForAutoBackup@defaultBean@servletRequest">
                            <uix:case name="true">
                              <uix:messageTextInput name="diskAutoBackupLoc"
                                   promptBinding="AUTOBACKUP_LOCATION@configBundle@servletRequest"
                                   textBinding="RECOVERY_AREA@configBundle@servletRequest"
                                   disabled="true"
                                   columns="60"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:messageTextInput name="diskAutoBackupLoc"
                                   promptBinding="AUTOBACKUP_LOCATION@configBundle@servletRequest"
                                   textBinding="diskAutoBackupLoc@configBean@servletRequest"
                                   disabled="true"
                                   columns="60"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                        <uix:case name="false">
                          <uix:switcher childNameBinding="recoveryAreaConfigured@defaultBean@servletRequest">
                            <uix:case name="true">
                              <uix:messageTextInput name="diskAutoBackupLoc"
                                   promptBinding="AUTOBACKUP_LOCATION@configBundle@servletRequest"
                                   textBinding="diskAutoBackupLoc@configBean@servletRequest"
                                   tipBinding="AUTOBACKUP_LOCATION_TIP_RA@configBundle@servletRequest"
                                   disabled="false"
                                   columns="60"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:messageTextInput name="diskAutoBackupLoc"
                                   promptBinding="AUTOBACKUP_LOCATION@configBundle@servletRequest"
                                   textBinding="diskAutoBackupLoc@configBean@servletRequest"
                                   tipBinding="AUTOBACKUP_LOCATION_TIP_NORA@configBundle@servletRequest"
                                   disabled="false"
                                   columns="60"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>

<%--
                    <uix:cellFormat hAlign="center" >
                      <uix:switcher childNameBinding="useRecoveryArea@configBean@servletRequest">
                        <uix:case name="true">
                          <uix:messageTextInput name="diskAutoBackupLoc"
                               promptBinding="AUTOBACKUP_LOCATION@configBundle@servletRequest"
                               textBinding="diskAutoBackupLoc@configBean@servletRequest"
                               tipBinding="AUTOBACKUP_LOCATION_TIP_RA@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               columns="60">
                          </uix:messageTextInput>
                        </uix:case>
                        <uix:case name="false">
                          <uix:messageTextInput name="diskAutoBackupLoc"
                               promptBinding="AUTOBACKUP_LOCATION@configBundle@servletRequest"
                               textBinding="diskAutoBackupLoc@configBean@servletRequest"
                               tipBinding="AUTOBACKUP_LOCATION_TIP_NORA@configBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               columns="60">
                          </uix:messageTextInput>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
--%>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left"  headers="" >
                      <uix:checkBox name="optimize"
                                    textBinding="OPTIMIZE@configBundle@servletRequest"
                                    disabledBinding="configReadOnly@defaultBean@servletRequest"
                                    checkedBinding="optimize@configBean@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="trackingShown@defaultBean@servletRequest">
                    <uix:cellFormat hAlign="left" headers="" >
                      <uix:checkBox name="blockChangeTracking"
                                    textBinding="BLOCK_CHANGE_ENABLE@configBundle@servletRequest"
                                    disabledBinding="configReadOnly@defaultBean@servletRequest"
                                    checkedBinding="blockChangeTracking@configBean@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="trackingShown@defaultBean@servletRequest">
                    <uix:cellFormat hAlign="left" headers="" >
                      <uix:messageTextInput name="blockChangeTrackingFile"
                           promptBinding="BLOCK_CHANGE_FILE@configBundle@servletRequest"
                           textBinding="blockChangeTrackingFile@configBean@servletRequest"
                           tipBinding="BLOCK_CHANGE_FILE_TIP@configBundle@servletRequest"
                           disabledBinding="configReadOnly@defaultBean@servletRequest"
                           columns="60"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

                </uix:tableLayout>

                <uix:header textBinding="EXCLUDE_TS@configBundle@servletRequest" size="1">
                  <uix:styledText styleClass="OraInstructionText" textBinding="EXCLUDE_TS_INTRO@configBundle@servletRequest" />
                  <uix:tableLayout cellSpacing="5" width="80%" summary="tl" >
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" headers="" >
                        <uix:contents>
                          <uix:submitButton  shortDescBinding="ADD@commonBundle@servletRequest" 
                               textBinding="ADD@commonBundle@servletRequest"
                               disabledBinding="configReadOnly@defaultBean@servletRequest"
                               name="event"
                               value="addTablespaces"
                               formName="foo"
                          />
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <oem:table
                    width="80%"
                    blockSize="10"
                    formSubmitted="true"
                    name="tablespacesUI"
                    dataSourceProp="tablespacesUI"
                    beanKey="tablespacesDataSourceBean"
                    copyParams="target,type"
		    summaryBinding="EXCLUDE_TS@configBundle@servletRequest"
                    alternateTextBinding="NO_ITEMS_SELECTED@commonBundle@servletRequest">
                    <uix:tableSelection>
                      <uix:multipleSelection selectionBinding="selection@tablespacesDataSourceBean@servletRequest"
                        shortDescBinding="SELECT@commonBundle@servletRequest">
                        <uix:submitButton
                             textBinding="REMOVE@commonBundle@servletRequest"
                             disabledBinding="configReadOnly@defaultBean@servletRequest"
                             name="event"
                             value="removeTablespaces" 
                             formName="foo" />
                      </uix:multipleSelection>
                    </uix:tableSelection>
                  </oem:table>

                  <uix:tip>
                    <uix:styledText styleClass="OraInstructionText" textBinding="EXCLUDE_TS_TIP@configBundle@servletRequest" />
                  </uix:tip>

                </uix:header>

              </uix:header>

              <uix:header textBinding="RETENTION_POLICY@configBundle@servletRequest" size="1">
                <uix:tableLayout cellSpacing="5" summary="tl" >
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" vAlign="top" headers="" >
                    <oem:radioButton name="retentionPolicyType" value="none"  
                         selectedValueBinding="retentionPolicyType@configBean@servletRequest"
                         disabledBinding="retentionPolicyDisable@defaultBean@servletRequest"
                         textBinding="NO_DELETE@configBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" vAlign="top" headers="" >
                      <uix:spacer width="10" />
                      <uix:styledText textBinding="NO_DELETE_TIP@configBundle@servletRequest" styleClass="OraInlineInfoText"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" vAlign="top" headers="" >
                    <oem:radioButton name="retentionPolicyType" value="recovery_window"  
                         selectedValueBinding="retentionPolicyType@configBean@servletRequest"
                         disabledBinding="retentionPolicyDisable@defaultBean@servletRequest"
                         textBinding="RECOVERY_WINDOW@configBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right" headers="" >
                      <uix:messageTextInput name="recoveryWindow"
                           promptBinding="DAYS@configBundle@servletRequest"
                           textBinding="recoveryWindow@configBean@servletRequest"
                           disabledBinding="retentionPolicyDisable@defaultBean@servletRequest"
                           columns="15"
                           tipBinding="RECOVERY_WINDOW_TIP@configBundle@servletRequest">
                      </uix:messageTextInput>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" vAlign="top" headers="" >
                    <oem:radioButton name="retentionPolicyType" value="redundancy"   
                         selectedValueBinding="retentionPolicyType@configBean@servletRequest"
                         disabledBinding="retentionPolicyDisable@defaultBean@servletRequest"
                         textBinding="REDUNDANCY@configBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right" headers="" >
                      <uix:messageTextInput name="redundancy"
                           promptBinding="NUMBER@configBundle@servletRequest"
                           textBinding="redundancy@configBean@servletRequest"
                           disabledBinding="retentionPolicyDisable@defaultBean@servletRequest"
                           columns="15"
                           tipBinding="REDUNDANCY_TIP@configBundle@servletRequest">
                      </uix:messageTextInput>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>

              <uix:switcher childNameBinding="DB111orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="AL_POLICY_HEADER@configBundle@servletRequest" size="1">
                  <uix:styledText styleClass="OraInstructionText" 
                                  textBinding="AL_POLICY_INTRO@configBundle@servletRequest"/>
                  <uix:switcher childNameBinding="archiveLogPolicyForStandby@configBean@servletRequest">
                    <uix:case name="true">
                      <uix:include node="configStandbyPolicy.jsp" />         

                    </uix:case>
                    <uix:case name="false">
                      <uix:include node="configNonStandbyPolicy.jsp" />        
                    </uix:case>
                  </uix:switcher>
                  </uix:header>
                </uix:case>
                <uix:case name="false">
                  <uix:switcher childNameBinding="archiveLogPolicyForStandby@configBean@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="AL_POLICY_HEADER@configBundle@servletRequest" size="1">
                       <uix:styledText styleClass="OraInstructionText" textBinding="AL_POLICY_INTRO@configBundle@servletRequest"/>
                       <uix:include node="configNonStandbyPolicy.jsp" />
                      </uix:header>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
              </uix:switcher>			  

          <%@ include file="/database/rec/config/configCredentials.jspf" %>

          </uix:subTabLayout>
        </uix:contents>
      </uix:header>

      <uix:contentFooter>
        <uix:switcher childNameBinding="configReadOnly@defaultBean@servletRequest">
          <uix:case name="false">
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" name="event" value="cancel"  shortDescBinding="CANCEL@configBundle@servletRequest" />
              <uix:submitButton textBinding="OK@configBundle@servletRequest" name="event" value="apply"  shortDescBinding="OK@configBundle@servletRequest"  />
            </uix:pageButtonBar>
          </uix:case>
          <uix:case name="true">
            <uix:pageButtonBar>
              <uix:submitButton textBinding="OK@configBundle@servletRequest" name="event" value="cancel"   shortDescBinding="OK@configBundle@servletRequest" />
            </uix:pageButtonBar>
          </uix:case>
        </uix:switcher>
      </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


