<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="BACKUP_CONFIG@configBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/config" method="post" copyParams="target,type">
        <uix:formValue name="pageNum" value="3"/>
        <uix:formValue name="pageSource" value="excludedTS"/>

      <uix:pageLayout titleBinding="EXCLUDE_TS@configBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                           errorTableBinding="info@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                           errorTableBinding="errors@servletRequest"
                           titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:header textBinding="SEARCH@commonBundle@servletRequest">

            <uix:tableLayout cellSpacing="5" summary="tl" >
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" columnSpan="3" headers="" >
                  <uix:styledText
                       styleClass="OraInstructionText"
                       textBinding="CRITERIA@commonBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:flowLayout>
                          <uix:styledText
                            styleClass="OraPromptText"
                            labeledNodeId="searchFilter"
                            textBinding="TABLESPACE_NAME@commonBundle@servletRequest"/>
                          <uix:textInput name="searchFilter"
                            id="searchFilter"
                            textBinding="searchFilter@defaultBean@servletRequest"/>
                          <uix:submitButton
                            textBinding="GO@commonBundle@servletRequest"
                            onFocus="true"  shortDescBinding="GO@commonBundle@servletRequest" 
                            selected="true" name="event" value="addTablespaces"/>
                        </uix:flowLayout>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

            <uix:header textBinding="SEARCH_RESULTS@commonBundle@servletRequest">
              <oem:table
                width="80%"
                blockSize="10"
                formSubmitted="true"
                name="tablespacesUI"
                dataSourceProp="tablespacesUI"
                beanKey="tablespacesDataSourceBean"
                copyParams="target,type"
		summaryBinding="SEARCH_RESULTS@commonBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_SELECTED@commonBundle@servletRequest">
                <uix:tableSelection>
                  <uix:multipleSelection
                       shortDescBinding="SELECT@commonBundle@servletRequest"
                       selectedBinding="selected"
                       selectionBinding="selection@tablespacesDataSourceBean@servletRequest">
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>
            </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event"  shortDescBinding="CANCEL@commonBundle@servletRequest"  value="cancelSelect"/>
                <uix:submitButton textBinding="SELECT@commonBundle@servletRequest" formName="foo" name="event"  shortDescBinding="SELECT@commonBundle@servletRequest"  value="selectTablespaces"/>

            </uix:pageButtonBar>
          </uix:pageButtons>
      </uix:pageLayout>
    </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>


