<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:bundle name="cloneMsgs" class="oracle.sysman.db.rsc.clone.DBCloneCommonMsg"/>
  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="asmPageTitle@cloneMsgs"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="asmInstForm" destination="/console/database/testdb" method="post" copyParams="target,type,cancelURL,oname">
        <uix:formValue name="pageName" value="/database/rec/config/testdb/asmInstance"/>

        <uix:pageLayout titleBinding="ASM_PAGE_HEADER@dbCloneBundle@servletRequest">
          <%@ include file="/database/global.jspf" %>
          
          <%-- Wizard train 
          <uix:location>
          <uix:train selectedIndexBinding="trainIndex@dbCloneBean@servletRequest">
            <uix:contents childDataBinding="trainLegend@dbCloneBean@servletRequest">
              <uix:link textBinding="." disabled="true"/>
            </uix:contents>
          </uix:train>
          </uix:location> --%>
          
          <%-- Error message --%>
          <%@ include file="/database/convert/errors.jspf" %>
          
          <%-- context info --%>
          <uix:pageStatus>
           
                <uix:labeledFieldLayout width="100%">
                  <uix:messageStyledText promptBinding="SOURCE_DB@testDBMsgs" textBinding="sourceDBTarget@TestDBUI@servletRequest" styleClass="OraDataText"/>
                            <uix:messageStyledText promptBinding="SOURCE_HOST@testDBMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>
                  <uix:messageStyledText promptBinding="TESTDB_HOST@testDBMsgs" styleClass="OraDataText" textBinding="testDBHost@TestDBUI@servletRequest"/>
                            <uix:messageStyledText promptBinding="TESTDB_ORACLE_HOME@testDBMsgs" styleClass="OraDataText" textBinding="testDBOracleHome@TestDBUI@servletRequest"/>
                </uix:labeledFieldLayout>	
              
          </uix:pageStatus>
          <%-- end context info --%>

          <uix:separator/>

          <uix:stackLayout>
            <uix:contents>
              <uix:rowLayout>
                <uix:formattedText styleClass="OraInstructionText"
                  textBinding="asmPageInstruction@servletRequest"/>
              </uix:rowLayout>
              <%@ include file="/database/convert/startingPage.jspf" %>
            </uix:contents>
          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@dbMsgs" 
                name="event" shortDescBinding="CANCEL@dbMsgs" value="asmNo"/>
              <uix:submitButton name ="event"
                textBinding="asmPageYesLabel@servletRequest"
                shortDescBinding="asmPageYesLabel@servletRequest" value="asmYes"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
