<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:bundle name="cloneMsgs" class="oracle.sysman.db.rsc.clone.DBCloneCommonMsg"/>
    <uix:bundle name="loginMsgs"
                class="oracle.sysman.db.rsc.LoginResource"/>
    <uix:document> 
        
        <uix:metaContainer> 
            <uix:head titleBinding="asmLoginPageTitle@cloneMsgs"/>
        </uix:metaContainer>
        
        <uix:body>
            <db:form name="asmLoginForm" destination="/console/database/testdb" method="post" copyParams="target,type,cancelURL,oname">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/asmInstanceLogin"/>
                
                <uix:pageLayout titleBinding="ASM_LOGIN_PAGE_HEADER@cloneMsgs">
                    <%@ include file="/database/global.jspf" %>
                    
                    <%-- Error message --%>
                    <%@ include file="/database/convert/errors.jspf" %>
                    
                    <uix:stackLayout>
                        <uix:contents>
                            <uix:spacer height="10"/>
                            <%--  <%@ include file="/database/dbclone/asmInstanceLogin.jspf" %> --%>
                            <uix:labeledFieldLayout labelWidth="40%"> 
                                <uix:styledText styleClass="OraInstructionText" 
                                                textBinding="DESTINATION_HOSTNAME_PROMPT@cloneMsgs"/>
                                <uix:styledText styleClass="OraInstructionTextStrong" 
                                                textBinding="testDBHost@TestDBUI@servletRequest"/>
                                <uix:messagePrompt
                                    promptBinding="ASM_INSTANCE_NAME_PROMPT@convertBundle@servletRequest"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="asmInstance@convertBean@servletRequest"/>
                                <uix:messageTextInput id="secretSysPassword"
                                                      name="secretSysPassword"
                                                      secret="true"
                                                      noAutoComplete="true"
                                                      promptBinding="SYS_PASSWORD_PROMPT@convertBundle@servletRequest"
                                                      textBinding="secretSysPassword@convertBean@servletRequest"
                                                      columns="40" 
                                                      messageBinding="(SYS_PASSWORD_PROMPT@convertBundle@servletRequest)@messages@servletRequest"
                                                      messageTypeBinding="(SYS_PASSWORD_PROMPT@convertBundle@servletRequest)@messageTypes@servletRequest"
                                                      required="uiOnly"/>
                                <%--
      <uix:styledText text=""/>
      <uix:checkBox name="saveAsmPrefCreds"
        checkedBinding="saveAsmPrefCreds@convertBean@servletRequest"
        renderedBinding="isAsmNotConnected@convertBean@servletRequest"
        textBinding="prefCheck@loginMsgs"
        value="true"/>
      --%>

                            </uix:labeledFieldLayout>
                        </uix:contents>
                    </uix:stackLayout>
                    
                    <uix:contentFooter>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="CANCEL@dbMsgs" 
                                              name="event" value="warningNo" shortDescBinding="CANCEL@dbMsgs"/>
                            <uix:submitButton name ="event"
                                              textBinding="asmPageYesLabel@servletRequest" shortDescBinding="asmPageYesLabel@servletRequest" 
                                              value="asmLogin"/>
                        </uix:pageButtonBar>
                    </uix:contentFooter>
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document> 
</uix:renderingContext>
