<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>

            <uix:body>
            <db:form name="backupAndTimeOptions" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/backupAndTimeOptions"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        
                        <uix:labeledFieldLayout width="70%">
                            <uix:contents>
                                <uix:messageStyledText promptBinding="SOURCE_DB@testDBMsgs" textBinding="sourceDBTarget@TestDBUI@servletRequest" styleClass="OraDataText"/>
                                <uix:messageStyledText promptBinding="SOURCE_HOST@testDBMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>

                            </uix:contents>
                        </uix:labeledFieldLayout>
                        <uix:separator/>
                        <uix:switcher childNameBinding="useRC@recCatalog@TestDBUI@servletRequest">
                        <uix:case name="true">
                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="REC_CAT_CREDS_INSTR@testDBMsgs"/>
</uix:case>
                                <uix:case name="false">
                                    
                                <uix:messagePrompt messageType="info" promptBinding="REC_CAT_NOT_CONFIGURED@testDBMsgs"/>
                                
                                </uix:case>
                            </uix:switcher>
<spacer height="20" width="10"/>
                            <uix:link shortDescBinding="REC_CAT_SETTINGS@testDBMsgs" textBinding="REC_CAT_SETTINGS@testDBMsgs" destinationBinding="recCatSettingsLink@servletRequest"/>
                        <uix:header textBinding="PITR@testDBMsgs">
                            <uix:contents>
                                <uix:switcher childNameBinding="archiveLogMode@TestDBUI@servletRequest">
                                    <uix:case name="true">
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="PITR_INSTR@testDBMsgs"/>
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="PITR_INSTR_NON_ARCH@testDBMsgs"/>
                                    </uix:case>
                                </uix:switcher>
                                <uix:tableLayout>
                                    <uix:contents>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:messageRadioSet name="pitrType" selectedValueBinding="pitrType@TestDBUI@servletRequest">
                                                    <uix:contents>
                                                        <uix:option shortDescBinding="LATEST@testDBMsgs" textBinding="LATEST@testDBMsgs"  value="0"/>
                                                        <uix:option shortDescBinding="DATE_TIME@testDBMsgs" textBinding="DATE_TIME@testDBMsgs"  value="1"/>
                                                        <uix:tableLayout>
                                                            <uix:contents>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="20"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left" vAlign="top">
                                                                            <uix:contents>
                                                                                <uix:tableLayout>
                                                                                    <uix:contents>
                                                                                        <uix:rowLayout>
                                                                                            <uix:contents>
                                                                                                <uix:cellFormat hAlign="right">
                                                                                                    <uix:contents>
                                                                                                        <uix:messageStyledText promptBinding="DATE@testDBMsgs" styleClass="OraInstructionText" labeledNodeId="pitrDateString"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                                <uix:cellFormat>
                                                                                                    <uix:contents>
                                                                                                        <uix:spacer height="10" width="10"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                                <uix:cellFormat>
                                                                                                    <uix:contents>
                                                                                                        <uix:messageDateField shortDescBinding="DATE@testDBMsgs" tipBinding="pitrStartTimeTip@TestDBUI@servletRequest" name="pitrDateString" valueBinding="pitrDateString@TestDBUI@servletRequest" id="pitrDateString">
                                                                                                            <uix:onSubmitValidater>
                                                                                                                <uix:date dateStyle="medium"/>
                                                                                                            </uix:onSubmitValidater> 
                                                                                                        </uix:messageDateField>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                            </uix:contents>
                                                                                        </uix:rowLayout>
                                                                                        <uix:rowLayout>
                                                                                            <uix:contents>
                                                                                                <uix:cellFormat hAlign="right">
                                                                                                    <uix:contents>
                                                                                                        <uix:messageStyledText promptBinding="TIME@testDBMsgs" styleClass="OraInstructionText"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                                <uix:cellFormat>
                                                                                                    <uix:contents>
                                                                                                        <uix:spacer height="10" width="10"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                                <uix:cellFormat>
                                                                                                    <uix:contents>
                                                                                                        <uix:rowLayout>
                                                                                                            <uix:contents>
                                                                                                                <uix:messageChoice name="pitrHour" shortDescBinding="HOUR@testDBMsgs"  
                                                                                                                                   selectedValueBinding="pitrHour@TestDBUI@servletRequest">
                                                                                                                    <uix:contents>
                                                                                                                        <uix:option text="12" value="0"/>
                                                                                                                        <uix:option text="1" value="1"/>
                                                                                                                        <uix:option text="2" value="2"/>
                                                                                                                        <uix:option text="3" value="3"/>
                                                                                                                        <uix:option text="4" value="4"/>
                                                                                                                        <uix:option text="5" value="5"/>
                                                                                                                        <uix:option text="6" value="6"/>
                                                                                                                        <uix:option text="7" value="7"/>
                                                                                                                        <uix:option text="8" value="8"/>
                                                                                                                        <uix:option text="9" value="9"/>
                                                                                                                        <uix:option text="10" value="10"/>
                                                                                                                        <uix:option text="11" value="11"/>
                                                                                                                        
                                                                                                                        
                                                                                                                    </uix:contents>
                                                                                                                </uix:messageChoice>
                                                                                                                <uix:messageChoice name="pitrMin" 
 shortDescBinding="MINUTES@testDBMsgs"                                                                                                                                    selectedValueBinding="pitrMin@TestDBUI@servletRequest">
                                                                                                                    <uix:contents>
                                                                                                                        <uix:option text="00" value="0"/>
                                                                                                                        <uix:option text="01" value="1"/>
                                                                                                                        <uix:option text="02" value="2"/>
                                                                                                                        <uix:option text="03" value="3"/>
                                                                                                                        <uix:option text="04" value="4"/>
                                                                                                                        <uix:option text="05" value="5"/>
                                                                                                                        <uix:option text="06" value="6"/>
                                                                                                                        <uix:option text="07" value="7"/>
                                                                                                                        <uix:option text="08" value="8"/>
                                                                                                                        <uix:option text="09" value="9"/>
                                                                                                                        <uix:option text="10" value="10"/>
                                                                                                                        <uix:option text="11" value="11"/>
                                                                                                                        <uix:option text="12" value="12"/>
                                                                                                                        <uix:option text="13" value="13"/>
                                                                                                                        <uix:option text="14" value="14"/>
                                                                                                                        <uix:option text="15" value="15"/>
                                                                                                                        <uix:option text="16" value="16"/>
                                                                                                                        <uix:option text="17" value="17"/>
                                                                                                                        <uix:option text="18" value="18"/>
                                                                                                                        <uix:option text="19" value="19"/>
                                                                                                                        <uix:option text="20" value="20"/>
                                                                                                                        <uix:option text="21" value="21"/>
                                                                                                                        <uix:option text="22" value="22"/>
                                                                                                                        <uix:option text="23" value="23"/>
                                                                                                                        <uix:option text="24" value="24"/>
                                                                                                                        <uix:option text="25" value="25"/>
                                                                                                                        <uix:option text="26" value="26"/>
                                                                                                                        <uix:option text="27" value="27"/>
                                                                                                                        <uix:option text="28" value="28"/>
                                                                                                                        <uix:option text="29" value="29"/>
                                                                                                                        <uix:option text="30" value="30"/>
                                                                                                                        <uix:option text="31" value="31"/>
                                                                                                                        <uix:option text="32" value="32"/>
                                                                                                                        <uix:option text="33" value="33"/>
                                                                                                                        <uix:option text="34" value="34"/>
                                                                                                                        <uix:option text="35" value="35"/>
                                                                                                                        <uix:option text="36" value="36"/>
                                                                                                                        <uix:option text="37" value="37"/>
                                                                                                                        <uix:option text="38" value="38"/>
                                                                                                                        <uix:option text="39" value="39"/>
                                                                                                                        <uix:option text="40" value="40"/>
                                                                                                                        <uix:option text="41" value="41"/>
                                                                                                                        <uix:option text="42" value="42"/>
                                                                                                                        <uix:option text="43" value="43"/>
                                                                                                                        <uix:option text="44" value="44"/>
                                                                                                                        <uix:option text="45" value="45"/>
                                                                                                                        <uix:option text="46" value="46"/>
                                                                                                                        <uix:option text="47" value="47"/>
                                                                                                                        <uix:option text="48" value="48"/>
                                                                                                                        <uix:option text="49" value="49"/>
                                                                                                                        <uix:option text="50" value="50"/>
                                                                                                                        <uix:option text="51" value="51"/>
                                                                                                                        <uix:option text="52" value="52"/>
                                                                                                                        <uix:option text="53" value="53"/>
                                                                                                                        <uix:option text="54" value="54"/>
                                                                                                                        <uix:option text="55" value="55"/>
                                                                                                                        <uix:option text="56" value="56"/>
                                                                                                                        <uix:option text="57" value="57"/>
                                                                                                                        <uix:option text="58" value="58"/>
                                                                                                                        <uix:option text="59" value="59"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:messageChoice>
                                                                                                                <uix:messageRadioButton name="pitrTimeAM" shortDescBinding="AM@testDBMsgs" textBinding="AM@testDBMsgs" 
                                                                                                                                        selectedBinding="pitrTimeAM@TestDBUI@servletRequest" value="true"/>
                                                                                                                <uix:messageRadioButton name="pitrTimeAM" shortDescBinding="PM@testDBMsgs" textBinding="PM@testDBMsgs"
                                                                                                                                        selectedBinding="pitrTimePM@TestDBUI@servletRequest" value="false"/>
                                                                                                            </uix:contents>
                                                                                                        </uix:rowLayout>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                            </uix:contents>
                                                                                        </uix:rowLayout>
                                                                                        <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                                        <uix:rowLayout>
                                                                                            <uix:contents>
                                                                                                <uix:cellFormat hAlign="right">
                                                                                                    <uix:contents>
                                                                                                        <uix:messageStyledText promptBinding="TIMEZONE@testDBMsgs" styleClass="OraInstructionText"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                                <uix:cellFormat>
                                                                                                    <uix:contents>
                                                                                                        <uix:spacer height="10" width="10"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                                <uix:cellFormat hAlign="left">
                                                                                                    <uix:contents>
                                                                                                        <uix:messageStyledText promptBinding="pitrTimeZone@TestDBUI@servletRequest" styleClass="OraDataText"/>
                                                                                                    </uix:contents>
                                                                                                </uix:cellFormat>
                                                                                            </uix:contents>
                                                                                        </uix:rowLayout>
                                                                                        <uix:rowLayout >
                                                                                               <uix:cellFormat/>
                                                                                               <uix:cellFormat/>
                                                                                               
                                                                                               <uix:cellFormat>
                                                                                                   <uix:contents>
                                                                                                       <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="SRC_TIMEZONE_HINT@testDBMsgs"/>
                                                                                                   </uix:contents>
                                                                                               </uix:cellFormat>
                                     
                                                                
                                                                                           </uix:rowLayout>
                                                                                    </uix:contents>
                                                                                </uix:tableLayout>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                        <uix:option textBinding="SCN@testDBMsgs"  value="2"/>
                                                        <uix:tableLayout>
                                                            <uix:contents>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="20"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left" vAlign="top">
                                                                            <uix:contents>
                                                                                <uix:messageTextInput shortDescBinding="SCN@testDBMsgs" columns="15" name="pitrScn" rows="1" textBinding="pitrScn@TestDBUI@servletRequest"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                    </uix:contents>
                                                </uix:messageRadioSet>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                            </uix:contents>
                        </uix:header>
                                   
                        <uix:hideShowHeader id="encryption"  textBinding="ENCRYPTION@testDBMsgs" disclosedBinding="encryptionState@servletRequest" formSubmitted="true" partialRenderMode="self">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="ENCRYPTION_INSTR@testDBMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:messageRadioSet name="encryptionType" selectedValueBinding="encryptionType@TestDBUI@servletRequest" shortDescBinding="ENCRYPT_MODE@testDBMsgs" promptBinding="ENCRYPT_MODE@testDBMsgs" tipBinding="ENCRYPT_MODE_TIP@testDBMsgs">
                            <uix:contents>
                            <uix:option shortDescBinding="NONE@testDBMsgs" textBinding="NONE@testDBMsgs" value="0"/>
                            <uix:option shortDescBinding="WALLET_ENCRYPT@testDBMsgs" textBinding="WALLET_ENCRYPT@testDBMsgs" value="1"/>
                            <uix:option shortDescBinding="PASSWORD_ENCRYPT@testDBMsgs"  textBinding="PASSWORD_ENCRYPT@testDBMsgs" value="2"/>
                            <uix:rowLayout>
                            <uix:contents>
                            <uix:cellFormat/>
                                <uix:cellFormat>
                                <uix:contents>
                                    <uix:labeledFieldLayout width="70%">
                                        <uix:contents>
                                            <uix:messageTextInput columns="15" name="encryptPassword" textBinding="encryptPassword@TestDBUI@servletRequest" shortDescBinding="PASSWORD@testDBMsgs" promptBinding="PASSWORD@testDBMsgs" required="no" secret="true" noAutoComplete="true"/>
                                            <uix:messageTextInput columns="15" name="confEncryptPassword" textBinding="confEncryptPassword@TestDBUI@servletRequest" shortDescBinding="CONFIRM_PASSWORD@testDBMsgs" promptBinding="CONFIRM_PASSWORD@testDBMsgs" required="no" secret="true" noAutoComplete="true"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                            </uix:rowLayout>
                            </uix:contents>
                            </uix:messageRadioSet>
                          </uix:contents>
                       
                        </uix:hideShowHeader>
                        <uix:hideShowHeader id="tapeSettings"  textBinding="TAPE_SETTINGS@testDBMsgs" disclosedBinding="tapeSettingsState@servletRequest" formSubmitted="true" partialRenderMode="self">
                            <uix:contents>
                                
                                    
                                        <uix:messageStyledText textBinding="TAPE_SETTINGS_INSTR@testDBMsgs" styleClass="OraInstructionText"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:messageTextInput name="tapeSettings" columns="60" shortDescBinding="PARAMETERS@testDBMsgs" promptBinding="PARAMETERS@testDBMsgs" textBinding="tapeSettings@TestDBUI@servletRequest" rows="5"/>
                                    
                                
                            </uix:contents> 
                        </uix:hideShowHeader>
                      </uix:contents>
                    
                    
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="6" formSubmitted="true" value="1"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="1">
                          
                          <uix:contents>
                            <uix:link shortDescBinding="BACKUP_TIME_SETTINGS@testDBMsgs" textBinding="BACKUP_TIME_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="SELECT_DEST@testDBMsgs" textBinding="SELECT_DEST@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_CONFIG_SETTINGS@testDBMsgs" textBinding="DEST_CONFIG_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_STORAGE_OPTIONS@testDBMsgs" textBinding="DEST_STORAGE_OPTIONS@testDBMsgs"/>
                            <uix:link shortDescBinding="SCHEDULE@testDBMsgs" textBinding="SCHEDULE@testDBMsgs"/>
                            <uix:link shortDescBinding="REVIEW@testDBMsgs" textBinding="REVIEW@testDBMsgs"/>
                          </uix:contents>
                        
                        </uix:train>
                      </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
