<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="confirmation" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/confirmation"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout messageType="info">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                                    errorTableBinding="info@servletRequest"
                                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                                    errorTableBinding="errors@servletRequest"
                                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        <uix:spacer height="10" width="10" />
                        <uix:tableLayout width="62%"  >
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:labeledFieldLayout>
                                                    <uix:contents>
                                                        <uix:link textBinding="EXEC_ID@servletRequest" destinationBinding="jobStatusDest@servletRequest"/>
                                                    </uix:contents>
                                                </uix:labeledFieldLayout>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout> 
                    </uix:contents>             
                    
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:button shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" destinationBinding="cancelURL@servletRequest" /> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:pageStatus>
                        <uix:messageStyledText textBinding="JOB_SUBMIT_SUC@testDBMsgs" styleClass="OraDataText"/>
                    </uix:pageStatus>
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
        
    </uix:document>
</uix:renderingContext>
