<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  <uix:metaContainer>
   
            <uix:head titleBinding="title@servletRequest"/>

      
       
    </uix:metaContainer>
    <uix:body>

   <db:form name="customStorage" method="post" 
            destination="/console/database/testdb"
            copyParams="target,type">
         <uix:formValue name="pageName" value="/database/rec/config/testdb/customStoragePage"/>
         
         <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                            <uix:contents>
                              <uix:header textBinding="DIR_OBJS@testDBMsgs">
                            <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="DIR_OBJS_INSTR@testDBMsgs"/>
                                <uix:spacer width="10" height="20"/>
                             <uix:dataScope currentDataBinding="dirObjsList@servletRequest">
            
	        
                    <uix:table name="dirObjsList" 
                                                alternateTextBinding="dirObjsAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
						summaryBinding="dirObjsSummary">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="DIR_NAME@testDBMsgs" sortable="false"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="dir_name"/>
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SRC_DIR_PATH@testDBMsgs" sortable="false"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="src_dir_value" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="DEST_DIR_PATH@testDBMsgs" sortable="false"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:messageTextInput textBinding="dest_dir_value" name="dest_dir_value" columns="70" shortDescBinding="dest_dir_value"/>
                                                </uix:column>
                                                <uix:tableSelection>
                                                
                                            </uix:tableSelection>
                                                </uix:table>
	             
	        </uix:dataScope> 
	        
                    
	        
                            </uix:contents>
                        </uix:header>  
                                <uix:header textBinding="BACKUP_MAPPING@testDBMsgs" renderedBinding="diffHost@servletRequest">
                                    <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="BACKUP_MAPPING_INSTR@testDBMsgs"/>
                                        <uix:spacer width="10" height="20"/>
                                        <uix:dataScope currentDataBinding="backupMappingList@servletRequest">
                                            
                                            
                                            <uix:table name="backupMappingList" 
                                                       alternateTextBinding="backupMapAlterText"
                                                       formSubmitted="true"
                                                       width="100%"
                                                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                       minValue="1"
                                                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                       summaryBinding="backupMapSummary">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                   
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:sortableHeader textBinding="SOURCE_BACKUP_PATH@testDBMsgs" sortable="false"/>
                                                    </uix:columnHeader> 
                                                    <uix:columnFormat columnDataFormat="textFormat" />
                                                    <uix:text textBinding="sourcePath" />
                                                </uix:column>
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:sortableHeader textBinding="DEST_BACKUP_PATH@testDBMsgs" sortable="false"/>
                                                    </uix:columnHeader> 
                                                    <uix:columnFormat columnDataFormat="textFormat" />
                                                    <uix:messageTextInput textBinding="destPath" name="destPath" columns="70" shortDescBinding="destPath"/>
                                                </uix:column>
                                              <%--  <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:sortableHeader  textBinding="INCLUDE_BACKUP@testDBMsgs"/>
                                                    </uix:columnHeader> 
                                                    <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                                    <uix:messageCheckBox name="includeBackup" checkedBinding="includeBackup" shortDescBinding="INCLUDE_BACKUP@testDBMsgs"/>
                                                </uix:column>
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:sortableHeader  textBinding="TRANSFER_BACKUP@testDBMsgs"/>
                                                    </uix:columnHeader> 
                                                    <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                                    <uix:messageCheckBox name="transferBackup" checkedBinding="transferBackup" shortDescBinding="TRANSFER_BACKUP@testDBMsgs"/>
                                                </uix:column> --%>
                                                <uix:tableSelection>
                                                    
                                                </uix:tableSelection>
                                            </uix:table>
                                            
                                        </uix:dataScope> 
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:tip>
                                                            <uix:contents>
                                                                <uix:formattedText textBinding="BACKUP_MAP_TIP@testDBMsgs"/>
                                                            </uix:contents>
                                                        </uix:tip>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        
                                        
                                    </uix:contents>
                                </uix:header>
                            </uix:contents>
                            <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:submitButton textBinding="OK@dbMsgs" name="event" shortDescBinding="OK@dbMsgs" value="applyCustomParams" />  
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:pageStatus>

                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="CUSTOM_STORAGE_INSTR@testDBMsgs"/>
   
                    </uix:pageStatus>
                    
                        </uix:pageLayout>
         </db:form>

   </uix:body>
  
</uix:document>
 </uix:renderingContext>
