<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:bundle name="dbcloneMsgs" class="oracle.sysman.db.rsc.clone.DBCloneCommonMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <script>
        function startMemParamsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        function startFilteredParamsLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:800, height:700},true, 'dialog','');
        }
        function startListenersLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        function lovCallBack(data)
        {
            if ((i=data.indexOf(':')) > 0)
            {
                
                    document.forms[0].listenerName.value=data.substring(0,i);
                    s = data.substring(i+1, data.length);
                    document.forms[0].listenerPort.value=s;
            }
        }
        function setLovName(name)
        {
            document.forms[0].lovName.value = name;
        }
      function enableComponentsOnCheck()
        {
            
            var chkVal = document.destConfSettings.executePostCloneScript.checked;
            var radVal0 = document.destConfSettings.postCloneScriptType[0].checked;
            var radVal1 = document.destConfSettings.postCloneScriptType[1].checked;
    
            if (chkVal)
            {        
                document.destConfSettings.postCloneScriptType[0].disabled=false;
                document.destConfSettings.postCloneScriptType[1].disabled=false;
                document.destConfSettings.postCloneScriptFile.readOnly=false;
                document.destConfSettings.postCloneScript.readOnly=false;
            }
            else
            {
                document.destConfSettings.postCloneScriptFile.readOnly=true;
                document.destConfSettings.postCloneScript.readOnly=true;
                document.destConfSettings.postCloneScriptType[0].disabled=true;
                document.destConfSettings.postCloneScriptType[1].disabled=true;
            }
        
        
        }
        function disableComponents()
        {

            var chkVal = document.destConfSettings.executePostCloneScript.checked;
            var radVal0 = document.destConfSettings.postCloneScriptType[0].checked;
            var radVal1 = document.destConfSettings.postCloneScriptType[1].checked;
            
  
            if (chkVal)
            {
                if (radVal0)
                {
                    document.destConfSettings.postCloneScript.readOnly=true;
                    document.destConfSettings.postCloneScriptFile.readOnly=false;
                }
                else if (radVal1)
                {
                    document.destConfSettings.postCloneScriptFile.readOnly=true;
                    document.destConfSettings.postCloneScript.readOnly=false;
                }
            }
        }
        function onLoadSettings()
        { 
            var explicitMemMgmtFocus = <%= request.getAttribute("explicitMemMgmtFocus") %>;
            var chkVal = document.destConfSettings.executePostCloneScript.checked;
            if (chkVal)
            {        
                document.destConfSettings.postCloneScriptType[0].disabled=false;
                document.destConfSettings.postCloneScriptType[1].disabled=false;
                document.destConfSettings.postCloneScriptFile.readOnly=false;
                document.destConfSettings.postCloneScript.readOnly=false;
            }
            else
            {
                document.destConfSettings.postCloneScriptFile.readOnly=true;
                document.destConfSettings.postCloneScript.readOnly=true;
                document.destConfSettings.postCloneScriptType[0].disabled=true;
                document.destConfSettings.postCloneScriptType[1].disabled=true;
            }
	    if (explicitMemMgmtFocus)
            {
		document.destConfSettings.explicitMemoryMgmtType.focus();	
	    }		
	    
        }

        </script>
        <uix:body onLoad="onLoadSettings();">
            <db:form name="destConfSettings" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/destConfigurationSettings"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="lovName"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:labeledFieldLayout width="70%">
                          <uix:contents>
                            <uix:messageStyledText promptBinding="SOURCE_DB@testDBMsgs" textBinding="sourceDBTarget@TestDBUI@servletRequest" styleClass="OraDataText"/>
                            <uix:messageStyledText promptBinding="SOURCE_HOST@testDBMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>
                            <uix:messageStyledText promptBinding="TESTDB_HOST@testDBMsgs" styleClass="OraDataText" textBinding="testDBHost@TestDBUI@servletRequest"/>
                            <uix:messageStyledText promptBinding="TESTDB_ORACLE_HOME@testDBMsgs" styleClass="OraDataText" textBinding="testDBOracleHome@TestDBUI@servletRequest"/>
                          </uix:contents>
                        </uix:labeledFieldLayout>
                        <uix:separator/>
                        
                        
                     
                        
                            <uix:header textBinding="MEM_PARAMS@testDBMsgs">
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="MEM_PARAMS_INSTR@testDBMsgs"/>
                                <uix:spacer height="10" width="10"/>
                                <uix:messageRadioSet name="memoryMgmtType" selectedValueBinding="memoryMgmtType@TestDBUI@servletRequest">
                                  <uix:contents>
                                    <uix:option shortDescBinding="SAMEAS_SOURCE@testDBMsgs"  textBinding="SAMEAS_SOURCE@testDBMsgs" value="0"/>
                                    <uix:tableLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer height="10" width="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:button shortDescBinding="SHOW_MEM_PARAMS@testDBMsgs" textBinding="SHOW_MEM_PARAMS@testDBMsgs" onClickBinding="lovDestForMemParams@servletRequest"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:tableLayout>
                                    <uix:option shortDescBinding="CONF_MEM_MGMT@testDBMsgs" textBinding="CONF_MEM_MGMT@testDBMsgs" value="1"/>
                                    <uix:tableLayout>
                                      <uix:contents>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer height="10" width="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat/>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer height="10" width="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:messageChoice onChange="submitForm('destConfSettings', true, {event:'explicitMemMgmtChanged'})" name="explicitMemoryMgmtType" selectedValueBinding="explicitMemoryMgmtType@TestDBUI@servletRequest" shortDescBinding="CONF_MEM_MGMT@testDBMsgs">
                                                  <uix:contents>
                                                    <uix:option shortDescBinding="AUTO_MEM_MGMT@testDBMsgs" textBinding="AUTO_MEM_MGMT@testDBMsgs" value="0" renderedBinding="dbVersion11@servletRequest"/>
                                                    <uix:option shortDescBinding="AUTO_SHARED_MEM_MGMT@testDBMsgs" textBinding="AUTO_SHARED_MEM_MGMT@testDBMsgs" value="1"/>
                                                  </uix:contents>
                                                </uix:messageChoice>
                                                <uix:spacer height="10" width="10"/>
                                                <uix:switcher childNameBinding="explicitMemoryMgmtType@TestDBUI@servletRequest">
                                                    <uix:case name="0">
                                                        <uix:stackLayout>
                                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="AUTO_MEM_MGMT_INSTR@testDBMsgs"/>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:labeledFieldLayout>
                                                            <uix:contents>
                                                                <uix:messageTextInput columns="15" name="totalMemory" textBinding="totalMemoryAsString@TestDBUI@servletRequest" shortDescBinding="TOTAL_MEM_SIZE@testDBMsgs" promptBinding="TOTAL_MEM_SIZE@testDBMsgs" required="uiOnly" />
                                                               <%-- <uix:messageTextInput columns="15" tipBinding="MAX_MEM_SIZE_TIP@testDBMsgs" name="maxMemory" textBinding="maxMemoryAsString@TestDBUI@servletRequest" promptBinding="MAX_MEM_SIZE@testDBMsgs"/> --%>
                                                                
                                                            </uix:contents>
                                                        </uix:labeledFieldLayout>
                                                        </uix:stackLayout>
                                                    </uix:case>
                                                    <uix:case name="1">
                                                        <uix:stackLayout>
                                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="AUTO_SHARED_MEM_MGMT_INSTR@testDBMsgs"/>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:labeledFieldLayout>
                                                            <uix:contents>
                                                                <uix:messageTextInput columns="15" required="uiOnly" name="totalSGAMemory" textBinding="totalSGAMemoryAsString@TestDBUI@servletRequest" shortDescBinding="TOTAL_SGA_SIZE@testDBMsgs" promptBinding="TOTAL_SGA_SIZE@testDBMsgs"/>
                                                                <uix:messageTextInput columns="15" required="uiOnly" name="pgaMemory" textBinding="pgaMemory@TestDBUI@servletRequest" shortDescBinding="AGG_PGA_TARGET@testDBMsgs" promptBinding="AGG_PGA_TARGET@testDBMsgs"/>
                                                            </uix:contents>
                                                        </uix:labeledFieldLayout>
                                                        </uix:stackLayout>
                                                    </uix:case>
                                                </uix:switcher>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:messageRadioSet>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:header>
                            <uix:header textBinding="LISTENER_CONF@testDBMsgs">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="LISTENER_CONF_INSTR@testDBMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:labeledFieldLayout>
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraDataText" textBinding="testDBTnsAdmin@TestDBUI@servletRequest" promptBinding="LISTENER_CONF_FILE_LOC@testDBMsgs" />  
                                <uix:messageLovField name="listenerName" textBinding="listenerName@TestDBUI@servletRequest" onClickBinding="lovDestForListeners@servletRequest" searchDescBinding="LISTENER_NAME@testDBMsgs"  shortDescBinding="LISTENER_NAME@testDBMsgs" promptBinding="LISTENER_NAME@testDBMsgs" tipBinding="LISTENER_LOV_HINT@testDBMsgs" columns="25" required="uiOnly" />
                                <uix:messageTextInput columns="15"  name="listenerPort" textBinding="listenerPort@TestDBUI@servletRequest" shortDescBinding="PORT@testDBMsgs" promptBinding="PORT@testDBMsgs" required="uiOnly" />
                                <uix:messageStyledText styleClass="OraDataText" textBinding="sourceDBPort@TestDBUI@servletRequest" promptBinding="SRC_DB_PORT@testDBMsgs" />
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:header>

                            <uix:header textBinding="FILTERED_PARAMS@testDBMsgs">
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="FILTERED_PARAMS_INSTR@testDBMsgs"/>
                                <uix:spacer height="10" width="10"/>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:button shortDescBinding="SHOW_FILTERED_PARAMS@testDBMsgs" textBinding="SHOW_FILTERED_PARAMS@testDBMsgs" onClickBinding="lovDestForFilteredParams@servletRequest"/>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:header>
                          
                           
                        
                        <%-- Post Clone scipts --%>
                            <uix:header textBinding="CUSTOMER_SCRIPT_HEADER@dbcloneMsgs">
                                <uix:contents>
                                    <uix:tableLayout width="100%">
                                        <uix:rowLayout>
                                            <uix:stackLayout>
                                                <uix:messageCheckBox name="executePostCloneScript" 
                                                                     textBinding="CUSTOMER_RUN_SCRIPT_PROMPT@dbcloneMsgs"
                                                                     checkedBinding="executePostCloneScript@TestDBUI@servletRequest" 
                                                                     onClick="enableComponentsOnCheck();"/>
                                            </uix:stackLayout>
                                        </uix:rowLayout>
                                    </uix:tableLayout>
                                    
                                    <uix:tableLayout width="90%" borderWidth="0">
                                        <uix:contents>
                                            <uix:rowLayout>
                                                <uix:styledText styleClass="OraInstructionText"
                                                                textBinding="CUSTOMER_SCRIPT_INSTRUCTION@dbcloneMsgs"/>
                                            </uix:rowLayout>
                                        </uix:contents>
                                    </uix:tableLayout>
                                    
                                    
                                            <%--         <uix:radioButton    --%>
                                            <uix:messageRadioSet name="postCloneScriptType" selectedValueBinding="postCloneScriptType@TestDBUI@servletRequest">
                                                <uix:contents>
                                            <uix:option
                                                shortDescBinding="CUSTOMER_SCRIPT_STORED@dbcloneMsgs" 
                                                textBinding="CUSTOMER_SCRIPT_STORED@dbcloneMsgs"
                                                value="0"/>
                                        
                                    
                                    <uix:labeledFieldLayout labelWidth="25%">
                                        <uix:contents>
                                            <uix:messageLovField id="postCloneScriptFile"                        
                                                                 name="postCloneScriptFile" 
                                                                 textBinding="postCloneScriptFile@TestDBUI@servletRequest"
                                                                 columns="60" 
                                                                 promptBinding="CUSTOMER_SCRIPT_LOV_PROMPT@dbcloneMsgs"
                                                                 shortDescBinding="CUSTOMER_SCRIPT_LOV_PROMPT@dbcloneMsgs"
                                                                 searchDescBinding="CUSTOMER_SCRIPT_LOV_PROMPT@dbcloneMsgs"
                                                                 messageBinding="CUSTOMER_SCRIPT_LOV_PROMPT@dbcloneMsgs"
                                                                 messageTypeBinding="CUSTOMER_SCRIPT_LOV_PROMPT@dbcloneMsgs"
                                                                 onClick="setLovName(document.forms[0].postCloneScriptFile.name);openWindow(window, '/em/console/page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', '');"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                    
                                    
                                            <%--         <uix:radioButton    --%>
                                            <uix:option   
                                                shortDescBinding="CUSTOMER_SCRIPT_ENTERED@dbcloneMsgs"
                                                textBinding="CUSTOMER_SCRIPT_ENTERED@dbcloneMsgs"
                                                value="1"/>
                                        
                                    
                                    <uix:labeledFieldLayout labelWidth="25%">
                                        <uix:contents>
                                            <uix:messageTextInput id="postCloneScript"
                                                                  name="postCloneScript"
                                                                  promptBinding="CUSTOMER_SCRIPT_PROMPT@dbcloneMsgs"
                                                                  textBinding="postCloneScript@TestDBUI@servletRequest"
                                                                  rows="5"
                                                                  columns="60" 
                                                                  messageBinding="CUSTOMER_SCRIPT_PROMPT@dbcloneMsgs"
                                                                  messageTypeBinding="CUSTOMER_SCRIPT_PROMPT@dbcloneMsgs"
                                            />
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                    </uix:contents>
                                    </uix:messageRadioSet>
                                </uix:contents>
                            </uix:header>
                            
                            <%-- End Post Clone Scripts --%>
                        
                    </uix:contents>
                    
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="6" formSubmitted="true" value="3"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="3">
                            <uix:contents>
                            <uix:link shortDescBinding="BACKUP_TIME_SETTINGS@testDBMsgs" textBinding="BACKUP_TIME_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="SELECT_DEST@testDBMsgs" textBinding="SELECT_DEST@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_CONFIG_SETTINGS@testDBMsgs" textBinding="DEST_CONFIG_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_STORAGE_OPTIONS@testDBMsgs" textBinding="DEST_STORAGE_OPTIONS@testDBMsgs"/>
                            <uix:link shortDescBinding="SCHEDULE@testDBMsgs" textBinding="SCHEDULE@testDBMsgs"/>
                            <uix:link shortDescBinding="REVIEW@testDBMsgs" textBinding="REVIEW@testDBMsgs"/>
                            </uix:contents>
                        </uix:train>
                    </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
        
    </uix:document>
</uix:renderingContext>



