<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.rec.TestDBMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <db:script src="/database/dbclone/remoteSelector.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        function setLovName(name)
        {
            document.forms[0].lovName.value = name;
        }
        </script>
      
        
        <uix:body>
            <db:form name="destStorageOptionsAsm" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/destStorageOptionsAsm"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="lovName"/>
                <%-- Error message --%>
                <%@ include file="/database/convert/errors.jspf" %>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    destTableBinding="msgUrls@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:labeledFieldLayout width="70%">
                            <uix:contents>
                                <uix:messageStyledText promptBinding="SOURCE_DB@testDBMsgs" textBinding="sourceDBTarget@TestDBUI@servletRequest" styleClass="OraDataText"/>
                                <uix:messageStyledText promptBinding="SOURCE_HOST@testDBMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>
                                <uix:messageStyledText promptBinding="TESTDB_HOST@testDBMsgs" styleClass="OraDataText" textBinding="testDBHost@TestDBUI@servletRequest"/>
                            <uix:messageStyledText promptBinding="TESTDB_ORACLE_HOME@testDBMsgs" styleClass="OraDataText" textBinding="testDBOracleHome@TestDBUI@servletRequest"/>
                            </uix:contents>
                        </uix:labeledFieldLayout>
                        <uix:separator/>
                                              <uix:tableLayout width="100%">
                                                  <uix:contents>
                                                      <uix:rowLayout width="100%">
                                                          <uix:contents>
                                                              <uix:cellFormat hAlign="right">
                                                                  <uix:contents>
                                                                      <uix:submitButton shortDescBinding="CUSTOMIZE_STORAGE@testDBMsgs" textBinding="CUSTOMIZE_STORAGE@testDBMsgs" name="event" value="customStorage" />
                                                                  </uix:contents>
                                                              </uix:cellFormat>
                                                          </uix:contents>
                                                      </uix:rowLayout>
                                                  </uix:contents>
                                              </uix:tableLayout>
                   
                                              <uix:header textBinding="DB_AREA@testDBMsgs">
                                    <uix:contents>
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="DB_AREA_INSTR@testDBMsgs"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:labeledFieldLayout>
                                            <uix:contents>
                                                <uix:messageStyledText promptBinding="TOTAL_DISK_SPACE_REQD@testDBMsgs" textBinding="sourceDBFilesSize@TestDBUI@servletRequest" styleClass="OraDataText" vAlign="top"/>
                                                
                                                <uix:messageLovField name="databaseStorageLoc" id="databaseStorageLoc"
                                                                     textBinding="databaseStorageLoc@TestDBUI@servletRequest" columns="50" promptBinding="LOCATION@testDBMsgs"
                                                                     shortDescBinding="LOCATION@testDBMsgs"
                                                                     searchDescBinding="LOCATION@testDBMsgs"
                                                                     onClick = "startLov('databaseStorageLoc', 'ListDiskGroup')"
                                                                     required="uiOnly"/>
                                            </uix:contents>
                                        </uix:labeledFieldLayout>
                                        <uix:spacer height="10" width="10"/>
                                        
                                        
                                    </uix:contents>
                                </uix:header>
                                <uix:header textBinding="RECOVERY_FILE_LOC@testDBMsgs" renderedBinding="showRecoveryFilesLocation@servletRequest">
                                    <uix:contents>
                                <uix:header textBinding="FLASH_REC_AREA@testDBMsgs" renderedBinding="flashRecovery@TestDBUI@servletRequest">
                                    <uix:contents>
                      
                                                <uix:stackLayout>
                                                 <%--   <uix:messageCheckBox name="flashRecovery" checkedBinding="flashRecovery@TestDBUI@servletRequest" textBinding="USE_FLASH_REC@testDBMsgs" tipBinding="USE_FLASH_REC_TIP@testDBMsgs"/> --%>
                                                    <uix:spacer height="10" width="10"/>
                                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="FLASH_REC_AREA_INSTR@testDBMsgs"/>
                                                    <uix:spacer height="10" width="10"/>
                                                    
                                                    <uix:spacer height="10" width="10"/>
                                                    <uix:labeledFieldLayout width="70%">
                                                        <uix:contents>
                                                            
                                                            <uix:messageLovField name="flashRecStorageLoc" id="flashRecStorageLoc"
                                                                     textBinding="flashRecStorageLoc@TestDBUI@servletRequest" columns="50" promptBinding="LOCATION@testDBMsgs"
                                                                     shortDescBinding="LOCATION@testDBMsgs"
                                                                     searchDescBinding="LOCATION@testDBMsgs"
                                                                     onClick = "startLov('flashRecStorageLoc', 'ListDiskGroup')"
                                                                     required="uiOnly"/>
                                                            <uix:messageTextInput columns="10" name="flashRecAreaSize" textBinding="flashRecAreaSizeAsString@TestDBUI@servletRequest" shortDescBinding="FLASH_REC_AREA_SIZE@testDBMsgs" promptBinding="FLASH_REC_AREA_SIZE@testDBMsgs"/>
                                                        </uix:contents>
                                                    </uix:labeledFieldLayout>
                                                </uix:stackLayout>
                        
                                    </uix:contents>
                                </uix:header>  
                                          
                          
                        <uix:header textBinding="ARCHIVE_LOGS@testDBMsgs" renderedBinding="archiveLogMode@TestDBUI@servletRequest">
                            <uix:contents>
                                
                                        <uix:stackLayout>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="ARCHIVE_LOGS_INSTR@testDBMsgs"/>
                                         <%--   <uix:messageCheckBox checkedBinding="archiveLogMode@TestDBUI@servletRequest" name="archiveLogMode" textBinding="ARCHIVE_LOG_MODE@testDBMsgs"/> 
                                            <uix:spacer height="10" width="10"/>
                                            <uix:messageTextInput columns="15" name="archiveLogFileFormat" promptBinding="ARCHIVE_LOG_FILENAME_FORMAT@testDBMsgs" textBinding="archiveLogFileFormat@TestDBUI@servletRequest" tipBinding="ARCHIVE_LOG_FILENAME_FORMAT_TIP@testDBMsgs" readOnly="yes"/> --%>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:tableLayout hAlign="left" width="65%">
                                                <uix:contents>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:dataScope currentDataBinding="ARCHIVE_DEST_LIST@servletRequest">
                                                                <uix:table name="ARCHIVE_DEST_LIST" 
                                                                           alternateTextBinding="archLogsAlterText"
                                                                           formSubmitted="true"
                                                                           width="100%"
                                                                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                           minValue="1"
                                                                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
									   summaryBinding="archLogsSummary">
                                                                    
                                                                    <uix:tableFormat tableBanding="rowBanding"/>
                                                                    <uix:column>
                                                                        <uix:columnHeader>
                                                                            <uix:sortableHeader textBinding="NUMBER@testDBMsgs"/>
                                                                        </uix:columnHeader> 
                                                                        <uix:columnFormat columnDataFormat="textFormat" width="5%"/>
                                                                        <uix:messageStyledText textBinding="<%= TestDBMsgID.NUMBER %>" />
                                                                    </uix:column>
                                                                    <uix:column>
                                                                        <uix:columnHeader>
                                                                            <uix:sortableHeader  textBinding="ARCHIVE_LOG_DEST@testDBMsgs"/>
                                                                        </uix:columnHeader> 
                                                                        <uix:columnFormat columnDataFormat="textFormat" width="65%"/>
                                                                        <uix:messageTextInput shortDescBinding="ARCHIVE_LOG_DEST@testDBMsgs" columns="50" name="<%= TestDBMsgID.ARCHIVE_LOG_DEST %>" textBinding="<%= TestDBMsgID.ARCHIVE_LOG_DEST %>" />
                                                                    </uix:column>
                                                                    
                                                                    
                                                                    
                                                                </uix:table>
                                                            </uix:dataScope>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                    <uix:rowLayout>
                                                        <uix:contents>
                                                            <uix:cellFormat>
                                                                <uix:contents>
                                                                    <uix:button shortDescBinding="ADD_DEST@testDBMsgs" textBinding="ADD_DEST@testDBMsgs" onClick="submitForm('destStorageOptionsAsm', true, {event:'addLogDest'})"/>
                                                                </uix:contents>
                                                            </uix:cellFormat>
                                                        </uix:contents>
                                                    </uix:rowLayout>
                                                </uix:contents>
                                            </uix:tableLayout>
                                        </uix:stackLayout>   
                                       
                            </uix:contents>
                        </uix:header>
                        </uix:contents>
                                </uix:header>
                        <uix:header textBinding="DIAG_AUD_FILE_LOC@testDBMsgs">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="DIAG_AUD_FILE_LOC_INSTR@testDBMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:labeledFieldLayout  width="60%">
                              <uix:contents>
                                <uix:messageLovField columns="50" name="diagAudFileBaseLoc" onClick="setLovName(document.forms[0].diagAudFileBaseLoc.name);openWindow(window, '/em/console/page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', '');" 
                                promptBinding="LOCATION@testDBMsgs" shortDescBinding="LOCATION@testDBMsgs" searchDescBinding="LOCATION@testDBMsgs" 
                                textBinding="diagAudFileBaseLoc@TestDBUI@servletRequest" tipBinding="DIAG_AUD_FILE_LOC_TIP@testDBMsgs"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:header textBinding="TEMP_STAGE_LOC@testDBMsgs" renderedBinding="diffHost@servletRequest">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="stageAreaMessage@TestDBUI@servletRequest"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:labeledFieldLayout  width="60%">
                              <uix:contents>
                               <uix:messageLovField columns="50" shortDescBinding="SRC_STAGE_LOCATION@testDBMsgs" searchDescBinding="SRC_STAGE_LOCATION@testDBMsgs" name="srcStageLoc" onClick="setLovName(document.forms[0].srcStageLoc.name);openWindow(window, '/em/console/page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', '');" 
                                promptBinding="SRC_STAGE_LOCATION@testDBMsgs" textBinding="srcStageLoc@TestDBUI@servletRequest"/>
<uix:messageLovField columns="50" shortDescBinding="DEST_STAGE_LOCATION@testDBMsgs" searchDescBinding="DEST_STAGE_LOCATION@testDBMsgs" name="destStageLoc" onClick="setLovName(document.forms[0].destStageLoc.name);openWindow(window, '/em/console/page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', '');" 
                                promptBinding="DEST_STAGE_LOCATION@testDBMsgs" textBinding="destStageLoc@TestDBUI@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:header>
                        <uix:spacer height="20" width="10"/>
                        
                    </uix:contents>
                    
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="6" formSubmitted="true" value="4"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="4">
                            <uix:contents>
                            <uix:link shortDescBinding="BACKUP_TIME_SETTINGS@testDBMsgs" textBinding="BACKUP_TIME_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="SELECT_DEST@testDBMsgs" textBinding="SELECT_DEST@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_CONFIG_SETTINGS@testDBMsgs" textBinding="DEST_CONFIG_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_STORAGE_OPTIONS@testDBMsgs" textBinding="DEST_STORAGE_OPTIONS@testDBMsgs"/>
                            <uix:link shortDescBinding="SCHEDULE@testDBMsgs" textBinding="SCHEDULE@testDBMsgs"/>
                            <uix:link shortDescBinding="REVIEW@testDBMsgs" textBinding="REVIEW@testDBMsgs"/>
                            </uix:contents>
                        </uix:train>
                    </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
        
    </uix:document>
</uix:renderingContext>
