<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
   
            <uix:head titleBinding="title@servletRequest"/>

      
       
    </uix:metaContainer>
    
    <uix:body>

   <db:form name="filteredSettings" method="post" 
            destination="/console/database/testdb"
            copyParams="target,type">
             <uix:formValue name="pageName" value="/database/rec/config/testdb/filteredSettings"/>
             <uix:pageLayout titleBinding="header@servletRequest">
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:header textBinding="INIT_PARAMS@testDBMsgs">
                            <uix:contents>
                             <uix:dataScope currentDataBinding="initParamsList@servletRequest">
            
	       
                    <uix:table name="initParamsList" 
                                                alternateTextBinding="filteredInitParamsAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
						summaryBinding="filteredInitParamsSummary">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NAME@dbMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="name" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ORIG_VALUE@testDBMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="origValue" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="MODIFIED_VALUE@testDBMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="modValue" />
                                                </uix:column>
                                                <uix:tableSelection>
                                                
                                            </uix:tableSelection>
                                                </uix:table>

	        </uix:dataScope>   
                            </uix:contents>
                        </uix:header>
                        <uix:spacer height="30" width="10"/>
                         <uix:header textBinding="DB_LINKS@testDBMsgs">
                            <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="DB_LINKS_REM_INSTR@testDBMsgs"/>
                                <uix:spacer height="10" width="10"/>
                             <uix:dataScope currentDataBinding="dbLinksList@servletRequest">
            
	       
                    <uix:table name="dbLinksList" 
                                                alternateTextBinding="filteredDbLinksListAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
						summaryBinding="filteredDbLinksSummary">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="SCHEMA@dbMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="owner" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NAME@dbMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="name" />
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="VALUE@dbMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="value" />
                                                </uix:column>
                                                <uix:tableSelection>
                                                
                                            </uix:tableSelection>
                                                </uix:table>

	        </uix:dataScope>   
                      </uix:contents>
                        </uix:header>
                    </uix:contents>
                    
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:button shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" onClick="javascript:self.close()" /> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                   
                </uix:pageLayout>
   </db:form>

   </uix:body>
  </uix:document>
 </uix:renderingContext>
