<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="generalConf" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/generalConf"/>
                <uix:formValue name="cancelPage" valueBinding="cancelPage@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest" messageType="confirmation">
                    <%@ include file="/database/global.jspf" %>
                    <!-- main contents -->
                    <uix:contents>
                    <uix:tableLayout hAlign="center" width="100%">
                        <uix:contents>
                        <uix:rowLayout>
                            <uix:contents>
                                <uix:cellFormat columnSpan="2" >
                                    <uix:contents>
                                        
                                                <uix:messageStyledText textBinding="confMessage@servletRequest" styleClass="OraDataText"/>
  
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>
                        </uix:contents>  
                    </uix:tableLayout>
                    </uix:contents>                   
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="NO@dbMsgs" textBinding="NO@dbMsgs" name="event" value="cancel"/>
                                <uix:submitButton shortDescBinding="YES@dbMsgs" textBinding="YES@dbMsgs" name="event" valueBinding="confEvent@servletRequest"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
      
                </uix:pageLayout>    


            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>