<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>

            <uix:body>
            <db:form name="launch" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/launch"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox
                        messageTypeBinding="error"
                        errorTableBinding="errors@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <spacer height="20" width="10"/>
                        <uix:messagePrompt messageType="info" renderedBinding="isRAC@servletRequest" promptBinding="SOURCE_TYPE_RAC_WARNING@testDBMsgs"/>
                        <spacer height="20" width="10"/>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat width="50%">
                                  <uix:contents>
                                      <uix:header textBinding="SRC_HOST_CREDS@testDBMsgs">
                                          
                                          
                                          <uix:contents>
                                              <uix:styledText styleClass="oraInstructionText" textBinding="SRC_HOST_CREDS_INSTR@testDBMsgs"/>
                                                <uix:spacer height="10" width="30"/>
                                                <uix:rowLayout>
                                                    <uix:contents>
                                                    <%@ include file="/credentials.jspf"%>
                                                    </uix:contents>
                                                </uix:rowLayout>
                                          </uix:contents>
                                      </uix:header> 
                                      
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat width="50%" vAlign="top">
                                  <uix:contents>
                                    <uix:contentContainer textBinding="OVERVIEW@testDBMsgs" width="100%">
                                      <uix:contents>
                                          <uix:styledList listStyle="circle">


                                                  <uix:contents> 
                                                      
                                                      
                                                      <uix:styledItem>
                                                          <uix:contents>
                                                              <uix:styledText styleClass="oraInstructionText" textBinding="OVERVIEW_2@testDBMsgs"/>
                                                          </uix:contents>
                                                      </uix:styledItem>
                                                      <uix:styledItem>
                                                          <uix:contents>
                                                              <uix:styledText styleClass="oraInstructionText" textBinding="OVERVIEW_3@testDBMsgs"/>
                                                          </uix:contents>
                                                      </uix:styledItem>
                                                      <uix:styledItem>
                                                          <uix:contents>
                                                              <uix:styledText styleClass="oraInstructionText" textBinding="OVERVIEW_4@testDBMsgs"/>
                                                          </uix:contents>
                                                      </uix:styledItem>
                                                      <uix:styledItem>
                                                          <uix:contents>
                                                              <uix:styledText styleClass="oraInstructionText" textBinding="OVERVIEW_5@testDBMsgs"/>
                                                          </uix:contents>
                                                      </uix:styledItem>
                                                      
                                                  </uix:contents>
                                                 
                                         
                                          </uix:styledList>
                                     
                                      </uix:contents>
                                    </uix:contentContainer>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:rowLayout>
                            <uix:contents>
                                <uix:cellFormat>
                                    <uix:contents>  
                                        <uix:link textBinding="VIEW_ALL_BKPS@testDBMsgs" destinationBinding="backupLink@servletRequest"/>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>   
                    </uix:contents>
                    
                    
                     <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:submitButton shortDescBinding="CONTINUE@dbInstMsgs" textBinding="CONTINUE@dbInstMsgs" name="event" value="continue" disabledBinding="noContinue@servletRequest"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
