<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
   <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
  <uix:document>
<uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>

    <uix:body>
        <db:form name="listBackups" destination="/console/database/testdb" method="post" copyParams="target,type">
            <uix:formValue name="pageName" value="/database/rec/config/testdb/listBackups"/>
            <uix:pageLayout titleBinding="header@servletRequest">
                <%@ include file="/database/global.jspf" %>
                
                <uix:header>
                    <uix:stackLayout>
                        <uix:textInput name="missingBackups" shortDescBinding="VIEW_BACKUPS_MISSING@testDBMsgs" textBinding="missingBackups@servletRequest" 
                                       readOnly="true" columns="100" rows="10"/>
                    </uix:stackLayout>
                </uix:header>
                
                <uix:pageButtons>
                    <uix:pageButtonBar>
                        <uix:contents>
                            <uix:submitButton textBinding="OK@dbMsgs" name="event" value="cancelListBackups"  shortDescBinding="OK@dbMsgs" />
                        </uix:contents>
                    </uix:pageButtonBar>
                </uix:pageButtons>
                <uix:pageStatus>
                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="MISSING_BACKUP_LIST_INSTR@testDBMsgs"/>
                </uix:pageStatus>
                
            </uix:pageLayout>
            
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

