<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.LovBean" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/cabo/jsLibs/TableProxy.js"/>
    <script language="javascript">

function returnSelect()
{
    lenName = "listenersList:length";
    if ((document.forms[0][lenName] != null))
    {
        selectItemValue = "";
        proxy = new TableProxy('listenersList');
    
        selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
            listenerName = "listenersList:listener_name:"+selectedIndex;
            listenerPort = "listenersList:listener_port:"+selectedIndex;
            selectItemValue = document.forms[0][listenerName].value + ":" + document.forms[0][listenerPort].value;
            if (selectItemValue == null)
                selectItemValue = "";
        }
          top.window.opener.lovCallBack(selectItemValue);
    
    }
    top.close();
}

</script>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    
    <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/LOV.js"/> 
    <db:script src="/database/utils.js"/> 
  <uix:document>

    <uix:metaContainer>
   
            <uix:head titleBinding="title@servletRequest"/>

      
       
    </uix:metaContainer>
    
    <uix:body>

   <db:form name="listenersLov" method="post" 
            destination="/console/database/testdb"
            copyParams="target,type">

              <uix:pageLayout titleBinding="header@servletRequest">
         
        <uix:formValue name="pageName" value="/database/rec/config/testdb/listenersList"/>

          <uix:tableLayout cellSpacing="2" width="80%">
         <uix:dataScope currentDataBinding="listenersList@servletRequest">
            
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <uix:table name="listenersList" 
                                                alternateTextBinding="listenersListAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
						summaryBinding="listenersListSummary">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="LISTENER_NAME@testDBMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="listener_name" />
                                                <uix:formValue name="listener_name" valueBinding="listener_name"/>
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="PORT@testDBMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="listener_port" />
                                                <uix:formValue name="listener_port" valueBinding="listener_port"/>
                                                </uix:column>
                                                <uix:tableSelection>
                                                <uix:singleSelection shortDescBinding="SELECT@dbMsgs" selectedIndex="0"/>
                                            </uix:tableSelection>
                                                </uix:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        </uix:dataScope>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" onClick="javascript:self.close()" />
            <uix:button shortDescBinding="SELECT@dbMsgs" textBinding="SELECT@dbMsgs" onClick="returnSelect()" />
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>

   </uix:body>
  </uix:document>
 </uix:renderingContext>
