<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.db.rsc.rec.TestDBMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:bundle name="cloneMsgs" class="oracle.sysman.db.rsc.clone.DBCloneCommonMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <script>
        function startMemParamsLov(lovUrl)
        {
	   lovUrl+="&amp;_em.coIFR=true&amp;no_frame=/faces/sdk/nonFacesWrapper";
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        function startFilteredParamsLov(lovUrl)
        {
	   lovUrl+="&amp;_em.coIFR=true&amp;no_frame=/faces/sdk/nonFacesWrapper";
           openWindow(window, lovUrl, 'lovWindow',{width:800, height:700},true, 'dialog','');
        }

        </script>
        
        <uix:body>
            <db:form name="review" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/review"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                                    errorTableBinding="info@servletRequest"
                                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                                    errorTableBinding="errors@servletRequest"
                                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:labeledFieldLayout width="70%">
                              <uix:contents>
                                <uix:messageStyledText textBinding="jobName@TestDBUI@servletRequest" promptBinding="JOB_NAME@testDBMsgs"  styleClass="OraDataText"/>
                                <uix:messageStyledText textBinding="jobDesc@TestDBUI@servletRequest" promptBinding="JOB_DESC@testDBMsgs"  styleClass="OraDataText"/>
                                <uix:messageStyledText textBinding="pitrStr@servletRequest" promptBinding="PITR@testDBMsgs"  tipBinding="PITR_TIP@testDBMsgs" styleClass="OraDataText"/>
                                <uix:switcher childNameBinding="scheduleTypeSB@scheduleBean@TestDBUI@servletRequest">
                                    <uix:case name="now">
                                        
                                            <uix:messageStyledText textBinding="IMMEDIATELY@testDBMsgs" promptBinding="SCHEDULE@testDBMsgs"  styleClass="OraDataText"/>
                                        
                                    </uix:case>
                                    <uix:case name="later">
                                        
                                            <uix:messageStyledText textBinding="jobSchedule@TestDBUI@servletRequest" promptBinding="SCHEDULE@testDBMsgs"  styleClass="OraDataText"/>
                                        
                                    </uix:case>
                                </uix:switcher>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                        <uix:header textBinding="DETAILS@testDBMsgs">
                            <uix:tableLayout width="100%">
                                <uix:contents>
                                    <uix:rowLayout width="100%">
                                        <uix:contents>
                                            <uix:cellFormat width="50%">
                                                <uix:contents>
                                                    <uix:header textBinding="SOURCE_DB@testDBMsgs">
                                                        <uix:labeledFieldLayout>
                                                            <uix:contents>
                                                                <uix:messageStyledText promptBinding="GLOBAL_DB_NAME_PROMPT@cloneMsgs" textBinding="sourceGlobalDBName@TestDBUI@servletRequest" styleClass="OraDataText"/>
                                                                <uix:messageStyledText promptBinding="SID_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="sourceDBInstName@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="DB_VERSION_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="sourceDBVersion@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="ORACLE_HOME_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="sourceDBOraHome@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="HOST_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>
                                                                <%--  <uix:messagePrompt promptBinding="OS_TYPE_PROMPT@cloneMsgs"/>
                                                                <uix:flowLayout>
                                                                    <uix:styledText styleClass="OraDataText" 
                                                                                    textBinding="sourceCompatibleOSType@TestDBUI@servletRequest"/>
                                                                    <uix:spacer width="5"/>
                                                                    <uix:styledText styleClass="OraDataText" 
                                                                                    textBinding="sourceCompatibleOSVersion@TestDBUI@servletRequest"/>
                                                                </uix:flowLayout> --%>
                                                                <uix:messageStyledText promptBinding="HOST_USERNAME@cloneMsgs" styleClass="OraDataText" textBinding="sourceHostJobUserName@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="DATABASE_REGISTER_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="srcDBTarget@servletRequest"/>
                                                            </uix:contents>
                                                        </uix:labeledFieldLayout>
                                                    </uix:header>
                                                </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat width="50%">
                                                <uix:contents>
                                                    <uix:header textBinding="REVIEW_DESTINATION_HEADER@cloneMsgs">
                                                        <uix:labeledFieldLayout>
                                                            <uix:contents>
                                                                <uix:messageStyledText promptBinding="GLOBAL_DB_NAME_PROMPT@cloneMsgs" textBinding="testGlobalDbName@TestDBUI@servletRequest" styleClass="OraDataText"/>
                                                                <uix:messageStyledText promptBinding="SID_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="testDbInstName@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="COL_ORACLE_SERVER_VER@cloneMsgs" styleClass="OraDataText" textBinding="destOraHomeVersion@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="ORACLE_HOME_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="testDBOracleHome@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="HOST_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="testDBHost@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="HOST_USERNAME@cloneMsgs" styleClass="OraDataText" textBinding="destHostJobUserName@TestDBUI@servletRequest"/>
                                                                <uix:messageStyledText promptBinding="DATABASE_REGISTER_PROMPT@cloneMsgs" styleClass="OraDataText" textBinding="testDbInstName@TestDBUI@servletRequest"/>
                                                            </uix:contents>
                                                        </uix:labeledFieldLayout>
                                                    </uix:header>
                                                </uix:contents>   
                                            </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout width="100%">
                                                <uix:contents>
                                                    <uix:cellFormat columnSpan="2">
                                                  <uix:contents>
                                                    <uix:hideShowHeader id="dbSettings"  textBinding="DEST_CONFIG_SETTINGS@testDBMsgs" disclosedBinding="dbSettings@servletRequest" formSubmitted="true" partialRenderMode="self">
                                                        <uix:contents>
                                                            <uix:header textBinding="MEM_PARAMS@testDBMsgs">
                                                                <uix:contents>
                                                                    
                                                                    <uix:spacer height="10" width="10"/>
                                                                    <uix:switcher childNameBinding="memoryMgmtType@TestDBUI@servletRequest">
                                                                        <uix:case name="0">
                                                                            <uix:stackLayout>
                                                                                <uix:labeledFieldLayout>
                                                                                    <uix:contents>
                                                                                        <uix:messageStyledText promptBinding="MEM_MGMT_TYPE@testDBMsgs" textBinding="SAMEAS_SOURCE@testDBMsgs" styleClass="OraDataText"/>   
                                                                                    </uix:contents>
                                                                                </uix:labeledFieldLayout>
                                                                                <uix:header textBinding="PARAM_VALUES@testDBMsgs">
                                                                                    <uix:contents>
                                                                                        <uix:dataScope currentDataBinding="initParamsList@servletRequest">
                                                                                            
                                                                                            <uix:rowLayout>
                                                                                                <uix:stackLayout>
                                                                                                    <uix:table name="memParamsList" 
                                                                                                               alternateTextBinding="memParamsAlterText"
                                                                                                               formSubmitted="true"
                                                                                                               width="100%"
                                                                                                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                                               minValue="1"
                                                                                                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
           summaryBinding="memParamsSummary">
                                                                                                        <uix:tableFormat tableBanding="rowBanding"/>
                                                                                                        <uix:column>
                                                                                                            <uix:columnHeader>
                                                                                                                <uix:sortableHeader textBinding="NAME@dbMsgs" sortable="true"/>
                                                                                                            </uix:columnHeader> 
                                                                                                            <uix:columnFormat columnDataFormat="textFormat" />
                                                                                                            <uix:text textBinding="name" />
                                                                                                        </uix:column>
                                                                                                        <uix:column>
                                                                                                            <uix:columnHeader>
                                                                                                                <uix:sortableHeader textBinding="VALUE@dbMsgs" sortable="true"/>
                                                                                                            </uix:columnHeader> 
                                                                                                            <uix:columnFormat columnDataFormat="textFormat" />
                                                                                                            <uix:text textBinding="origValue" />
                                                                                                        </uix:column>
                                                                                                        <uix:tableSelection>
                                                                                                            
                                                                                                        </uix:tableSelection>
                                                                                                    </uix:table>
                                                                                                </uix:stackLayout>
                                                                                            </uix:rowLayout>
                                                                                        </uix:dataScope>
                                                                                    </uix:contents>
                                                                                </uix:header>
                                                                            </uix:stackLayout>
                                                                        </uix:case>
                                                                        <uix:case name="1">
                                                                            <uix:stackLayout>
                                                                                <uix:switcher childNameBinding="explicitMemoryMgmtType@TestDBUI@servletRequest">
                                                                                    <uix:case name="0">
                                                                                        <uix:stackLayout>
                                                                                            <uix:labeledFieldLayout>
                                                                                                <uix:contents>
                                                                                                    <uix:messageStyledText promptBinding="MEM_MGMT_TYPE@testDBMsgs" textBinding="AUTO_MEM_MGMT@testDBMsgs" styleClass="OraDataText"/>   
                                                                                                </uix:contents>
                                                                                            </uix:labeledFieldLayout>
                                                                                            <uix:header textBinding="PARAM_VALUES@testDBMsgs">
                                                                                                <uix:contents>
                                                                                                    <uix:labeledFieldLayout>
                                                                                                        <uix:contents>
                                                                                                            <uix:messageStyledText textBinding="totalMemoryAsString@TestDBUI@servletRequest" promptBinding="TOTAL_MEM_SIZE@testDBMsgs" styleClass="OraDataText"/>
                                                                                                            
                                                                                                            
                                                                                                        </uix:contents>
                                                                                                    </uix:labeledFieldLayout>
                                                                                                </uix:contents>
                                                                                            </uix:header>
                                                                                        </uix:stackLayout>
                                                                                    </uix:case>
                                                                                    <uix:case name="1">
                                                                                        <uix:stackLayout>
                                                                                            <uix:labeledFieldLayout>
                                                                                                <uix:contents>
                                                                                                    <uix:messageStyledText promptBinding="MEM_MGMT_TYPE@testDBMsgs" textBinding="AUTO_SHARED_MEM_MGMT@testDBMsgs" styleClass="OraDataText"/>   
                                                                                                </uix:contents>
                                                                                            </uix:labeledFieldLayout>
                                                                                            <uix:header textBinding="PARAM_VALUES@testDBMsgs">
                                                                                                <uix:contents>
                                                                                                    <uix:labeledFieldLayout>
                                                                                                        <uix:contents>
                                                                                                            <uix:messageStyledText textBinding="totalSGAMemoryAsString@TestDBUI@servletRequest" promptBinding="TOTAL_SGA_SIZE@testDBMsgs" styleClass="OraDataText"/>
                                                                                                            <uix:messageStyledText textBinding="pgaMemory@TestDBUI@servletRequest" promptBinding="AGG_PGA_TARGET@testDBMsgs" styleClass="OraDataText"/>
                                                                                                        </uix:contents>
                                                                                                    </uix:labeledFieldLayout>
                                                                                                </uix:contents>
                                                                                            </uix:header>
                                                                                        </uix:stackLayout>
                                                                                    </uix:case>
                                                                                </uix:switcher>
                                                                            </uix:stackLayout>
                                                                        </uix:case>
                                                                    </uix:switcher>
                                                                    
                                                                    
                                                                    <uix:spacer height="10" width="10"/>
                                                                </uix:contents>
                                                            </uix:header>
                                                            <uix:header textBinding="FILTERED_PARAMS@testDBMsgs">
                                                                <uix:contents>
                                                                    
                                                                    <uix:spacer height="10" width="10"/>
                                                                    <uix:rowLayout>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="10"/>
                                                                            <uix:button shortDescBinding="SHOW_FILTERED_PARAMS@testDBMsgs" textBinding="SHOW_FILTERED_PARAMS@testDBMsgs" onClickBinding="lovDestForFilteredParams@servletRequest"/>
                                                                        </uix:contents>
                                                                    </uix:rowLayout>
                                                                    <uix:spacer height="10" width="10"/>
                                                                </uix:contents>
                                                            </uix:header>
                                                        </uix:contents>
                                                    </uix:hideShowHeader>
                                                </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                    </uix:rowLayout>
                                            <uix:rowLayout width="100%">
                                          <uix:contents>
                                              <uix:cellFormat columnSpan="2">
                                                  <uix:contents>
                                            <uix:hideShowHeader id="dbStorage"  textBinding="DEST_STORAGE_OPTIONS@testDBMsgs" disclosedBinding="dbStorage@servletRequest" formSubmitted="true" partialRenderMode="self">
                                                <uix:contents>
                                                    <uix:switcher childNameBinding="databaseStorageType@TestDBUI@servletRequest">
                                                        <uix:case name="0">
                                                            <uix:stackLayout>
                                                                <uix:labeledFieldLayout>
                                                                    <uix:contents>
                                                                        
                                                                        <uix:switcher childNameBinding="databaseFileFormat@TestDBUI@servletRequest">
                                                                            <uix:case name="0">
                                                                                <uix:stackLayout>
                                                                                    <uix:labeledFieldLayout>
                                                                                        <uix:contents>
                                                                                            <uix:messageStyledText textBinding="FILE_SYSTEM@testDBMsgs" promptBinding="STORAGE_TYPE@testDBMsgs" styleClass="OraDataText"/>
                                                                                            <uix:messageStyledText textBinding="DEST_DB_FILE_LOC_SAMEAS_SRC@testDBMsgs" promptBinding="DB_AREA@testDBMsgs" styleClass="OraDataText"/>
                                                                                            
                                                                                        </uix:contents>
                                                                                    </uix:labeledFieldLayout> 
                                                                                </uix:stackLayout>
                                                                            </uix:case>
                                                                            <uix:case name="1">
                                                                                <uix:stackLayout>
                                                                                    <uix:labeledFieldLayout>
                                                                                        <uix:contents>
                                                                                            <uix:messageStyledText textBinding="FILE_SYSTEM@testDBMsgs" promptBinding="STORAGE_TYPE@testDBMsgs" styleClass="OraDataText"/>
                                                                                            <uix:messageStyledText textBinding="DEST_DB_FILE_LOC_OMF@testDBMsgs" promptBinding="DB_AREA@testDBMsgs" styleClass="OraDataText"/>
                                                                                            <uix:messageStyledText textBinding="databaseStorageLoc@TestDBUI@servletRequest" promptBinding="LOCATION@testDBMsgs" styleClass="OraDataText"/>
                                                                                        </uix:contents>
                                                                                    </uix:labeledFieldLayout> 
                                                                                </uix:stackLayout>
                                                                            </uix:case>
                                                                        </uix:switcher>
                                                                    </uix:contents>
                                                                </uix:labeledFieldLayout> 
                                                            </uix:stackLayout>
                                                        </uix:case>
                                                        <uix:case name="1">
                                                            <uix:stackLayout>
                                                                <uix:labeledFieldLayout>
                                                                    <uix:contents>
                                                                        <uix:messageStyledText textBinding="ASM@testDBMsgs" promptBinding="STORAGE_TYPE@testDBMsgs" styleClass="OraDataText"/>
                                                                        <uix:messageStyledText textBinding="databaseStorageLoc@TestDBUI@servletRequest" promptBinding="LOCATION@testDBMsgs" styleClass="OraDataText"/>
                                                                    </uix:contents>
                                                                </uix:labeledFieldLayout> 
                                                            </uix:stackLayout>
                                                        </uix:case>
                                                    </uix:switcher>
                                                    
                                                            <uix:header textBinding="FLASH_REC_AREA@testDBMsgs" renderedBinding="flashRecovery@TestDBUI@servletRequest">
                                                                <uix:contents>
                                                                    
                                                                    <uix:stackLayout>
                                                                        
                                                                        <uix:labeledFieldLayout width="70%">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText textBinding="flashRecStorageLoc@TestDBUI@servletRequest" promptBinding="LOCATION@testDBMsgs" styleClass="OraDataText"/>
                                                                                <uix:messageStyledText textBinding="flashRecAreaSizeAsString@TestDBUI@servletRequest" promptBinding="FLASH_REC_AREA_SIZE@testDBMsgs" styleClass="OraDataText"/>
                                                                            </uix:contents>
                                                                        </uix:labeledFieldLayout>
                                                                    </uix:stackLayout>
                                                                    
                                                                </uix:contents>
                                                            </uix:header>  
                                                            
                                                            
                                                                        <uix:header textBinding="ARCHIVE_LOGS@testDBMsgs" renderedBinding="archiveLogMode@TestDBUI@servletRequest">
                                                                            <uix:contents>
                                                                                
                                                                                <uix:stackLayout>
                                                                                    
                                                                                    <uix:spacer height="10" width="10"/>
                                                                                    <uix:tableLayout hAlign="left" width="65%">
                                                                                        <uix:contents>
                                                                                            <uix:rowLayout>
                                                                                                <uix:contents>
                                                                                                    <uix:dataScope currentDataBinding="ARCHIVE_DEST_LIST@servletRequest">
                                                                                                        <uix:table name="ARCHIVE_DEST_LIST" 
                                                                                                                   alternateTextBinding="archLogsAlterText"
                                                                                                                   formSubmitted="true"
                                                                                                                   width="100%"
                                                                                                                   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                                                   minValue="1"
                                                                                                                   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                                                   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                                                   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
               summaryBinding="archLogsSummary">
                                                                                                            
                                                                                                            <uix:tableFormat tableBanding="rowBanding"/>
                                                                                                            <uix:column>
                                                                                                                <uix:columnHeader>
                                                                                                                    <uix:sortableHeader textBinding="NUMBER@testDBMsgs"/>
                                                                                                                </uix:columnHeader> 
                                                                                                                <uix:columnFormat columnDataFormat="textFormat" width="5%"/>
                                                                                                                <uix:messageStyledText textBinding="<%= TestDBMsgID.NUMBER %>" />
                                                                                                            </uix:column>
                                                                                                            <uix:column>
                                                                                                                <uix:columnHeader>
                                                                                                                    <uix:sortableHeader  textBinding="ARCHIVE_LOG_DEST@testDBMsgs"/>
                                                                                                                </uix:columnHeader> 
                                                                                                                <uix:columnFormat columnDataFormat="textFormat" width="65%"/>
                                                                                                                <uix:messageStyledText textBinding="<%= TestDBMsgID.ARCHIVE_LOG_DEST %>" />
                                                                                                            </uix:column>
                                                                                                            
                                                                                                            
                                                                                                            
                                                                                                        </uix:table>
                                                                                                    </uix:dataScope>
                                                                                                </uix:contents>
                                                                                            </uix:rowLayout>
                                                                                            
                                                                                        </uix:contents>
                                                                                    </uix:tableLayout>
                                                                                </uix:stackLayout>
                                                                            </uix:contents>
                                                                        </uix:header>
                                                                        <uix:header textBinding="DIR_OBJS@testDBMsgs">
                                                                            <uix:contents>
                                                                                <uix:spacer width="10" height="20"/>
                                                                                <uix:dataScope currentDataBinding="dirObjsList@servletRequest">
                                                                                    
                                                                                    
                                                                                    <uix:table name="dirObjsList" 
                                                                                               alternateTextBinding="dirObjsAlterText"
                                                                                               formSubmitted="true"
                                                                                               width="100%"
                                                                                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                                                               minValue="1"
                                                                                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                                                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                                                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                                                               summaryBinding="dirObjsSummary">
                                                                                        <uix:tableFormat tableBanding="rowBanding"/>
                                                                                        <uix:column>
                                                                                            <uix:columnHeader>
                                                                                                <uix:sortableHeader textBinding="DIR_NAME@testDBMsgs" sortable="false"/>
                                                                                            </uix:columnHeader> 
                                                                                            <uix:columnFormat columnDataFormat="textFormat" />
                                                                                            <uix:text textBinding="dir_name" />
                                                                                        </uix:column>
                                                                                        <uix:column>
                                                                                            <uix:columnHeader>
                                                                                                <uix:sortableHeader textBinding="SRC_DIR_PATH@testDBMsgs" sortable="false"/>
                                                                                            </uix:columnHeader> 
                                                                                            <uix:columnFormat columnDataFormat="textFormat" />
                                                                                            <uix:text textBinding="src_dir_value" />
                                                                                        </uix:column>
                                                                                        <uix:column>
                                                                                            <uix:columnHeader>
                                                                                                <uix:sortableHeader textBinding="DEST_DIR_PATH@testDBMsgs" sortable="false"/>
                                                                                            </uix:columnHeader> 
                                                                                            <uix:columnFormat columnDataFormat="textFormat" />
                                                                                            <uix:text textBinding="dest_dir_value"/>
                                                                                        </uix:column>
                                                                                        <uix:tableSelection>
                                                                                            
                                                                                        </uix:tableSelection>
                                                                                    </uix:table>
                                                                                    
                                                                                </uix:dataScope> 
                                                                                
                                                                                
                                                                                
                                                                            </uix:contents>
                                                                        </uix:header> 
                                                                   
                                                       
                                                </uix:contents>
                                            </uix:hideShowHeader>
                                             
                                                  </uix:contents>
                                                  </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>
                                </uix:contents>
                            </uix:tableLayout>
                            
                        </uix:header>
                    </uix:contents>
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="6" formSubmitted="true" value="6"/> 
                                <uix:submitButton shortDescBinding="FINISH@dbInstMsgs" textBinding="FINISH@dbInstMsgs" name="event" value="apply" /> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="6">
                            <uix:contents>
                                <uix:link textBinding="BACKUP_TIME_SETTINGS@testDBMsgs"/>
                                <uix:link textBinding="SELECT_DEST@testDBMsgs"/>
                                <uix:link textBinding="DEST_CONFIG_SETTINGS@testDBMsgs"/>
                                <uix:link textBinding="DEST_STORAGE_OPTIONS@testDBMsgs"/>
                                <uix:link textBinding="SCHEDULE@testDBMsgs"/>
                                <uix:link textBinding="REVIEW@testDBMsgs"/>
                            </uix:contents>
                        </uix:train>
                    </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
        
    </uix:document>
</uix:renderingContext>
