<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>  
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
            <uix:body>
            <db:form name="scheduleJob" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/scheduleJob"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:labeledFieldLayout width="70%">
                          <uix:contents>
                            <uix:messageStyledText promptBinding="SOURCE_DB@testDBMsgs" textBinding="sourceDBTarget@TestDBUI@servletRequest" styleClass="OraDataText"/>
                            <uix:messageStyledText promptBinding="SOURCE_HOST@testDBMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>
                            <uix:messageStyledText promptBinding="TESTDB_HOST@testDBMsgs" styleClass="OraDataText" textBinding="testDBHost@TestDBUI@servletRequest"/>
                            <uix:messageStyledText promptBinding="TESTDB_ORACLE_HOME@testDBMsgs" styleClass="OraDataText" textBinding="testDBOracleHome@TestDBUI@servletRequest"/>
                          </uix:contents>
                        </uix:labeledFieldLayout>
                        <uix:separator/>
                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="JOB_NAME_DESC_INSTR@testDBMsgs"/>
                        <uix:header textBinding="JOB_NAME_DESC@testDBMsgs">
                          <uix:contents>
                            <uix:labeledFieldLayout width="70%">
                              <uix:contents>
                                <uix:messageTextInput name="jobName" textBinding="jobName@TestDBUI@servletRequest" promptBinding="JOB_NAME@testDBMsgs" shortDescBinding="JOB_NAME@testDBMsgs" columns="40" required="uiOnly"/>
                                <uix:messageTextInput columns="40" textBinding="jobDesc@TestDBUI@servletRequest" name="jobDesc" shortDescBinding="JOB_DESC@testDBMsgs" promptBinding="JOB_DESC@testDBMsgs"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:header>
                        
                            <%@ include file="/sdk/schedule/start.jspf"%>
                        
                      </uix:contents>
                    
                    
                     <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="6" formSubmitted="true" value="5"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="5">
                          <uix:contents>
                            <uix:link shortDescBinding="BACKUP_TIME_SETTINGS@testDBMsgs" textBinding="BACKUP_TIME_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="SELECT_DEST@testDBMsgs" textBinding="SELECT_DEST@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_CONFIG_SETTINGS@testDBMsgs" textBinding="DEST_CONFIG_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_STORAGE_OPTIONS@testDBMsgs" textBinding="DEST_STORAGE_OPTIONS@testDBMsgs"/>
                            <uix:link shortDescBinding="SCHEDULE@testDBMsgs" textBinding="SCHEDULE@testDBMsgs"/>
                            <uix:link shortDescBinding="REVIEW@testDBMsgs" textBinding="REVIEW@testDBMsgs"/>
                          </uix:contents>
                        </uix:train>
                      </uix:location>
              
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>