<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.cabo.share.config.AccessibilityMode"%>
<%@ include file="/oemNoscript.jspf" %>
<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if ((i=data.indexOf('".')) > 0)
  {
    if(destField == "testDBHost")
    {
      document.forms[0].testDBHost.value=data.substring(1,i);
      s = data.substring(i+3, data.length-1);
      document.forms[0].testDBOracleHome.value=s;
    }
  }
}
</script>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <db:script src="/database/utils.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>

            <uix:body>
            <db:form name="selectDest" method="post" destination="/console/database/testdb" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/rec/config/testdb/selectDest"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="lovDatabaseVersion" valueBinding="lovDatabaseVersion@TestDBUI@servletRequest"/>
                <uix:formValue name="lovOSType" valueBinding="lovOSType@TestDBUI@servletRequest"/>
                <uix:formValue name="lovSrcHostName" valueBinding="lovSrcHostName@TestDBUI@servletRequest"/>
                <uix:formValue name="lovSrcOracleHome" valueBinding="lovSrcOracleHome@TestDBUI@servletRequest"/>
                <uix:formValue name="lovCompatibleDbVersion" valueBinding="lovCompatibleDbVersion@TestDBUI@servletRequest"/>
                <uix:formValue name="lovCompatibleOSType" valueBinding="lovCompatibleOSType@TestDBUI@servletRequest"/>
                <uix:formValue name="lovCompatibleOSVersion" valueBinding="lovCompatibleOSVersion@TestDBUI@servletRequest"/>
                    
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox
                        messageTypeBinding="error"
                        errorTableBinding="errors@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:labeledFieldLayout>
                          <uix:contents>
                            <uix:messageStyledText promptBinding="SOURCE_DB@testDBMsgs" textBinding="sourceDBTarget@TestDBUI@servletRequest" styleClass="OraDataText"/>
                            <uix:messageStyledText promptBinding="SOURCE_HOST@testDBMsgs" styleClass="OraDataText" textBinding="sourceDBHost@TestDBUI@servletRequest"/>
                          </uix:contents>
                        </uix:labeledFieldLayout>
                        <uix:separator/>
                        <uix:header textBinding="DEST_ORACLE_HOME@testDBMsgs">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="SELECT_DESTINATION_INSTRUCTION@testDBMsgs"/>
                        <uix:labeledFieldLayout  width="60%">
                          <uix:contents>
                            <uix:messageLovField columns="30" searchDescBinding="HOST@testDBMsgs" name="testDBHost" id="testDBHost"  promptBinding="HOST@testDBMsgs" 
                                shortDescBinding="HOST@testDBMsgs" textBinding="testDBHost@TestDBUI@servletRequest" required="uiOnly"
                                onClick = "setWindowSize(800,700); useCallBack(); setBindSqlParm('lovDatabaseVersion'); 
                                setBindSqlParm('lovOSType'); setBindSqlParm('lovSrcHostName'); 
                                setBindSqlParm('lovSrcOracleHome'); setBindSqlParm('lovCompatibleDbVersion'); 
                                setBindSqlParm('lovCompatibleOSType'); setBindSqlParm('lovCompatibleOSVersion'); 
                                startLov('testDBHost', 'ListManagedHostOH')"/>
                            <uix:messageTextInput columns="30" name="testDBOracleHome" textBinding="testDBOracleHome@TestDBUI@servletRequest" 
                                promptBinding="ORACLE_HOME@testDBMsgs" shortDescBinding="ORACLE_HOME@testDBMsgs" required="uiOnly"/>
                            <uix:messageTextInput name="testOracleBase" textBinding="testOracleBase@TestDBUI@servletRequest" columns="30" 
                                tipBinding="ORACLE_BASE_TIP@testDBMsgs" promptBinding="ORACLE_BASE@testDBMsgs" shortDescBinding="ORACLE_BASE@testDBMsgs"/>   
                                
                            
                          
                          </uix:contents>
                        </uix:labeledFieldLayout>
                        </uix:contents>
                        </uix:header>
                         
                        <uix:header textBinding="DEST_HOST_CREDS@testDBMsgs">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="TESTDB_HOST_CREDS_INSTR@testDBMsgs"/>
                            <%@ include file="/credentials.jspf"%>
                          </uix:contents>
                        </uix:header>
                        
                        <uix:header textBinding="DEST_DBNAME@testDBMsgs">
                          <uix:contents>
                            <uix:spacer height="10" width="10"/>
                            <uix:labeledFieldLayout width="80%">
                              <uix:contents>
                                <uix:messageTextInput columns="30" name="testGlobalDbName" shortDescBinding="DEST_GLOBAL_DBNAME@testDBMsgs" promptBinding="DEST_GLOBAL_DBNAME@testDBMsgs" required="uiOnly" textBinding="testGlobalDbName@TestDBUI@servletRequest"/>
                                <uix:messageTextInput columns="30" name="testDbInstName" shortDescBinding="DEST_DB_INST_NAME@testDBMsgs" promptBinding="DEST_DB_INST_NAME@testDBMsgs" required="uiOnly" textBinding="testDbInstName@TestDBUI@servletRequest"/>
                                <uix:messageTextInput columns="30" name="testDbUniqueName" shortDescBinding="DEST_DB_UNIQUE_NAME@testDBMsgs" promptBinding="DEST_DB_UNIQUE_NAME@testDBMsgs" required="uiOnly" textBinding="testDbUniqueName@TestDBUI@servletRequest" tipBinding="DEST_DB_UNIQUE_NAME_HINT@testDBMsgs"/>
                                <uix:messageChoice shortDescBinding="STORAGE_TYPE@testDBMsgs" promptBinding="STORAGE_TYPE@testDBMsgs" name="databaseStorageType" selectedValueBinding="databaseStorageType@TestDBUI@servletRequest" tipBinding="ASM_HINT@testDBMsgs">
                                  <uix:contents>
                                    <uix:option shortDescBinding="FILE_SYSTEM@testDBMsgs" textBinding="FILE_SYSTEM@testDBMsgs" value="0"/>
                                    <uix:option shortDescBinding="ASM@testDBMsgs" textBinding="ASM@testDBMsgs" value="1"/>
                                  </uix:contents>
                                </uix:messageChoice>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                            
                          </uix:contents>
                        </uix:header>
   			<uix:header textBinding="PARALLELISM@testDBMsgs">
        <uix:contents>
         <uix:messageTextInput columns="5" name="parallelism" textBinding="parallelism@TestDBUI@servletRequest" 
                               promptBinding="DEGREE_OF_PARALLELISM@testDBMsgs" shortDescBinding="DEGREE_OF_PARALLELISM@testDBMsgs" tipBinding="PARALLELIZE_FILE_COPY_HINT@testDBMsgs"/>
        </uix:contents>
      </uix:header>
                      
                      </uix:contents>
                    
                    
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="6" formSubmitted="true" value="2"/> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    <uix:location>
                        <uix:train formSubmitted="true" value="2">
                          <uix:contents>
                            <uix:link shortDescBinding="BACKUP_TIME_SETTINGS@testDBMsgs" textBinding="BACKUP_TIME_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="SELECT_DEST@testDBMsgs" textBinding="SELECT_DEST@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_CONFIG_SETTINGS@testDBMsgs" textBinding="DEST_CONFIG_SETTINGS@testDBMsgs"/>
                            <uix:link shortDescBinding="DEST_STORAGE_OPTIONS@testDBMsgs" textBinding="DEST_STORAGE_OPTIONS@testDBMsgs"/>
                            <uix:link shortDescBinding="SCHEDULE@testDBMsgs" textBinding="SCHEDULE@testDBMsgs"/>
                            <uix:link shortDescBinding="REVIEW@testDBMsgs" textBinding="REVIEW@testDBMsgs"/>
                          </uix:contents>
                        </uix:train>
                      </uix:location>
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
