<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_CHOOSE_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
	<uix:labeledFieldLayout width="75%">
            <uix:styledText styleClass="OraInstructionText" textBinding="TABLE_NAME_LABEL@recoveryBundle@servletRequest" />
	    <uix:styledText styleClass="OraDataText" textBinding="evaluateTableName@defaultBean@servletRequest"/>
	</uix:labeledFieldLayout>
	<uix:contents>
            <uix:styledText styleClass="OraInstructionText" textBinding="CHOOSE_INTRO@recoveryBundle@servletRequest" />

<%-- SEARCH LABEL --%>
	    <%-- uix:header textBinding="SEARCH_LABEL@recoveryBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" --%>
<%-- MIN AND MAX --%>
	 	<%-- <uix:rowLayout>
		<oem:radioButton name="rowVersionsType" value="use_min_max"
			selectedValueBinding="rowVersionsType@defaultBean@pageContext"
			textBinding="SHOW_ALL_ROW_VERSIONS@recoveryBundle@servletRequest"
			styleClass="OraInstructionText" />
		</uix:rowLayout --%>
<%-- SCN --%>
		<%-- <uix:rowLayout>
                <uix:cellFormat hAlign="left">
		<oem:radioButton name="rowVersionsType" value="use_SCN"
			selectedValueBinding="rowVersionsType@defaultBean@pageContext"
			textBinding="SCN_LABEL@recoveryBundle@servletRequest"
			styleClass="OraInstructionText" />
		</uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		<uix:messageTextInput name="rowVersionsStartSCN" textBinding="rowVersionsStartSCN@defaultBean@pageContext" promptBinding="START_SCN@recoveryBundle@servletRequest"/>
		</uix:rowLayout>
		<uix:rowLayout>
		<uix:messageTextInput name="rowVersionsEndSCN" textBinding="rowVersionsEndSCN@defaultBean@pageContext" promptBinding="END_SCN@recoveryBundle@servletRequest"/>
		</uix:rowLayout --%>
<%-- TIMESTAMP --%>
		<%-- <uix:rowLayout>
                <uix:cellFormat hAlign="left">
		<oem:radioButton name="rowVersionsType" value="use_Timestamp"
			selectedValueBinding="rowVersionsType@defaultBean@pageContext"
			textBinding="TIMESTAMP_LABEL@recoveryBundle@servletRequest"
			styleClass="OraInstructionText" />
		</uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		<uix:tableLayout cellSpacing="5">
		<uix:rowLayout>
		<uix:cellFormat hAlign="right">
		  <uix:messagePrompt labeledNodeId="startTime" promptBinding="START_TIME@recoveryBundle@servletRequest"/>
		</uix:cellFormat>
		<uix:dateField name="rowVersionsStartDate" columns="10"
			valueBinding="rowVersionsStartDate@defaultBean@pageContext">
		<uix:onSubmitValidater>
                	<uix:date dateStyle="medium"/>
		</uix:onSubmitValidater>
                </uix:dateField>
		<oem:choice name="rowVersionsStartTimeHour" id="startTime"
			optionsBinding="flashbackTimeHours@defaultBean@pageContext"
			selectedValueBinding="rowVersionsStartTimeHour@defaultBean@pageContext"/>
	        <oem:choice name="rowVersionsStartTimeMinute"
			optionsBinding="flashbackTimeMinutes@defaultBean@pageContext"
			selectedValueBinding="rowVersionsStartTimeMinute@defaultBean@pageContext"/>
	        <oem:radioButton name="rowVersionsStartTimeAmPm" value="AM"
        	        selectedValueBinding="rowVersionsStartTimeAmPm@defaultBean@pageContext"
                	textBinding="AM_LABEL@recoveryBundle@servletRequest"
                       	styleClass="OraInstructionText" />
	        <oem:radioButton name="rowVersionsStartTimeAmPm" value="PM"
        	        selectedValueBinding="rowVersionsStartTimeAmPm@defaultBean@pageContext"
                	textBinding="PM_LABEL@recoveryBundle@servletRequest"
                        styleClass="OraInstructionText" />
		</uix:rowLayout>
		<uix:rowLayout>
		<uix:cellFormat hAlign="right">
		  <uix:messagePrompt labeledNodeId="endTime" promptBinding="END_TIME@recoveryBundle@servletRequest"/>
		</uix:cellFormat>
		<uix:dateField name="rowVersionsEndDate" columns="10"
			valueBinding="rowVersionsEndDate@defaultBean@pageContext">
		<uix:onSubmitValidater>
                	<uix:date dateStyle="medium"/>
		</uix:onSubmitValidater>
                </uix:dateField>
		<oem:choice name="rowVersionsEndTimeHour" id="endTime"
			optionsBinding="flashbackTimeHours@defaultBean@pageContext"
			selectedValueBinding="rowVersionsEndTimeHour@defaultBean@pageContext"/>
	        <oem:choice name="rowVersionsEndTimeMinute"
			optionsBinding="flashbackTimeMinutes@defaultBean@pageContext"
			selectedValueBinding="rowVersionsEndTimeMinute@defaultBean@pageContext"/>
	        <oem:radioButton name="rowVersionsEndTimeAmPm" value="AM"
        	        selectedValueBinding="rowVersionsEndTimeAmPm@defaultBean@pageContext"
                	textBinding="AM_LABEL@recoveryBundle@servletRequest"
                       	styleClass="OraInstructionText" />
	        <oem:radioButton name="rowVersionsEndTimeAmPm" value="PM"
        	        selectedValueBinding="rowVersionsEndTimeAmPm@defaultBean@pageContext"
                	textBinding="PM_LABEL@recoveryBundle@servletRequest"
                        styleClass="OraInstructionText" />
		</uix:rowLayout>
		</uix:tableLayout>
		</uix:rowLayout>
	       <uix:rowLayout --%>
<%-- SEARCH BTN --%>
		<%-- <uix:submitButton textBinding="SEARCH_BTN@recoveryBundle@servletRequest"
 			name="event" value="getRowVersions"/>
	       </uix:rowLayout>
	    </uix:tableLayout>
	     --%>
<%-- ROW VERSIONS RESULT LABEL --%>
	    <uix:header textBinding="ROW_VERSIONS_RESULT@recoveryBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<oem:table width = "100%" name="rowVersionsUIDataSource"
		    blockSize="10"
                    dataSourceProp="rowVersionsUIDataSource"
                    beanKey="rowVersionsDataSourceBean"
                    formSubmitted="true"
		    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		    copyParams="target,type"
        summaryBinding="RECOVERY_CHOOSE_PG@recoveryBundle@servletRequest">
		<uix:tableSelection>
		<oem:singleSelection  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
		    selectedIndexBinding="selectedIndex@rowVersionsDataSourceBean@servletRequest">
		  <%-- uix:submitButton textBinding="SHOW_TXN_INFO@recoveryBundle@servletRequest" name="event" value="showTxnInfo" / --%>
		</oem:singleSelection>
		</uix:tableSelection>
		</oem:table>
		<uix:messageText messageType="error" messageBinding="(ROW_VERSIONS_RESULT@recoveryBundle@servletRequest)@errors@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
	    </uix:header>

            <%-- <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                   <oem:radioButton name="advanceOperationType" value="flashback_table"
                                     selectedValueBinding="advanceOperationType@defaultBean@pageContext"
                                     textBinding="FLASHBACK_TB@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />

                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                   <oem:radioButton name="advanceOperationType" value="flashback_txn"
                                     selectedValueBinding="advanceOperationType@defaultBean@pageContext"
                                     textBinding="FLASHBACK_TXN@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout> --%>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="foo" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
