<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_DEPEND_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
          <uix:contents>
            <uix:styledText styleClass="OraInstructionText" textBinding="DEPENDENCIES_INTRO@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
		<uix:hGrid id="dependHGrid"
                           width="80%"
                           alternateTextBinding="NO_OBJ_FOUND@recoveryBundle@servletRequest"
                           destination="/em/console/database/rec/flashback"
                           formSubmitted="true"
			   columnFormatsBinding="columnFormats@dependBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@dependBean@servletRequest"
                           treeDataBinding="treeData@dependBean@servletRequest"
			   proxyBinding="proxy@servletRequest"
         summaryBinding="TABLE_DEPEND_COL@recoveryBundle@servletRequest">
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
		  	<uix:styledText textBinding="OWNER_COL@recoveryBundle@servletRequest"/>
                      </uix:columnHeader>
		  	<uix:styledText textBinding="owner"/>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
		    <uix:text textBinding="headerName"/>
                  </uix:columnHeaderStamp>

	  	<uix:styledText textBinding="tableName"/>
		<uix:formValue name="displayedItem" valueBinding="uniqueID"/>

		<uix:tableSelection>
		  <uix:multipleSelection disabledBinding="disabled"  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
					 selectedBinding="selected">
		  </uix:multipleSelection>
		</uix:tableSelection>
		</uix:hGrid>
              </uix:rowLayout>
            </uix:tableLayout>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="foo" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
