<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>


    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="ENTER_COL_NAME_TITLE@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<uix:location>
            <uix:train selectedIndex="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

          <uix:contents>
            <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout>
		<uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt labeledNodeId="tableName" promptBinding="TABLE_NAME_LABEL@recoveryBundle@servletRequest"/>
		</uix:cellFormat>
		<uix:cellFormat hAlign = "left" headers="">
		  <uix:textInput name="selectedTableName" id="tableName"
		    textBinding="evaluateTableName@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
		</uix:cellFormat>
	      </uix:rowLayout>
    	    </uix:tableLayout>
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<oem:table width = "100%" name="enterColUIDataSource"
		    blockSize="10"
                    dataSourceProp="selectColsUIDataSource"
                    beanKey="selectColsDataSourceBean"
                    formSubmitted="false"
		    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		    copyParams="target,type">
		<uix:tableSelection>
		<uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedIndexBinding="selectedIndex@selectColsDataSourceBean@servletRequest"/>
		</uix:tableSelection>
		</oem:table>
                </uix:cellFormat>
              </uix:rowLayout>
	    </uix:tableLayout>

      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="CANCEL@recoveryBundle@servletRequest" name="event" value="cancelFromEnterColNamePage" shortDescBinding="CANCEL@recoveryBundle@servletRequest" />
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle@servletRequest" name="event" value="okFromEnterColNamePage" shortDescBinding="OK_BTN@recoveryBundle@servletRequest" />
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
